/*****************************************************************************
 * Copyright (c) 2018 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 *  Matteo MORELLI      matteo.morelli@cea.fr - Bug #566899
 *
 *****************************************************************************/
 
package org.eclipse.papyrus.robotics.ros2.codegen.build

import org.eclipse.uml2.uml.Class
import org.eclipse.uml2.uml.Package
import static extension org.eclipse.papyrus.robotics.ros2.codegen.utils.SkillUtils.*
import static extension org.eclipse.papyrus.robotics.ros2.codegen.utils.PackageTools.pkgName
import static extension org.eclipse.papyrus.robotics.ros2.codegen.utils.ActivityUtils.hasExternalCode
import static extension org.eclipse.papyrus.robotics.ros2.codegen.utils.ComponentUtils.isRegistered
import org.eclipse.papyrus.infra.tools.file.IPFileSystemAccess
import java.util.List
import org.eclipse.papyrus.robotics.ros2.codegen.component.CodeSkeleton
import java.util.Collections
import org.eclipse.papyrus.designer.languages.common.base.file.ProtSection
import org.eclipse.uml2.uml.NamedElement

/**
 * Create CMakeLists file for a component definition
 */
class CreateCompCMakeLists {
	static def createCMakeLists(Package pkg, List<Class> components, Class system) '''
		cmake_minimum_required(VERSION 3.5.0)
		project(«pkg.pkgName»)

		# Default to C++14
		if(NOT CMAKE_CXX_STANDARD)
		  set(CMAKE_CXX_STANDARD 14)
		endif()

		if(CMAKE_COMPILER_IS_GNUCXX OR CMAKE_CXX_COMPILER_ID MATCHES "Clang")
		  add_compile_options(-Wall -Wextra -Wpedantic)
		endif()

		find_package(ament_cmake REQUIRED)
		«FOR msg_pkg : CreateCompPackageXML.calcDependencies(components)»
			find_package(«msg_pkg» REQUIRED)
		«ENDFOR»
		«IF !system.uniqueSkills.nullOrEmpty»
			find_package(«pkg.realizationPackageName» REQUIRED)
		«ENDIF»

		include_directories(
			# assure that generated .h files are found
			${PROJECT_SOURCE_DIR}/src
			${PROJECT_SOURCE_DIR}/src-gen
		)

		«FOR component : components»
			«val compBaseFile = component.fileName»
			«IF component.isRegistered»
				add_library(«component.name»_comp SHARED
					src-gen/«compBaseFile».cpp«
					IF component.hasExternalCode»
						src/«compBaseFile»«CodeSkeleton.POSTFIX».cpp
					«ENDIF»
				)
				target_compile_definitions(«component.name»_comp
					PRIVATE "«component.name»_shared_library")
				ament_target_dependencies(«component.name»_comp
					«component.msgDependencies»
					«IF !system.uniqueSkills.nullOrEmpty»
						«pkg.realizationPackageName»
					«ENDIF»
				)
				rclcpp_components_register_nodes(«component.name»_comp "«pkg.pkgName»::«component.name»")
				
				add_executable(«component.name»_main src-gen/«compBaseFile»_main.cpp)
				target_link_libraries(«component.name»_main «component.name»_comp)
				ament_target_dependencies(«component.name»_main rclcpp)

			«ELSE»
				add_executable(«component.name»
					src-gen/«compBaseFile».cpp
					src-gen/«compBaseFile»_main.cpp
					«IF component.hasExternalCode»
						src/«compBaseFile»«CodeSkeleton.POSTFIX».cpp«
					ENDIF»
				)
				ament_target_dependencies(«component.name»
					«component.msgDependencies»
					«IF !system.uniqueSkills.nullOrEmpty»
						«pkg.realizationPackageName»
					«ENDIF»
				)

			«ENDIF»
		«ENDFOR»

		# «ProtSection.protSection("dependencies")»
		# «ProtSection.protSection»

		«FOR component : components»
			install(TARGETS
				«IF component.isRegistered»
					«component.name»_main
					«component.name»_comp
				«ELSE»
					«component.name»
				«ENDIF»
				DESTINATION lib/${PROJECT_NAME}
			)
		«ENDFOR»
		«IF system !== null»

			# Install launch files.
			install(DIRECTORY
				launch
				DESTINATION share/${PROJECT_NAME}/
			)
		«ENDIF»
		ament_package()
	'''

	static def msgDependencies(Class component) '''
		«FOR msg_pkg : CreateCompPackageXML.calcDependencies(Collections.singletonList(component))»
			«msg_pkg»
		«ENDFOR»
	'''

	static def generate(IPFileSystemAccess fileAccess, Package pkg, List<Class> components, Class system) {
		fileAccess.generateFile("CMakeLists.txt", createCMakeLists(pkg, components, system).toString)
	}

	static def fileName(NamedElement ne) {
		ne.qualifiedName.replace("::", "/")
	}
}