/*****************************************************************************
 * Copyright (c) 2018 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 * 
 *****************************************************************************/

package org.eclipse.papyrus.robotics.ros2.codegen

import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ProjectTools
import org.eclipse.uml2.uml.Package

import static extension org.eclipse.papyrus.robotics.ros2.codegen.utils.PackageTools.*

class CopyPackageModels implements IM2MTrafoCDP {

	override applyTrafo(M2MTrafo trafo, Package rootPkg) throws TransformationException {
		// assure that Common and C++ profiles is applied
		val project = ProjectTools.getProject(TransformationContext.initialSourceRoot.projectName)
		if (project !== null) {
			project.compDefs
			project.system
		}
		else {
			Activator.log.debug(
				"can not determine project (is generator called from a model within a registered plugin")
		}
	}
}
