/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentPort;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentService;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PortUtils {
    public static EList<Port> getAllPorts(EncapsulatedClassifier ec) {
        BasicEList ports = new BasicEList();
        for (Property attribute : ec.getAllAttributes()) {
            if (!(attribute instanceof Port)) continue;
            ports.add((Object)((Port)attribute));
        }
        return ports;
    }

    public static List<ComponentPort> getPortList(Class clazz) {
        ArrayList<ComponentPort> cpList = new ArrayList<ComponentPort>();
        for (Port port : clazz.getOwnedPorts()) {
            ComponentPort cp = (ComponentPort)UMLUtil.getStereotypeApplication((Element)port, ComponentPort.class);
            if (cp == null) continue;
            cpList.add(cp);
        }
        return cpList;
    }

    public static ICommand associateCSCommand(final Port port) {
        RecordingCommand associateCS = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)port), "Associate component-service command"){

            protected void doExecute() {
                Class clazz = port.getClass_();
                Class cs = (Class)clazz.createNestedClassifier(null, UMLPackage.eINSTANCE.getClass_());
                StereotypeUtil.apply((Element)cs, ComponentService.class);
                port.setType((Type)cs);
            }
        };
        return EMFtoGMFCommandWrapper.wrap((Command)associateCS);
    }

    public static ICommand setPartWithPortCommand(ConnectorEnd end) {
        Class activity;
        Property activityInstance;
        IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)end);
        if (end.getRole() instanceof Port && (activityInstance = PortUtils.getActivityInstance(activity = ((Port)end.getRole()).getClass_())) != null) {
            SetRequest setPWPReq = new SetRequest((EObject)end, (EStructuralFeature)UMLPackage.eINSTANCE.getConnectorEnd_PartWithPort(), (Object)activityInstance);
            ICommand setPWPCmd = commandProvider.getEditCommand((IEditCommandRequest)setPWPReq);
            return setPWPCmd;
        }
        return null;
    }

    public static Property getActivityInstance(Class activity) {
        Class component = (Class)activity.getOwner();
        for (Property part : component.getOwnedAttributes()) {
            if (part.getType() != activity) continue;
            return part;
        }
        return null;
    }

    public static String getPortLabel(Port port) {
        String label = port.getName();
        if (port.getProvideds().size() > 0) {
            label = String.valueOf(label) + " provides " + ((Interface)port.getProvideds().get(0)).getName();
        }
        if (port.getRequireds().size() > 0) {
            label = String.valueOf(label) + " requires " + ((Interface)port.getRequireds().get(0)).getName();
        }
        return label;
    }

    public static boolean isCSDuplicate(Port port) {
        Type type = port.getType();
        if (type != null && StereotypeUtil.isApplied((Element)type, ComponentService.class)) {
            for (EStructuralFeature.Setting setting : UMLUtil.getNonNavigableInverseReferences((EObject)type)) {
                EObject eObj = setting.getEObject();
                if (!(eObj instanceof Port) || eObj == port) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCoordinationPort(Port port) {
        ComponentPort cp = (ComponentPort)UMLUtil.getStereotypeApplication((Element)port, ComponentPort.class);
        if (cp != null) {
            return cp.isCoordinationPort();
        }
        return false;
    }
}

