/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.xtext.datatypes.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.robotics.xtext.datatypes.dTML.DTMLPackage;
import org.eclipse.papyrus.robotics.xtext.datatypes.dTML.Property;
import org.eclipse.papyrus.robotics.xtext.datatypes.dTML.Value;
import org.eclipse.papyrus.robotics.xtext.datatypes.dTML.XAssignment;
import org.eclipse.papyrus.robotics.xtext.datatypes.dTML.XDataType;
import org.eclipse.papyrus.robotics.xtext.datatypes.dTML.XEnumLiteral;
import org.eclipse.papyrus.robotics.xtext.datatypes.dTML.XEnumeration;
import org.eclipse.papyrus.robotics.xtext.datatypes.services.DTMLGrammarAccess;
import org.eclipse.papyrus.uml.textedit.common.xtext.serializer.UmlCommonSemanticSequencer;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.BoundSpecification;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.MultiplicityRule;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.QualifiedName;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.TypeRule;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.UmlCommonPackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

public class DTMLSemanticSequencer
extends UmlCommonSemanticSequencer {
    @Inject
    private DTMLGrammarAccess grammarAccess;

    public void sequence(ISerializationContext context, EObject semanticObject) {
        EPackage epackage = semanticObject.eClass().getEPackage();
        ParserRule rule = context.getParserRule();
        Action action = context.getAssignedAction();
        Set parameters = context.getEnabledBooleanParameters();
        if (epackage == DTMLPackage.eINSTANCE) {
            switch (semanticObject.eClass().getClassifierID()) {
                case 2: {
                    this.sequence_Property(context, (Property)semanticObject);
                    return;
                }
                case 4: {
                    this.sequence_Value(context, (Value)semanticObject);
                    return;
                }
                case 3: {
                    this.sequence_XAssignment(context, (XAssignment)semanticObject);
                    return;
                }
                case 1: {
                    this.sequence_XDataType(context, (XDataType)semanticObject);
                    return;
                }
                case 6: {
                    this.sequence_XEnumLiteral(context, (XEnumLiteral)semanticObject);
                    return;
                }
                case 5: {
                    this.sequence_XEnumeration(context, (XEnumeration)semanticObject);
                    return;
                }
            }
        } else if (epackage == UmlCommonPackage.eINSTANCE) {
            switch (semanticObject.eClass().getClassifierID()) {
                case 3: {
                    this.sequence_BoundSpecification(context, (BoundSpecification)semanticObject);
                    return;
                }
                case 2: {
                    this.sequence_MultiplicityRule(context, (MultiplicityRule)semanticObject);
                    return;
                }
                case 0: {
                    this.sequence_QualifiedName(context, (QualifiedName)semanticObject);
                    return;
                }
                case 1: {
                    this.sequence_TypeRule(context, (TypeRule)semanticObject);
                    return;
                }
            }
        }
        if (this.errorAcceptor != null) {
            this.errorAcceptor.accept(this.diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
        }
    }

    protected void sequence_Property(ISerializationContext context, Property semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Value(ISerializationContext context, Value semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_XAssignment(ISerializationContext context, XAssignment semanticObject) {
        if (this.errorAcceptor != null) {
            if (this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)DTMLPackage.Literals.MODEL__NAME) == ITransientValueService.ValueTransient.YES) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)DTMLPackage.Literals.MODEL__NAME));
            }
            if (this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)DTMLPackage.Literals.XASSIGNMENT__EXPRESSION) == ITransientValueService.ValueTransient.YES) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)DTMLPackage.Literals.XASSIGNMENT__EXPRESSION));
            }
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getXAssignmentAccess().getNameIDTerminalRuleCall_0_0(), (Object)semanticObject.getName());
        feeder.accept(this.grammarAccess.getXAssignmentAccess().getExpressionExpressionStringParserRuleCall_2_0(), (Object)semanticObject.getExpression());
        feeder.finish();
    }

    protected void sequence_XDataType(ISerializationContext context, XDataType semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_XEnumLiteral(ISerializationContext context, XEnumLiteral semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_XEnumeration(ISerializationContext context, XEnumeration semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }
}

