/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.languages.ocl;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.uml.UMLOCL;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.OCLHelper;
import org.eclipse.papyrus.robotics.assertions.languages.IExpressionLanguage;

public class OCLExpressionLanguage
implements IExpressionLanguage {
    @Override
    public String getName() {
        return "OCL";
    }

    @Override
    public Object evaluate(EObject context, String expression) {
        MetamodelManager metamodelManager = OCLExpressionLanguage.getMetamodelManager(context);
        EnvironmentFactory environmentFactory = metamodelManager.getEnvironmentFactory();
        OCL ocl = OCL.newInstance((EnvironmentFactory)environmentFactory);
        Class contextType = ocl.getContextType((Object)context);
        try {
            OCLHelper oclHelper = ocl.createOCLHelper((EObject)contextType);
            ExpressionInOCL createQuery = oclHelper.createQuery(expression);
            Object evaluate = ocl.evaluate((Object)context, createQuery);
            return evaluate;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected static MetamodelManager getMetamodelManager(EObject contextObject) {
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.findEnvironmentFactory((EObject)contextObject);
        if (environmentFactory != null) {
            return environmentFactory.getMetamodelManager();
        }
        return UMLOCL.newInstance().getMetamodelManager();
    }
}

