/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.xtext.datatypes.ui.contribution;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.robotics.bpc.profile.bpc.Entity;
import org.eclipse.papyrus.robotics.profile.robotics.commobject.CommunicationObject;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

public class UnparseDT {
    public static final String WRONG_OBJECT = "Unexpected editor object";

    public static CharSequence getDTtext(DataType dt) {
        StringConcatenation _builder = new StringConcatenation();
        String _commObjOrDT = UnparseDT.commObjOrDT(dt);
        _builder.append(_commObjOrDT);
        _builder.append(" ");
        String _name = dt.getName();
        _builder.append(_name);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        EList _ownedAttributes = dt.getOwnedAttributes();
        for (Property attribute : _ownedAttributes) {
            _builder.append("\t");
            _builder.append("attribute ");
            String _name_1 = attribute.getName();
            _builder.append(_name_1, "\t");
            _builder.append(" : ");
            String _undefOrQName = UnparseDT.undefOrQName(attribute.getType());
            _builder.append(_undefOrQName, "\t");
            String _multiplicity = UnparseDT.getMultiplicity(attribute);
            _builder.append(_multiplicity, "\t");
            String _comment = UnparseDT.getComment((Element)attribute);
            _builder.append(_comment, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence getEnumText(Enumeration enumeration) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Enumeration ");
        String _name = enumeration.getName();
        _builder.append(_name);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        EList _ownedLiterals = enumeration.getOwnedLiterals();
        for (EnumerationLiteral literal : _ownedLiterals) {
            _builder.append("\t");
            String _name_1 = literal.getName();
            _builder.append(_name_1, "\t");
            String _defaultValue = UnparseDT.defaultValue(literal);
            _builder.append(_defaultValue, "\t");
            String _comment = UnparseDT.getComment((Element)literal);
            _builder.append(_comment, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static String defaultValue(EnumerationLiteral literal) {
        ValueSpecification _specification = literal.getSpecification();
        if (_specification instanceof ValueSpecification) {
            String _stringValue = literal.getSpecification().stringValue();
            return " = " + _stringValue;
        }
        return "";
    }

    public static String getMultiplicity(Property attribute) {
        boolean _notEquals;
        boolean _equals;
        int _upper = attribute.getUpper();
        boolean bl = _equals = _upper == -1;
        if (_equals) {
            return " [*]";
        }
        int _upper_1 = attribute.getUpper();
        boolean bl2 = _notEquals = _upper_1 != 1;
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(" ");
            _builder.append("[");
            int _upper_2 = attribute.getUpper();
            _builder.append((Object)_upper_2, " ");
            _builder.append("]");
            return _builder.toString();
        }
        return "";
    }

    public static String getComment(Element element) {
        Entity entity = (Entity)UMLUtil.getStereotypeApplication((Element)element, Entity.class);
        if (entity != null && entity.getDescription() != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("\t");
            _builder.append("// ");
            String _description = entity.getDescription();
            _builder.append(_description, "\t");
            return _builder.toString();
        }
        return "";
    }

    public static String undefOrQName(Type type) {
        if (type == null) {
            return "<Undefined>";
        }
        return type.getQualifiedName();
    }

    public static String commObjOrDT(DataType dt) {
        String _xifexpression = null;
        boolean _isApplied = StereotypeUtil.isApplied((Element)dt, CommunicationObject.class);
        _xifexpression = _isApplied ? "CommObject" : "DataType";
        return _xifexpression;
    }
}

