/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.diagrams.advices;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.robotics.core.commands.CancelCommand;
import org.eclipse.papyrus.robotics.core.utils.NamingUtil;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class SkillDefinitionEditHelperAdvice
extends AbstractEditHelperAdvice {
    private static final String SKILLDEF_PREFIX = "SkillDefinition";
    private static final String SKILLDEF_DEFAULT_SEMANTICS_NAME_SUFFIX = "DefaultFSM";
    private static final String SKILLDEF_DEFAULT_SEMANTICS_PKG_NAME = "defaultsemantics";
    private static final String SKILLDEF_DEFAULT_SEMANTICS_TEMPLATE_NAME = "DefaultSkillFSMTemplate";
    boolean errShown = false;
    StateMachine defSemantics;
    Package destPkg;
    StateMachine newDefSemantics;

    protected static String calcFSMName(String skdefName) {
        return String.valueOf(skdefName) + SKILLDEF_DEFAULT_SEMANTICS_NAME_SUFFIX;
    }

    protected static StateMachine getDefaultSemantics(Operation op) {
        SkillDefinition skdef;
        StateMachine fsm = null;
        if (op != null && (skdef = (SkillDefinition)UMLUtil.getStereotypeApplication((Element)op, SkillDefinition.class)).getDefaultSemantic() != null) {
            fsm = skdef.getDefaultSemantic().getBase_StateMachine();
        }
        return fsm;
    }

    protected static void displayErrorMsgForSkillModelsUnableToManageFSM() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot modify the current model", (String)String.format("The current model does not support the definition of SkillSemantics.\nSee https://wiki.eclipse.org/Papyrus/customizations/robotics/faq#Q:_I_get_the_error_.22Cannot_modify_the_current_model.22_when_I_try_to_modify_an_existing_skill_model", new Object[0]));
            }
        });
    }

    public ICommand getBeforeEditCommand(IEditCommandRequest request) {
        Object elem;
        if (!(request instanceof GetEditContextRequest || request instanceof SetRequest || request instanceof DestroyDependentsRequest)) {
            return super.getBeforeEditCommand(request);
        }
        Model umlModel = null;
        if (request instanceof GetEditContextRequest) {
            elem = ((GetEditContextRequest)request).getEditContext();
            if (elem instanceof Interface) {
                umlModel = ((Interface)elem).getModel();
            }
        } else {
            elem = null;
            if (request instanceof SetRequest) {
                elem = ((SetRequest)request).getElementToEdit();
            } else if (request instanceof DestroyDependentsRequest) {
                elem = ((DestroyDependentsRequest)request).getElementToDestroy();
            }
            if (elem instanceof Operation) {
                umlModel = ((Operation)elem).getModel();
            }
        }
        if (umlModel != null) {
            this.destPkg = null;
            for (Element e : umlModel.allOwnedElements()) {
                if (!(e instanceof Package) || !((Package)e).getName().equals(SKILLDEF_DEFAULT_SEMANTICS_PKG_NAME)) continue;
                this.destPkg = (Package)e;
            }
            this.defSemantics = null;
            for (PackageImport pi : umlModel.getPackageImports()) {
                NamedElement el = pi.getImportedPackage().getOwnedMember(SKILLDEF_DEFAULT_SEMANTICS_TEMPLATE_NAME);
                if (el == null) continue;
                this.defSemantics = (StateMachine)el;
            }
            if (this.destPkg != null && this.defSemantics != null) {
                this.errShown = false;
                return super.getBeforeEditCommand(request);
            }
            SkillDefinitionEditHelperAdvice.displayErrorMsgForSkillModelsUnableToManageFSM();
            this.errShown = true;
        }
        return null;
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        EObject newElement = request.getElementToConfigure();
        if (!(newElement instanceof Operation)) {
            return super.getAfterConfigureCommand(request);
        }
        final Operation op = (Operation)newElement;
        final Model umlModel = op.getModel();
        CompositeCommand compositeCommand = new CompositeCommand("SkillDefinition configuration command");
        RecordingCommand setNameCmd = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)op)){

            protected void doExecute() {
                NamingUtil.setName((NamedElement)op, (String)SkillDefinitionEditHelperAdvice.SKILLDEF_PREFIX);
            }
        };
        setNameCmd.execute();
        if (this.destPkg == null) {
            for (Element e : umlModel.allOwnedElements()) {
                if (!(e instanceof Package) || !((Package)e).getName().equals(SKILLDEF_DEFAULT_SEMANTICS_PKG_NAME)) continue;
                this.destPkg = (Package)e;
            }
        }
        if (this.defSemantics == null) {
            for (PackageImport pi : umlModel.getPackageImports()) {
                NamedElement el = pi.getImportedPackage().getOwnedMember(SKILLDEF_DEFAULT_SEMANTICS_TEMPLATE_NAME);
                if (el == null) continue;
                this.defSemantics = (StateMachine)el;
            }
        }
        RecordingCommand copyDefSemantics = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)this.defSemantics)){

            protected void addFSMStereotypesToResources(StateMachine copy, StateMachine orig) {
                UMLUtil.safeApplyStereotype((Element)copy, (Stereotype)((Stereotype)orig.getAppliedStereotypes().get(0)));
                TreeIterator copyIterator = copy.eAllContents();
                TreeIterator origIterator = orig.eAllContents();
                while (origIterator.hasNext()) {
                    EObject copyObj = (EObject)copyIterator.next();
                    EObject origObj = (EObject)origIterator.next();
                    if (!(origObj instanceof Element)) continue;
                    for (Stereotype s : ((Element)origObj).getAppliedStereotypes()) {
                        UMLUtil.safeApplyStereotype((Element)((Element)copyObj), (Stereotype)s);
                    }
                }
            }

            protected void doExecute() {
                LazyCopier copier = new LazyCopier((Package)umlModel, SkillDefinitionEditHelperAdvice.this.destPkg, LazyCopier.CopyExtResources.ALL, false);
                SkillDefinitionEditHelperAdvice.this.newDefSemantics = (StateMachine)copier.getCopy((Element)SkillDefinitionEditHelperAdvice.this.defSemantics);
                SkillDefinitionEditHelperAdvice.this.newDefSemantics.setName(SkillDefinitionEditHelperAdvice.calcFSMName(op.getName()));
                SkillDefinitionEditHelperAdvice.this.destPkg.getPackagedElements().add((Object)SkillDefinitionEditHelperAdvice.this.newDefSemantics);
                this.addFSMStereotypesToResources(SkillDefinitionEditHelperAdvice.this.newDefSemantics, SkillDefinitionEditHelperAdvice.this.defSemantics);
            }
        };
        copyDefSemantics.execute();
        RecordingCommand assignDefFSMCmd = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)this.defSemantics)){

            protected void doExecute() {
                op.getMethods().add((Object)SkillDefinitionEditHelperAdvice.this.newDefSemantics);
            }
        };
        compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)assignDefFSMCmd));
        RecordingCommand applySkillDefStereotypeCmd = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)newElement)){

            protected void doExecute() {
                StereotypeUtil.apply((Element)op, SkillDefinition.class);
            }
        };
        compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)applySkillDefStereotypeCmd));
        return compositeCommand.isEmpty() ? super.getAfterConfigureCommand(request) : compositeCommand;
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        if (this.errShown) {
            return new CancelCommand(request.getElementToEdit());
        }
        EStructuralFeature feat = request.getFeature();
        EObject newElement = request.getElementToEdit();
        if (!feat.getName().equals("name") || !(newElement instanceof Operation)) {
            return super.getAfterSetCommand(request);
        }
        Operation op = (Operation)newElement;
        String newName = (String)request.getValue();
        CompositeCommand compositeCommand = new CompositeCommand("SkillDefinition/SkillSemantic name synch command");
        StateMachine fsm = SkillDefinitionEditHelperAdvice.getDefaultSemantics(op);
        if (fsm != null) {
            ICommand setNameCmd = ElementEditServiceUtils.getCommandProvider((EObject)op).getEditCommand((IEditCommandRequest)new SetRequest((EObject)fsm, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)SkillDefinitionEditHelperAdvice.calcFSMName(newName)));
            compositeCommand.add((IUndoableOperation)setNameCmd);
        }
        return compositeCommand.isEmpty() ? super.getAfterSetCommand(request) : compositeCommand;
    }

    protected ICommand getBeforeDestroyElementCommand(DestroyElementRequest request) {
        if (this.errShown) {
            return new CancelCommand(request.getElementToDestroy());
        }
        return super.getBeforeDestroyElementCommand(request);
    }

    protected ICommand getAfterDestroyDependentsCommand(DestroyDependentsRequest request) {
        if (this.errShown) {
            return new CancelCommand(request.getElementToDestroy());
        }
        CompositeCommand compositeCommand = new CompositeCommand("Skill definition destruction command");
        EObject destroyElement = request.getElementToDestroy();
        if (!(destroyElement instanceof Operation)) {
            return super.getAfterDestroyDependentsCommand(request);
        }
        Operation op = (Operation)destroyElement;
        StateMachine fsm = SkillDefinitionEditHelperAdvice.getDefaultSemantics(op);
        if (fsm != null) {
            IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)op);
            DestroyElementRequest destroyDepReq = new DestroyElementRequest((EObject)fsm, false);
            ICommand destroyDepCmd = commandProvider.getEditCommand((IEditCommandRequest)destroyDepReq);
            compositeCommand.add((IUndoableOperation)destroyDepCmd);
        }
        return compositeCommand.isEmpty() ? super.getAfterDestroyDependentsCommand(request) : compositeCommand;
    }
}

