/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.utils;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.robotics.profile.robotics.behavior.Task;
import org.eclipse.papyrus.robotics.profile.robotics.components.System;
import org.eclipse.papyrus.robotics.profile.robotics.services.CoordinationService;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillOperationalState;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillParameter;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillSemantic;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.Helpers;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.MessageUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.PackageTools;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class SkillUtils {
    public static String realizationPackageName(Package pkg) {
        try {
            if (pkg == null) {
                throw new Exception("Model error! Can''t access the skill realization model!");
            }
            String _pkgName = PackageTools.pkgName(pkg);
            return String.valueOf(_pkgName) + "_skillrealizations";
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static LinkedHashSet<SkillDefinition> getUniqueSkills(System sys) {
        LinkedHashSet<SkillDefinition> res = new LinkedHashSet<SkillDefinition>();
        if (sys != null) {
            EList _task = sys.getTask();
            for (Task task : _task) {
                res.addAll((Collection<SkillDefinition>)task.getSkills());
            }
        }
        return res;
    }

    public static String getName(SkillDefinition sdef) {
        if (sdef != null) {
            return sdef.getBase_Operation().getName();
        }
        return "";
    }

    public static DataType getType(SkillParameter param) {
        Type _type;
        if (param != null && (_type = param.getBase_Parameter().getType()) instanceof DataType) {
            Type _type_1 = param.getBase_Parameter().getType();
            return (DataType)_type_1;
        }
        return null;
    }

    public static LinkedHashSet<DataType> getUniqueSkillParameterTypes(SkillDefinition skill) {
        LinkedHashSet<DataType> res = new LinkedHashSet<DataType>();
        if (skill != null) {
            EList _ins = skill.getIns();
            EList _outs = skill.getOuts();
            Iterable _plus = Iterables.concat((Iterable)_ins, (Iterable)_outs);
            for (SkillParameter p : _plus) {
                res.add(SkillUtils.getType(p));
            }
        }
        return res;
    }

    public static String getROS2TypeIncludePath(DataType tp) {
        if (tp != null) {
            String _escapeCamlCase = Helpers.escapeCamlCase(MessageUtils.getROS2qMsgName(tp));
            return String.valueOf(_escapeCamlCase) + ".hpp";
        }
        return "";
    }

    public static String getName(SkillParameter param) {
        if (param != null) {
            return param.getBase_Parameter().getName();
        }
        return null;
    }

    public static SkillOperationalState getFirstOpState(SkillSemantic sem) {
        if (sem != null) {
            return (SkillOperationalState)sem.getOperational().get(0);
        }
        return null;
    }

    public static boolean doesConfigAndCoordOfComponents(SkillOperationalState ops) {
        if (ops != null) {
            boolean _tripleNotEquals;
            CoordinationService _compInterface = ops.getCompInterface();
            boolean bl = _tripleNotEquals = _compInterface != null;
            if (_tripleNotEquals) {
                return true;
            }
        }
        return false;
    }

    public static String getCoordinationIfQn(SkillOperationalState ops) {
        boolean _doesConfigAndCoordOfComponents = SkillUtils.doesConfigAndCoordOfComponents(ops);
        if (_doesConfigAndCoordOfComponents) {
            String qName = MessageUtils.getROS2qMsgName(ops.getCompInterface().getBase_Interface());
            return qName.replace("/", "::");
        }
        return "";
    }

    public static String getCoordinationIfIncludePath(SkillOperationalState ops) {
        boolean _doesConfigAndCoordOfComponents = SkillUtils.doesConfigAndCoordOfComponents(ops);
        if (_doesConfigAndCoordOfComponents) {
            String qName = MessageUtils.getROS2qMsgName(ops.getCompInterface().getBase_Interface());
            String _escapeCamlCase = Helpers.escapeCamlCase(qName);
            return String.valueOf(_escapeCamlCase) + ".hpp";
        }
        return "";
    }

    public static Interface getCompInterface(SkillOperationalState ops) {
        boolean _doesConfigAndCoordOfComponents = SkillUtils.doesConfigAndCoordOfComponents(ops);
        if (_doesConfigAndCoordOfComponents) {
            return ops.getCompInterface().getBase_Interface();
        }
        return null;
    }

    public static String realizationFileName(SkillDefinition sdef) {
        try {
            if (sdef == null) {
                throw new Exception("Model error! Found UML::Operation with no stereotype applied!");
            }
            String _lowerCase = String.join((CharSequence)"_", sdef.getBase_Operation().getName().split("(?<=.)(?=\\p{Lu})")).toLowerCase();
            return String.valueOf(_lowerCase) + "_action";
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String realizationFileName(SkillDefinition sdef, SkillSemantic sem, SkillOperationalState ops) {
        try {
            boolean _tripleNotEquals;
            boolean _not;
            if (sdef == null) {
                String _name = sdef.getBase_Operation().getName();
                String _plus = "Model error! " + _name;
                String _plus_1 = String.valueOf(_plus) + " has no stereotype applied!";
                throw new Exception(_plus_1);
            }
            if (sem == null) {
                String _name_1 = sem.getBase_StateMachine().getName();
                String _plus_2 = "Model error! " + _name_1;
                String _plus_3 = String.valueOf(_plus_2) + " has no stereotype applied!";
                throw new Exception(_plus_3);
            }
            if (ops == null) {
                String _name_2 = ops.getBase_State().getName();
                String _plus_4 = "Model error! " + _name_2;
                String _plus_5 = String.valueOf(_plus_4) + " has no stereotype applied!";
                throw new Exception(_plus_5);
            }
            boolean _contains = sem.getOperational().contains((Object)ops);
            boolean bl = _not = !_contains;
            if (_not) {
                String _name_3 = ops.getBase_State().getName();
                String _plus_6 = "Model error! " + _name_3;
                String _plus_7 = String.valueOf(_plus_6) + " is not a state of ";
                String _name_4 = sem.getBase_StateMachine().getName();
                String _plus_8 = String.valueOf(_plus_7) + _name_4;
                throw new Exception(_plus_8);
            }
            String realizBaseName = String.join((CharSequence)"_", sdef.getBase_Operation().getName().split("(?<=.)(?=\\p{Lu})")).toLowerCase();
            SkillSemantic _defaultSemantic = sdef.getDefaultSemantic();
            boolean bl2 = _tripleNotEquals = _defaultSemantic != sem;
            if (_tripleNotEquals) {
                String _realizBaseName = realizBaseName;
                String _lowerCase = sem.getBase_StateMachine().getName().toLowerCase();
                String _plus_9 = "_" + _lowerCase;
                String _plus_10 = String.valueOf(_plus_9) + "_";
                String _lowerCase_1 = ops.getBase_State().getName().toLowerCase();
                String _plus_11 = String.valueOf(_plus_10) + _lowerCase_1;
                realizBaseName = String.valueOf(_realizBaseName) + _plus_11;
            }
            return String.valueOf(realizBaseName) + "_action_bt_node";
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean doesConfigAndCoordOfComponents(State st) {
        return SkillUtils.doesConfigAndCoordOfComponents((SkillOperationalState)UMLUtil.getStereotypeApplication((Element)st, SkillOperationalState.class));
    }

    public static LinkedHashSet<SkillDefinition> getUniqueSkills(Class sys) {
        return SkillUtils.getUniqueSkills((System)UMLUtil.getStereotypeApplication((Element)sys, System.class));
    }
}

