/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.component;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ConstInit;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.core.utils.PortUtils;
import org.eclipse.papyrus.robotics.profile.robotics.commpattern.CommunicationPattern;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentPort;
import org.eclipse.papyrus.robotics.ros2.codegen.component.Callbacks;
import org.eclipse.papyrus.robotics.ros2.codegen.launch.LaunchScript;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ApplyProfiles;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.Helpers;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.MessageUtils;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

public class Constructor {
    public static boolean createConstructor(Class component) {
        boolean _xblockexpression = false;
        Type lcNodeSC = Helpers.getRosType((Element)component, "ros2Library::rclcpp_lifecycle::LifecycleNode");
        if (lcNodeSC instanceof Classifier) {
            component.createGeneralization((Classifier)lcNodeSC);
        }
        Operation op = Constructor.addConstrOp(component);
        _xblockexpression = Constructor.addConstrMethod(component, op);
        return _xblockexpression;
    }

    public static Operation addConstrOp(Class component) {
        ConstInit constInit;
        Type nodeOptions = Helpers.getRosType((Element)component, "ros2Library::rclcpp::NodeOptions");
        Operation init = component.createOwnedOperation(component.getName(), null, null);
        init.createOwnedParameter("options", nodeOptions);
        Create create = (Create)StereotypeUtil.applyApp((Element)init, Create.class);
        if (create == null) {
            ApplyProfiles.applyStdProfile((Element)init);
            create = (Create)StereotypeUtil.applyApp((Element)init, Create.class);
        }
        if ((constInit = (ConstInit)StereotypeUtil.applyApp((Element)init, ConstInit.class)) == null) {
            ApplyProfiles.applyCppProfile((Element)init);
            constInit = (ConstInit)StereotypeUtil.applyApp((Element)init, ConstInit.class);
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("rclcpp_lifecycle::LifecycleNode(\"");
        String _name = component.getName();
        _builder.append(_name);
        _builder.append("\", options)");
        constInit.setInitialisation(_builder.toString());
        return init;
    }

    public static boolean addConstrMethod(Class component, Operation constructorOp) {
        boolean _xblockexpression = false;
        Behavior _createOwnedBehavior = component.createOwnedBehavior(component.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
        OpaqueBehavior ob = (OpaqueBehavior)_createOwnedBehavior;
        constructorOp.getMethods().add((Object)ob);
        ob.getLanguages().add((Object)"C++");
        EList _bodies = ob.getBodies();
        StringConcatenation _builder = new StringConcatenation();
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)component);
        for (Port port : _allPorts) {
            boolean _tripleNotEquals;
            CommunicationPattern _communicationPattern = InteractionUtils.getCommunicationPattern((Port)port);
            boolean bl = _tripleNotEquals = _communicationPattern != null;
            if (!_tripleNotEquals) continue;
            CommunicationPattern pattern = InteractionUtils.getCommunicationPattern((Port)port);
            _builder.newLineIfNotEmpty();
            boolean _isPush = InteractionUtils.isPush((CommunicationPattern)pattern);
            if (_isPush) {
                CharSequence _createPush = Constructor.createPush(port);
                _builder.append((Object)_createPush);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                continue;
            }
            boolean _isSend = InteractionUtils.isSend((CommunicationPattern)pattern);
            if (_isSend) {
                CharSequence _createSend = Constructor.createSend(port);
                _builder.append((Object)_createSend);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                continue;
            }
            boolean _isQuery = InteractionUtils.isQuery((CommunicationPattern)pattern);
            if (_isQuery) {
                CharSequence _createQuery = Constructor.createQuery(port);
                _builder.append((Object)_createQuery);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                continue;
            }
            boolean _isAction = InteractionUtils.isAction((CommunicationPattern)pattern);
            if (_isAction) {
                CharSequence _createAction = Constructor.createAction(port);
                _builder.append((Object)_createAction);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                continue;
            }
            boolean bl2 = InteractionUtils.isEvent((CommunicationPattern)pattern);
        }
        _xblockexpression = _bodies.add((Object)_builder.toString());
        return _xblockexpression;
    }

    public static CharSequence createPush(Port port) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _size = port.getProvideds().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            String _name = port.getName();
            _builder.append(_name);
            _builder.append("_pub_ = create_publisher<");
            String _externalName = Helpers.externalName(InteractionUtils.getCommObject((Port)port));
            _builder.append(_externalName);
            _builder.append(">(\"");
            CharSequence _topic = LaunchScript.getTopic(port);
            _builder.append((Object)_topic);
            _builder.append("\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            String _qos = Constructor.qos(port, "1");
            _builder.append(_qos, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("// directly activate a publisher");
            _builder.newLine();
            String _name_1 = port.getName();
            _builder.append(_name_1);
            _builder.append("_pub_->on_activate();");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _greaterThan_1;
            int _size_1 = port.getRequireds().size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                String defaultQoS = "rclcpp::QoS(rclcpp::KeepLast(100)).best_effort()";
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _name_2 = port.getName();
                _builder.append(_name_2, "\t");
                _builder.append("_sub_ = create_subscription<");
                String _externalName_1 = Helpers.externalName(InteractionUtils.getCommObject((Port)port));
                _builder.append(_externalName_1, "\t");
                _builder.append(">(\"");
                CharSequence _topic_1 = LaunchScript.getTopic(port);
                _builder.append((Object)_topic_1, "\t");
                _builder.append("\", ");
                String _qos_1 = Constructor.qos(port, "rclcpp::QoS(rclcpp::KeepLast(100)).best_effort()");
                _builder.append(_qos_1, "\t");
                _builder.append(", ");
                String _callBackMethodForPush = Callbacks.callBackMethodForPush(port.getClass_(), port);
                _builder.append(_callBackMethodForPush, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public static CharSequence createSend(Port port) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _size = port.getProvideds().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            String defaultQoS = "rclcpp::QoS(rclcpp::KeepLast(100)).best_effort()";
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _name = port.getName();
            _builder.append(_name, "\t");
            _builder.append("_recv_ = create_subscription<");
            String _externalName = Helpers.externalName(InteractionUtils.getCommObject((Port)port));
            _builder.append(_externalName, "\t");
            _builder.append(">(\"");
            CharSequence _topic = LaunchScript.getTopic(port);
            _builder.append((Object)_topic, "\t");
            _builder.append("\", ");
            String _qos = Constructor.qos(port, "rclcpp::QoS(rclcpp::KeepLast(100)).best_effort()");
            _builder.append(_qos, "\t");
            _builder.append(", ");
            String _callBackMethodForPush = Callbacks.callBackMethodForPush(port.getClass_(), port);
            _builder.append(_callBackMethodForPush, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _greaterThan_1;
            int _size_1 = port.getRequireds().size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                String _name_1 = port.getName();
                _builder.append(_name_1);
                _builder.append("_send_ = create_publisher<");
                String _externalName_1 = Helpers.externalName(InteractionUtils.getCommObject((Port)port));
                _builder.append(_externalName_1);
                _builder.append(">(\"");
                CharSequence _topic_1 = LaunchScript.getTopic(port);
                _builder.append((Object)_topic_1);
                _builder.append("\",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                String _qos_1 = Constructor.qos(port, "1");
                _builder.append(_qos_1, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("// directly activate a publisher");
                _builder.newLine();
                String _name_2 = port.getName();
                _builder.append(_name_2);
                _builder.append("_send_->on_activate();");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public static CharSequence createQuery(Port port) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _size = port.getProvideds().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            String _name = port.getName();
            _builder.append(_name);
            _builder.append("_srv_ = create_service<");
            String _externalName = Helpers.externalName((Type)MessageUtils.getServiceType(port));
            _builder.append(_externalName);
            _builder.append(">(\"");
            String _nameWoPrefix = MessageUtils.getNameWoPrefix(MessageUtils.getServiceType(port));
            _builder.append(_nameWoPrefix);
            _builder.append("\", ");
            String _serverCallBackMethodForService = Callbacks.serverCallBackMethodForService(port.getClass_(), port);
            _builder.append(_serverCallBackMethodForService);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _greaterThan_1;
            int _size_1 = port.getRequireds().size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                String _name_1 = port.getName();
                _builder.append(_name_1);
                _builder.append("_client_ = create_client<");
                String _externalName_1 = Helpers.externalName((Type)MessageUtils.getServiceType(port));
                _builder.append(_externalName_1);
                _builder.append(">(\"");
                String _nameWoPrefix_1 = MessageUtils.getNameWoPrefix(MessageUtils.getServiceType(port));
                _builder.append(_nameWoPrefix_1);
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
                Callbacks.clientCallBackMethodForService(port.getClass_(), port);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public static CharSequence createAction(Port port) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _size = port.getProvideds().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            String _name = port.getName();
            _builder.append(_name);
            _builder.append("_actsrv_ = rclcpp_action::create_server<");
            String _externalName = Helpers.externalName((Type)MessageUtils.getServiceType(port));
            _builder.append(_externalName);
            _builder.append(">(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("this->get_node_base_interface(),");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("this->get_node_clock_interface(),");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("this->get_node_logging_interface(),");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("this->get_node_waitables_interface(),");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\"");
            CharSequence _topic = LaunchScript.getTopic(port);
            _builder.append((Object)_topic, "\t");
            _builder.append("\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _serverCallsbacksForAction = Callbacks.serverCallsbacksForAction(port.getClass_(), port);
            _builder.append(_serverCallsbacksForAction, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        } else {
            String _name_1 = port.getName();
            _builder.append(_name_1);
            _builder.append("_actcli_ = rclcpp_action::create_client<");
            String _externalName_1 = Helpers.externalName((Type)MessageUtils.getServiceType(port));
            _builder.append(_externalName_1);
            _builder.append(">(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("this->get_node_base_interface(),");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("this->get_node_graph_interface(),");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("this->get_node_logging_interface(),");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("this->get_node_waitables_interface(),");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\"");
            CharSequence _topic_1 = LaunchScript.getTopic(port);
            _builder.append((Object)_topic_1, "\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            Callbacks.clientCallsbacksForAction(port.getClass_(), port);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence createEvent(Port port) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public static String qos(Port port, String defaultQoS) {
        ComponentPort compPort = (ComponentPort)UMLUtil.getStereotypeApplication((Element)port, ComponentPort.class);
        if (compPort != null && compPort.getQos() != null && compPort.getQos().length() > 0) {
            return compPort.getQos();
        }
        return defaultQoS;
    }
}

