/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.component;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ConstInit;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Function;
import org.eclipse.papyrus.robotics.ros2.codegen.component.Constructor;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ActivityUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

public class CodeSkeleton {
    public static String POSTFIX = "_impl";

    public static void createSkeleton(Class component) {
        Package _nearestPackage = component.getNearestPackage();
        String _name = component.getName();
        String _plus = String.valueOf(_name) + POSTFIX;
        Class skeleton = _nearestPackage.createOwnedClass(_plus, false);
        Comment comment = skeleton.createOwnedComment();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("This is a skeleton class generated for component ");
        String _name_1 = component.getName();
        _builder.append(_name_1);
        _builder.newLineIfNotEmpty();
        _builder.append("Copy it into the source folder as an initial base (or copy parts");
        _builder.newLine();
        _builder.append("of it whenever you add modify the component).");
        _builder.newLine();
        comment.setBody(_builder.toString());
        component.createUsage((NamedElement)skeleton);
        skeleton.createGeneralization((Classifier)component);
        Operation op = Constructor.addConstrOp(skeleton);
        if (op != null) {
            ConstInit constInit = (ConstInit)UMLUtil.getStereotypeApplication((Element)op, ConstInit.class);
            StringConcatenation _builder_1 = new StringConcatenation();
            String _name_2 = component.getName();
            _builder_1.append(_name_2);
            _builder_1.append("(options)");
            constInit.setInitialisation(_builder_1.toString());
        }
        List<Activity> _activities = ActivityUtils.getActivities(component);
        for (Activity activity : _activities) {
            EList _functions = activity.getFunctions();
            for (Function function : _functions) {
                boolean _not;
                boolean _isCodeInModel = function.isCodeInModel();
                boolean bl = _not = !_isCodeInModel;
                if (!_not) continue;
                CodeSkeleton.moveFunction(skeleton, function);
            }
        }
    }

    public static boolean moveFunction(Class skeleton, Function function) {
        boolean _xifexpression = false;
        Class _base_Class = function.getBase_Class();
        if (_base_Class instanceof Behavior) {
            boolean _xblockexpression = false;
            Class _base_Class_1 = function.getBase_Class();
            Behavior ob = (Behavior)_base_Class_1;
            skeleton.getOwnedBehaviors().add((Object)ob);
            BehavioralFeature _specification = ob.getSpecification();
            _xifexpression = _xblockexpression = skeleton.getOwnedOperations().add((Object)((Operation)_specification));
        }
        return _xifexpression;
    }
}

