/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.tests;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.junit.utils.rules.AbstractHouseKeeperRule;
import org.eclipse.papyrus.junit.utils.rules.HouseKeeper;
import org.eclipse.papyrus.robotics.ros2.codegen.tests.CDTUtil;
import org.eclipse.papyrus.robotics.ros2.codegen.tests.LwTransformationTestSupport;
import org.eclipse.papyrus.robotics.ros2.codegen.tests.PrepareCodegen;
import org.eclipse.papyrus.robotics.ros2.codegen.tests.RecursiveCopy;
import org.eclipse.papyrus.robotics.ros2.examples.Activator;
import org.eclipse.uml2.uml.Package;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TestSendReceive {
    public static final String SEND_RECEIVE = "sendReceive";
    public static final String SIMPLE = "simple";
    protected IProject sendReceiveProject;
    protected IProject simpleProject;
    protected LwTransformationTestSupport tts;
    @ClassRule
    public static HouseKeeper.Static houseKeeper = new HouseKeeper.Static();

    @Before
    public void setup() {
        this.sendReceiveProject = houseKeeper.createProject(SEND_RECEIVE);
        CDTUtil.addCppNature(this.sendReceiveProject);
        this.simpleProject = houseKeeper.createProject(SIMPLE);
        CDTUtil.addCppNature(this.simpleProject);
        RecursiveCopy copier = new RecursiveCopy(Activator.class);
        Bundle srcBundle = FrameworkUtil.getBundle(Activator.class);
        copier.copy(srcBundle, "testmodels/sendReceive/models", this.sendReceiveProject, "models");
        ResourceSet rs = houseKeeper.createResourceSet();
        Resource r = rs.getResource(URI.createURI((String)"platform:/resource/sendReceive/models/system/sendReceive.system.uml"), true);
        assert (r != null);
        assert (r.getContents().size() > 0);
        assert (r.getContents().get(0) instanceof Package);
        Package rootPkg = (Package)r.getContents().get(0);
        PrepareCodegen prepare = new PrepareCodegen(rootPkg);
        boolean prepareOk = prepare.prepare();
        assert (prepareOk);
        this.tts = new LwTransformationTestSupport(this.getClass(), (AbstractHouseKeeperRule)houseKeeper, this.sendReceiveProject);
        this.tts.runTransformation(rootPkg);
    }

    @Test
    public void testSystem() throws InterruptedException {
        this.tts.validateResults(this.sendReceiveProject, "expectedResult/sendReceive", ".");
    }

    @Test
    public void testServiceDef() throws InterruptedException {
        this.tts.validateResults(this.simpleProject, "expectedResult/simple", ".");
    }
}

