/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.tests;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.papyrus.junit.utils.PapyrusProjectUtils;
import org.eclipse.papyrus.junit.utils.rules.AbstractHouseKeeperRule;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class RecursiveCopy {
    protected AbstractHouseKeeperRule houseKeeper;
    protected Class<?> testClass;

    public RecursiveCopy(Class<?> testClass) {
        this.testClass = testClass;
    }

    public void copy(Bundle srcBundle, String srcPath, IProject dstProject, String dstPath) {
        URL fileURL = srcBundle.getEntry(srcPath);
        MatcherAssert.assertThat((String)"source path is not contained in bundle", (fileURL != null ? 1 : 0) != 0);
        try {
            URL resolvedFileURL = FileLocator.toFileURL((URL)fileURL);
            File file = new File(new URI(resolvedFileURL.getProtocol(), resolvedFileURL.getPath(), null));
            MatcherAssert.assertThat((String)"source file must exist", (boolean)file.exists());
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File subFile = fileArray[n2];
                    this.copy(srcBundle, String.valueOf(srcPath) + "/" + subFile.getName(), dstProject, String.valueOf(dstPath) + "/" + subFile.getName());
                    ++n2;
                }
            } else if (file.isFile()) {
                try {
                    PapyrusProjectUtils.copyIFile((String)srcPath, (Bundle)FrameworkUtil.getBundle(this.testClass), (IProject)dstProject, (String)dstPath);
                }
                catch (CoreException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

