/**
 * Copyright (c) 2019 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Ansgar Radermacher (CEA LIST) <ansgar.radermacher@cea.fr> - initial API and implementation
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import java.util.Collections;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * Utility class for life-cycle operations
 * TODO: move this class into a more general transformation context
 */
@SuppressWarnings("all")
public class LifeCycleUtil {
  public static final String LIFE_CYCLE_QNAME = "sysinterfaces::ILifeCycle";
  
  public static final String M_ACTIVATE = "activate";
  
  public static final String M_DEACTIVATE = "deactivate";
  
  public static final String M_CONFIG_COMPLETE = "configuration_complete";
  
  /**
   * Return true, if the passed class implements the life-cycle interface
   * @param clazz
   * 		the class which to check
   */
  public static boolean supportsLifeCycle(final org.eclipse.uml2.uml.Class clazz) {
    NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS(clazz, LifeCycleUtil.LIFE_CYCLE_QNAME);
    final Interface lifeCycle = ((Interface) _qualifiedElementFromRS);
    if (((lifeCycle != null) && clazz.getImplementedInterfaces().contains(lifeCycle))) {
      return true;
    }
    return false;
  }
  
  /**
   * create life-cycle operations, if they do not exist
   * @param clazz
   * 		the class for which we want to add operations, if required
   */
  public static void addUnimplemented(final org.eclipse.uml2.uml.Class clazz) {
    for (final String op : Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(LifeCycleUtil.M_ACTIVATE, LifeCycleUtil.M_DEACTIVATE, LifeCycleUtil.M_CONFIG_COMPLETE))) {
      {
        final Operation activateOp = clazz.getOperation(op, null, null);
        if ((activateOp == null)) {
          clazz.createOwnedOperation(op, null, null);
        }
      }
    }
  }
}
