/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.jdt;

import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.papyrus.designer.languages.java.reverse.jdt.JdtAstUtils;
import org.eclipse.papyrus.designer.languages.java.reverse.jdt.LocalContext;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.TypeResolver;
import org.eclipse.uml2.uml.Type;

public class PropertyDeclarationHelper {
    private FieldDeclaration fieldDeclaration;
    private TypeResolver typeResolver;
    private VariableDeclarationFragment variableDeclaration;

    public PropertyDeclarationHelper(FieldDeclaration fieldDeclaration, TypeResolver typeResolver) {
        this.fieldDeclaration = fieldDeclaration;
        this.typeResolver = typeResolver;
    }

    public void setVariableDeclaration(VariableDeclarationFragment varDecl) {
        this.variableDeclaration = varDecl;
    }

    public String getPropertyName() {
        return this.variableDeclaration.getName().getIdentifier();
    }

    public Type getPropertyType(LocalContext context) {
        String typename = JdtAstUtils.getTypeShortname(this.fieldDeclaration.getType());
        Type result = this.typeResolver.getType(typename, context);
        return result;
    }

    public boolean isSimpleProperty() {
        return !this.isMultiple();
    }

    public boolean isArrayProperty() {
        return this.fieldDeclaration.getType().isArrayType() || this.variableDeclaration.getExtraDimensions() > 0;
    }

    public boolean isMultiple() {
        return this.isArrayProperty() || this.isCollectionProperty();
    }

    private boolean isCollectionProperty() {
        return false;
    }

    public int getLower() {
        return 0;
    }

    public int getUpper() {
        if (this.isMultiple()) {
            return -1;
        }
        return 1;
    }
}

