/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.deployment.tools;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.DeploymentPlan;
import org.eclipse.papyrus.designer.deployment.tools.DepCreation;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.deployment.tools.Messages;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class DepPlanUtils {
    public static Package getDepPlanRoot(Element element) {
        return ElementUtils.getRoot((Element)element, (String)"deployment");
    }

    public static EList<Package> getAllDepPlans(Element element) {
        Package root = PackageUtil.getRootPackage((Element)element);
        Package depPlanRoot = root.getNestedPackage("deployment");
        BasicEList depPlanList = new BasicEList();
        if (depPlanRoot != null) {
            for (Package pkg : depPlanRoot.getNestedPackages()) {
                if (!StereotypeUtil.isApplied((Element)pkg, DeploymentPlan.class)) continue;
                depPlanList.add((Object)pkg);
            }
        }
        return depPlanList;
    }

    public static void delDepPlan(InstanceSpecification is) {
        for (Slot slot : is.getSlots()) {
            InstanceSpecification subInstance = DepPlanUtils.getInstance(slot);
            if (subInstance == null) continue;
            DepPlanUtils.delDepPlan(subInstance);
        }
        Element owner = is.getOwner();
        if (owner instanceof Package) {
            ((Package)owner).getPackagedElements().remove((Object)is);
        }
    }

    public static InstanceSpecification getInstance(Slot slot) {
        for (ValueSpecification value : slot.getValues()) {
            if (!(value instanceof InstanceValue)) continue;
            return ((InstanceValue)value).getInstance();
        }
        return null;
    }

    public static Slot createSlot(Package cdp, InstanceSpecification is, InstanceSpecification partIS, Property part) {
        Slot slot = is.createSlot();
        slot.setDefiningFeature((StructuralFeature)part);
        InstanceValue iv = (InstanceValue)slot.createValue(null, null, UMLPackage.eINSTANCE.getInstanceValue());
        iv.setInstance(partIS);
        return slot;
    }

    public static Class autoChooseImplementation(Classifier componentType) {
        Package compModel = ElementUtils.getRoot((Element)componentType, (String)"ComponentModel");
        for (Element element : compModel.allOwnedElements()) {
            Class candidate;
            if (!(element instanceof Class) || (candidate = (Class)element).getSuperClass(componentType.getName()) == null) continue;
            return candidate;
        }
        return null;
    }

    public static void configureProperty(InstanceSpecification instance, ENamedElement property, String value) {
        DepPlanUtils.configureProperty(instance, property.getName(), value);
    }

    public static void configureProperty(InstanceSpecification instance, String propertyName, String value) {
        Classifier extension = DepUtils.getClassifier(instance);
        Property attribute = (Property)ElementUtils.getNamedElementFromList((EList)extension.getAllAttributes(), (String)propertyName);
        if (attribute == null) {
            throw new RuntimeException(String.format(Messages.DepPlanUtils_CannotFindAttribute, propertyName, extension.getName()));
        }
        DepPlanUtils.configureProperty(instance, attribute, value);
    }

    public static void configureProperty(InstanceSpecification instance, Property attribute, String value) {
        if (attribute.getType() instanceof Enumeration) {
            DepPlanUtils.configureEnumProperty(instance, attribute, value);
        } else {
            Slot slotStringVal = DepCreation.createSlotForConfigProp(instance, attribute);
            if (slotStringVal.getValues().get(0) instanceof LiteralString) {
                ((LiteralString)slotStringVal.getValues().get(0)).setValue(value);
            } else {
                throw new RuntimeException(String.format(Messages.DepPlanUtils_ConfigOfPropertyFailed, attribute.getName()));
            }
        }
    }

    public static void configureProperty(InstanceSpecification instance, ENamedElement property, int value) {
        DepPlanUtils.configureProperty(instance, property.getName(), value);
    }

    public static void configureProperty(InstanceSpecification instance, String propertyName, int value) {
        Classifier extension = DepUtils.getClassifier(instance);
        Property attribute = (Property)ElementUtils.getNamedElementFromList((EList)extension.getAllAttributes(), (String)propertyName);
        if (attribute == null) {
            throw new RuntimeException(String.format(Messages.DepPlanUtils_CannotFindAttribute, propertyName, extension.getName()));
        }
        DepPlanUtils.configureProperty(instance, attribute, value);
    }

    public static void configureProperty(InstanceSpecification instance, Property attribute, int value) {
        Slot slotIntVal = instance.createSlot();
        slotIntVal.setDefiningFeature((StructuralFeature)attribute);
        LiteralInteger intValue = (LiteralInteger)slotIntVal.createValue("value for " + attribute.getName(), attribute.getType(), UMLPackage.eINSTANCE.getLiteralInteger());
        intValue.setValue(value);
    }

    public static void configureProperty(InstanceSpecification instance, ENamedElement property, Enumerator value) {
        DepPlanUtils.configureProperty(instance, property.getName(), value);
    }

    public static void configureProperty(InstanceSpecification instance, String propertyName, Enumerator value) {
        DepPlanUtils.configureProperty(instance, propertyName, value.getName());
    }

    public static void configureEnumProperty(InstanceSpecification instance, String propertyName, String literalName) {
        Classifier extension = DepUtils.getClassifier(instance);
        Property attribute = (Property)ElementUtils.getNamedElementFromList((EList)extension.getAllAttributes(), (String)propertyName);
        if (attribute == null) {
            throw new RuntimeException(String.format(Messages.DepPlanUtils_CannotFindAttribute, propertyName, extension.getName()));
        }
        DepPlanUtils.configureEnumProperty(instance, attribute, literalName);
    }

    public static void configureEnumProperty(InstanceSpecification instance, Property attribute, String literalName) {
        if (attribute.getType() instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)attribute.getType();
            for (EnumerationLiteral enumLiteral : enumeration.getOwnedLiterals()) {
                if (!enumLiteral.getLabel().equals(literalName)) continue;
                Slot slotEnumVal = instance.createSlot();
                slotEnumVal.setDefiningFeature((StructuralFeature)attribute);
                InstanceValue enumLitValue = (InstanceValue)slotEnumVal.createValue("value for " + attribute.getName(), attribute.getType(), UMLPackage.eINSTANCE.getInstanceValue());
                enumLitValue.setInstance((InstanceSpecification)enumLiteral);
                break;
            }
        }
    }

    public static void updateInstanceNames(InstanceSpecification instance, String name) {
        instance.setName(name);
        for (Slot slot : instance.getSlots()) {
            InstanceSpecification subInstance = DepUtils.getInstance(slot);
            StructuralFeature sf = slot.getDefiningFeature();
            if (subInstance == null || DepUtils.isShared(slot)) continue;
            DepPlanUtils.updateInstanceNames(subInstance, String.valueOf(name) + "." + sf.getName());
        }
    }
}

