/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.validation.ValidationContext;
import org.eclipse.ocl.pivot.validation.ValidationRegistryAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ValidateCommand
extends ValidateAction {
    protected Diagnostician createDiagnostician(AdapterFactory adapterFactory, @Nullable IProgressMonitor progressMonitor) {
        ResourceSet resourceSet = (ResourceSet)ClassUtil.nonNullEMF((Object)this.domain.getResourceSet());
        ValidationRegistryAdapter validationRegistry = ValidationRegistryAdapter.getAdapter((ResourceSet)resourceSet);
        ValidationContext validationContext = new ValidationContext((EValidator.Registry)validationRegistry);
        return validationContext.getDiagnostician();
    }

    protected void fireHandlerChanged(HandlerEvent handlerEvent) {
        if (handlerEvent == null) {
            throw new NullPointerException();
        }
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IHandlerListener listener = (IHandlerListener)listeners[i];
            listener.handlerChanged(handlerEvent);
            ++i;
        }
    }

    protected void handleDiagnostic(Diagnostic diagnostic) {
        List data;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        int severity = diagnostic.getSeverity();
        String title = null;
        String message = null;
        if (severity == 4 || severity == 2) {
            title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title");
            message = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message");
        } else {
            title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationResults_title");
            message = EMFEditUIPlugin.INSTANCE.getString(severity == 0 ? "_UI_ValidationOK_message" : "_UI_ValidationResults_message");
        }
        int result = 0;
        if (diagnostic.getSeverity() == 0) {
            MessageDialog.openInformation((Shell)activeWorkbenchWindow.getShell(), (String)title, (String)message);
            result = 1;
        } else {
            result = DiagnosticDialog.open((Shell)activeWorkbenchWindow.getShell(), (String)title, (String)message, (Diagnostic)diagnostic);
        }
        ResourceSet resourceSet = this.domain.getResourceSet();
        Resource resource = null;
        if (this.eclipseResourcesUtil != null) {
            Object object;
            data = diagnostic.getData();
            if (data != null && data.size() >= 1 && (object = data.get(0)) instanceof EObject) {
                resource = ((EObject)object).eResource();
            }
            if (resource == null) {
                resource = (Resource)resourceSet.getResources().get(0);
            }
        }
        if (resource != null) {
            this.eclipseResourcesUtil.deleteMarkers(resource);
        }
        if (result == 0) {
            if (!diagnostic.getChildren().isEmpty() && !(data = ((Diagnostic)diagnostic.getChildren().get(0)).getData()).isEmpty() && data.get(0) instanceof EObject) {
                Viewer viewer;
                IWorkbenchPart part = activeWorkbenchWindow.getActivePage().getActivePart();
                if (part instanceof ISetSelectionTarget) {
                    ((ISetSelectionTarget)part).selectReveal((ISelection)new StructuredSelection(data.get(0)));
                } else if (part instanceof IViewerProvider && (viewer = ((IViewerProvider)part).getViewer()) != null) {
                    viewer.setSelection((ISelection)new StructuredSelection(data.get(0)), true);
                }
            }
            if (resource != null) {
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    this.eclipseResourcesUtil.createMarkers(resource, childDiagnostic);
                }
            }
        } else {
            resource = null;
        }
        if (resource == null) {
            BasicDiagnostic resourceSetDiagnostic = new BasicDiagnostic("org.eclipse.emf.ecore", 0, null, new Object[]{resourceSet});
            LinkedHashMap<Resource, BasicDiagnostic> resourceDiagnostics = new LinkedHashMap<Resource, BasicDiagnostic>();
            for (Resource r : resourceSet.getResources()) {
                BasicDiagnostic resourceDiagnostic = new BasicDiagnostic("org.eclipse.emf.ecore", 0, null, new Object[]{r});
                resourceDiagnostics.put(r, resourceDiagnostic);
            }
            if (result == 0) {
                for (Diagnostic child : diagnostic.getChildren()) {
                    BasicDiagnostic resourceDiagnostic;
                    Object object;
                    List data2 = child.getData();
                    if (data2.isEmpty() || !((object = data2.get(0)) instanceof EObject) || (resourceDiagnostic = (BasicDiagnostic)resourceDiagnostics.get(((EObject)object).eResource())) == null) continue;
                    resourceDiagnostic.add(child);
                }
            }
            for (Diagnostic resourceDiagnostic : resourceDiagnostics.values()) {
                resourceSetDiagnostic.add(resourceDiagnostic);
            }
            try {
                DiagnosticDecorator.DiagnosticAdapter.update((Notifier)resourceSet, (Diagnostic)resourceSetDiagnostic);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected boolean hasListeners() {
        return this.isListenerAttached();
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        Object object = workbenchPart.getAdapter(EditingDomain.class);
        if (object instanceof EditingDomain) {
            this.domain = (EditingDomain)object;
            return;
        }
        object = workbenchPart.getAdapter(IEditingDomainProvider.class);
        if (object instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)object).getEditingDomain();
            return;
        }
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this.selectedObjects = new ArrayList();
        Iterator objects = selection.iterator();
        while (objects.hasNext()) {
            Object object = AdapterFactoryEditingDomain.unwrap(objects.next());
            if (object instanceof IAdaptable) {
                object = ((IAdaptable)object).getAdapter(EObject.class);
            }
            if (object instanceof EObject) {
                this.selectedObjects.add((EObject)object);
                continue;
            }
            if (object instanceof Resource) {
                this.selectedObjects.addAll(((Resource)object).getContents());
                continue;
            }
            return false;
        }
        this.selectedObjects = EcoreUtil.filterDescendants((Collection)this.selectedObjects);
        return !this.selectedObjects.isEmpty();
    }
}

