/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.FeatureCallExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.LoopExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.uml.CollectionType;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.AbstractVisitor;
import org.eclipse.ocl.utilities.CallingASTNode;
import org.eclipse.ocl.utilities.TypedASTNode;
import org.eclipse.ocl.utilities.Visitor;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationInformationTest
extends AbstractTestSuite {
    public void test_invariant() {
        String exprString = "true implies self.color <> Color::black";
        OCLExpression<Classifier> constraint = this.createQuery(this.apple, "true implies self.color <> Color::black");
        OperationCallExp<Classifier, Operation> impliesExp = LocationInformationTest.asOperationCall(constraint);
        LocationInformationTest.assertLocation(impliesExp, 0, "true implies self.color <> Color::black".length());
        BooleanLiteralExp<Classifier> bl = LocationInformationTest.asBooleanLiteral(impliesExp.getSource());
        LocationInformationTest.assertLocation(bl, 0, "true".length());
        int selfPos = "true implies self.color <> Color::black".indexOf("self");
        OperationCallExp<Classifier, Operation> notEqualsExp = LocationInformationTest.asOperationCall(impliesExp.getArgument().get(0));
        LocationInformationTest.assertLocation(notEqualsExp, selfPos, "true implies self.color <> Color::black".length());
        PropertyCallExp<Classifier, Property> attrCall = LocationInformationTest.asPropertyCall(notEqualsExp.getSource());
        LocationInformationTest.assertLocation(attrCall, selfPos, selfPos + "self.color".length());
        VariableExp<Classifier, Parameter> selfVar = LocationInformationTest.asVariable(attrCall.getSource());
        LocationInformationTest.assertLocation(selfVar, selfPos, selfPos + "self".length());
        EnumLiteralExp<Classifier, EnumerationLiteral> enumLiteral = LocationInformationTest.asEnumLiteral(notEqualsExp.getArgument().get(0));
        LocationInformationTest.assertLocation(enumLiteral, "true implies self.color <> Color::black".indexOf("Color"), "true implies self.color <> Color::black".length());
    }

    public void test_query() {
        String exprString = "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif";
        OCLExpression<Classifier> constraint = this.createQuery(this.apple, "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif");
        IfExp<Classifier> ifExp = LocationInformationTest.asIf(constraint);
        LocationInformationTest.assertLocation(ifExp, 0, "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".length());
        int falsePos = "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("false");
        BooleanLiteralExp<Classifier> bl = LocationInformationTest.asBooleanLiteral(ifExp.getCondition());
        LocationInformationTest.assertLocation(bl, falsePos, falsePos + "false".length());
        int spyPos = "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("'Spy'");
        StringLiteralExp<Classifier> stringLiteral = LocationInformationTest.asStringLiteral(ifExp.getThenExpression());
        LocationInformationTest.assertLocation(stringLiteral, spyPos, spyPos + "'Spy'".length());
        IteratorExp<Classifier, Parameter> anyIterator = LocationInformationTest.asIterator(ifExp.getElseExpression());
        LocationInformationTest.assertLocation(anyIterator, "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("Set"), "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("endif") - 1);
        Variable<Classifier, Parameter> vdecl = LocationInformationTest.asVariableDeclaration(anyIterator.getIterator().get(0));
        LocationInformationTest.assertLocation(vdecl, "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("i :"), "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("|") - 1);
        OCLExpression anyBody = anyIterator.getBody();
        LocationInformationTest.assertLocation((ASTNode)anyBody, "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("i <>"), "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf(")"));
        CollectionLiteralExp<Classifier> collLiteral = LocationInformationTest.asCollectionLiteral(anyIterator.getSource());
        LocationInformationTest.assertLocation(collLiteral, "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("Set"), "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("->"));
        int grannyPos = "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("'GrannySmith'");
        CollectionItem<Classifier> item = LocationInformationTest.asCollectionItem(collLiteral.getPart().get(1));
        stringLiteral = LocationInformationTest.asStringLiteral(item.getItem());
        LocationInformationTest.assertLocation(stringLiteral, grannyPos, grannyPos + "'GrannySmith'".length());
    }

    public void test_postcondition() {
        String exprString = "let oldColor : Color = self.color@pre in oldColor <> self.color";
        OCLExpression<Classifier> constraint = this.createPostcondition(this.fruit_ripen, "let oldColor : Color = self.color@pre in oldColor <> self.color");
        LetExp<Classifier, Parameter> letExp = LocationInformationTest.asLet(constraint);
        LocationInformationTest.assertLocation(letExp, 0, "let oldColor : Color = self.color@pre in oldColor <> self.color".length());
        Variable vdecl = letExp.getVariable();
        LocationInformationTest.assertLocation((ASTNode)vdecl, "let oldColor : Color = self.color@pre in oldColor <> self.color".indexOf("oldColor :"), "let oldColor : Color = self.color@pre in oldColor <> self.color".indexOf(" in "));
        PropertyCallExp<Classifier, Property> attrExp = LocationInformationTest.asPropertyCall(vdecl.getInitExpression());
        LocationInformationTest.assertLocation(attrExp, "let oldColor : Color = self.color@pre in oldColor <> self.color".indexOf("self"), "let oldColor : Color = self.color@pre in oldColor <> self.color".indexOf(" in "));
        OperationCallExp<Classifier, Operation> notEqualExp = LocationInformationTest.asOperationCall(letExp.getIn());
        LocationInformationTest.assertLocation(notEqualExp, "let oldColor : Color = self.color@pre in oldColor <> self.color".indexOf("oldColor <>"), "let oldColor : Color = self.color@pre in oldColor <> self.color".length());
    }

    public void test_parentheses() {
        String exprString = "( (true) implies ( (false) or ((true)) ) )";
        OCLExpression<Classifier> constraint = this.createQuery(this.fruit, "( (true) implies ( (false) or ((true)) ) )");
        OperationCallExp<Classifier, Operation> operCall = LocationInformationTest.asOperationCall(constraint);
        LocationInformationTest.assertLocation(operCall, 0, "( (true) implies ( (false) or ((true)) ) )".length());
        BooleanLiteralExp<Classifier> literal = LocationInformationTest.asBooleanLiteral(operCall.getSource());
        LocationInformationTest.assertLocation(literal, "( (true) implies ( (false) or ((true)) ) )".indexOf("(true) imp"), "( (true) implies ( (false) or ((true)) ) )".indexOf(" imp"));
        operCall = LocationInformationTest.asOperationCall(operCall.getArgument().get(0));
        LocationInformationTest.assertLocation(operCall, "( (true) implies ( (false) or ((true)) ) )".indexOf("( (false"), "( (true) implies ( (false) or ((true)) ) )".length() - 2);
        literal = LocationInformationTest.asBooleanLiteral(operCall.getSource());
        LocationInformationTest.assertLocation(literal, "( (true) implies ( (false) or ((true)) ) )".indexOf("(false) or"), "( (true) implies ( (false) or ((true)) ) )".indexOf(" or"));
        literal = LocationInformationTest.asBooleanLiteral(operCall.getArgument().get(0));
        LocationInformationTest.assertLocation(literal, "( (true) implies ( (false) or ((true)) ) )".indexOf("((true)) )"), "( (true) implies ( (false) or ((true)) ) )".length() - 4);
    }

    public void test_typePositions() {
        String exprString = "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))";
        OCLExpression<Classifier> constraint = this.createQuery(this.fruit, "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))");
        LetExp<Classifier, Parameter> letExp = LocationInformationTest.asLet(constraint);
        LocationInformationTest.assertLocation(letExp, 0, "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))".length());
        Variable vdecl = letExp.getVariable();
        LocationInformationTest.assertTypeLocation((TypedASTNode)vdecl, "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))".indexOf("Boolean"), "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))".indexOf(" = "));
        TypeExp<Classifier> typeExp = LocationInformationTest.asType(LocationInformationTest.asOperationCall(vdecl.getInitExpression()).getArgument().get(0));
        LocationInformationTest.assertLocation(typeExp, "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))".indexOf("Apple) in "), "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))".indexOf(") in "));
        OperationCallExp<Classifier, Operation> operCall = LocationInformationTest.asOperationCall(LocationInformationTest.asOperationCall(letExp.getIn()).getArgument().get(0));
        operCall = LocationInformationTest.asOperationCall(operCall.getSource());
        typeExp = LocationInformationTest.asType(operCall.getSource());
        LocationInformationTest.assertLocation(typeExp, "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))".indexOf("Apple.all"), "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))".indexOf(".all"));
    }

    public void test_elementTypePositions() {
        String exprString = "let allApples : Set(Apple) = Apple.allInstances() in allApples->includes(self)";
        OCLExpression<Classifier> constraint = this.createQuery(this.apple, "let allApples : Set(Apple) = Apple.allInstances() in allApples->includes(self)");
        LetExp<Classifier, Parameter> letExp = LocationInformationTest.asLet(constraint);
        LocationInformationTest.assertLocation(letExp, 0, "let allApples : Set(Apple) = Apple.allInstances() in allApples->includes(self)".length());
        Variable vdecl = letExp.getVariable();
        LocationInformationTest.assertTypeLocation((TypedASTNode)vdecl, "let allApples : Set(Apple) = Apple.allInstances() in allApples->includes(self)".indexOf("Set("), "let allApples : Set(Apple) = Apple.allInstances() in allApples->includes(self)".indexOf(" = "));
        CollectionType collType = (CollectionType)vdecl.getType();
        LocationInformationTest.assertTypeLocation((TypedASTNode)collType, "let allApples : Set(Apple) = Apple.allInstances() in allApples->includes(self)".indexOf("Apple) = "), "let allApples : Set(Apple) = Apple.allInstances() in allApples->includes(self)".indexOf(") = "));
    }

    public void test_propertyPositions_operationCall() {
        String exprString = "Apple.allInstances()->includes(self)";
        OCLExpression<Classifier> constraint = this.createQuery(this.apple, "Apple.allInstances()->includes(self)");
        OperationCallExp<Classifier, Operation> includesExp = LocationInformationTest.asOperationCall(constraint);
        LocationInformationTest.assertPropertyLocation(includesExp, "Apple.allInstances()->includes(self)".indexOf("includes"), "Apple.allInstances()->includes(self)".indexOf("(self)"));
        FeatureCallExp<Classifier> mpcExp = LocationInformationTest.asFeatureCall(includesExp.getSource());
        LocationInformationTest.assertPropertyLocation(mpcExp, "Apple.allInstances()->includes(self)".indexOf("allInst"), "Apple.allInstances()->includes(self)".indexOf("()"));
    }

    public void test_propertyPositions_attributeCall() {
        String exprString = "not ripen(self. color )";
        OCLExpression<Classifier> constraint = this.createQuery(this.apple, "not ripen(self. color )");
        OperationCallExp<Classifier, Operation> notExp = LocationInformationTest.asOperationCall(constraint);
        OperationCallExp<Classifier, Operation> ripenExp = LocationInformationTest.asOperationCall(notExp.getSource());
        FeatureCallExp<Classifier> mpcExp = LocationInformationTest.asFeatureCall(ripenExp.getArgument().get(0));
        LocationInformationTest.assertPropertyLocation(mpcExp, "not ripen(self. color )".indexOf("color "), "not ripen(self. color )".indexOf(" )"));
    }

    public void test_propertyPositions_associationEndCall() {
        String exprString = "self.stem->notEmpty()";
        OCLExpression<Classifier> constraint = this.createQuery(this.apple, "self.stem->notEmpty()");
        OperationCallExp<Classifier, Operation> notEmptyExp = LocationInformationTest.asOperationCall(constraint);
        CollectionLiteralExp<Classifier> setExp = LocationInformationTest.asCollectionLiteral(notEmptyExp.getSource());
        FeatureCallExp<Classifier> mpcExp = LocationInformationTest.asFeatureCall(((CollectionItem)setExp.getPart().get(0)).getItem());
        LocationInformationTest.assertPropertyLocation(mpcExp, "self.stem->notEmpty()".indexOf("stem"), "self.stem->notEmpty()".indexOf("->"));
    }

    public void test_propertyPositions_implicitCollect() {
        String exprString = "orderedSet.color->asSet()->size() = 1";
        OCLExpression<Classifier> constraint = this.createQuery((Class)((Package)this.fruitPackage).getOwnedType("FruitUtil"), "orderedSet.color->asSet()->size() = 1");
        OperationCallExp<Classifier, Operation> eqExp = LocationInformationTest.asOperationCall(constraint);
        OperationCallExp<Classifier, Operation> sizeExp = LocationInformationTest.asOperationCall(eqExp.getSource());
        OperationCallExp<Classifier, Operation> asSetExp = LocationInformationTest.asOperationCall(sizeExp.getSource());
        IteratorExp<Classifier, Parameter> iterExp = LocationInformationTest.asIterator(asSetExp.getSource());
        FeatureCallExp<Classifier> mpcExp = LocationInformationTest.asFeatureCall(iterExp.getBody());
        LocationInformationTest.assertPropertyLocation(mpcExp, "orderedSet.color->asSet()->size() = 1".indexOf("color"), "orderedSet.color->asSet()->size() = 1".indexOf("->asSet"));
    }

    public void test_referencePositions_implicitCollect() {
        String exprString = "Apple.allInstances().stem->asSet()->size() > 1";
        OCLExpression<Classifier> constraint = this.createQuery(this.apple, "Apple.allInstances().stem->asSet()->size() > 1");
        OperationCallExp<Classifier, Operation> eqExp = LocationInformationTest.asOperationCall(constraint);
        OperationCallExp<Classifier, Operation> sizeExp = LocationInformationTest.asOperationCall(eqExp.getSource());
        OperationCallExp<Classifier, Operation> asSetExp = LocationInformationTest.asOperationCall(sizeExp.getSource());
        IteratorExp<Classifier, Parameter> iterExp = LocationInformationTest.asIterator(asSetExp.getSource());
        FeatureCallExp<Classifier> mpcExp = LocationInformationTest.asFeatureCall(iterExp.getBody());
        LocationInformationTest.assertPropertyLocation(mpcExp, "Apple.allInstances().stem->asSet()->size() > 1".indexOf("stem"), "Apple.allInstances().stem->asSet()->size() > 1".indexOf("->asSet"));
    }

    public void test_messageExp_positions() {
        String exprString = "self^ripen(? : Color)";
        OCLExpression<Classifier> constraint = this.createQuery(this.fruit, "self^ripen(? : Color)");
        MessageExp<Classifier, ?, ?> msgExp = LocationInformationTest.asMessage(constraint);
        LocationInformationTest.assertLocation(msgExp, 0, "self^ripen(? : Color)".length());
        LocationInformationTest.assertPropertyLocation(msgExp, "self^ripen(? : Color)".indexOf("ripen"), "self^ripen(? : Color)".indexOf("("));
        VariableExp<Classifier, Parameter> var = LocationInformationTest.asVariable(msgExp.getTarget());
        LocationInformationTest.assertLocation(var, 0, "self^ripen(? : Color)".indexOf("^"));
        UnspecifiedValueExp<Classifier> unspecExp = LocationInformationTest.asUnspecifiedValue(msgExp.getArgument().get(0));
        LocationInformationTest.assertLocation(unspecExp, "self^ripen(? : Color)".indexOf("?"), "self^ripen(? : Color)".indexOf(")"));
        LocationInformationTest.assertTypeLocation(unspecExp, "self^ripen(? : Color)".indexOf("Color"), "self^ripen(? : Color)".indexOf(")"));
    }

    public void test_stateExp_positions() {
        String exprString = "self.oclIsInState(Bad::Rotten)";
        OCLExpression<Classifier> constraint = this.createQuery(this.apple, "self.oclIsInState(Bad::Rotten)");
        OperationCallExp<Classifier, Operation> callExp = LocationInformationTest.asOperationCall(constraint);
        LocationInformationTest.assertLocation(callExp, 0, "self.oclIsInState(Bad::Rotten)".length());
        StateExp<Classifier, ?> state = LocationInformationTest.asState(callExp.getArgument().get(0));
        LocationInformationTest.assertLocation(state, "self.oclIsInState(Bad::Rotten)".indexOf("Bad"), "self.oclIsInState(Bad::Rotten)".indexOf(")"));
    }

    protected OCLExpression<Classifier> createQuery(Class context, String text) {
        OCLExpression result = super.createQuery((EObject)context, text);
        LocationInformationTest.assertAllPositionsSet((OCLExpression<Classifier>)result);
        return result;
    }

    protected OCLExpression<Classifier> createQuery(EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> envFactory, Class context, String text) {
        OCLExpression result = super.createQuery(envFactory, (EObject)context, text);
        LocationInformationTest.assertAllPositionsSet((OCLExpression<Classifier>)result);
        return result;
    }

    protected OCLExpression<Classifier> createInvariant(Class context, String text) {
        OCLExpression result = super.createInvariant((EObject)context, text);
        LocationInformationTest.assertAllPositionsSet((OCLExpression<Classifier>)result);
        return result;
    }

    protected OCLExpression<Classifier> createPrecondition(Operation context, String text) {
        OCLExpression result = super.createPrecondition((EObject)context, text);
        LocationInformationTest.assertAllPositionsSet((OCLExpression<Classifier>)result);
        return result;
    }

    protected OCLExpression<Classifier> createPostcondition(Operation context, String text) {
        OCLExpression result = super.createPostcondition((EObject)context, text);
        LocationInformationTest.assertAllPositionsSet((OCLExpression<Classifier>)result);
        return result;
    }

    protected OCLExpression<Classifier> createBodyCondition(Operation context, String text) {
        OCLExpression result = super.createBodyCondition((EObject)context, text);
        LocationInformationTest.assertAllPositionsSet((OCLExpression<Classifier>)result);
        return result;
    }

    static IfExp<Classifier> asIf(Object obj) {
        return (IfExp)LocationInformationTest.cast(obj, IfExp.class);
    }

    static EnumLiteralExp<Classifier, EnumerationLiteral> asEnumLiteral(Object obj) {
        return (EnumLiteralExp)LocationInformationTest.cast(obj, EnumLiteralExp.class);
    }

    static VariableExp<Classifier, Parameter> asVariable(Object obj) {
        return (VariableExp)LocationInformationTest.cast(obj, VariableExp.class);
    }

    static LetExp<Classifier, Parameter> asLet(Object obj) {
        return (LetExp)LocationInformationTest.cast(obj, LetExp.class);
    }

    static LoopExp<Classifier, Parameter> asLoop(Object obj) {
        return (LoopExp)LocationInformationTest.cast(obj, LoopExp.class);
    }

    static IteratorExp<Classifier, Parameter> asIterator(Object obj) {
        return (IteratorExp)LocationInformationTest.cast(obj, IteratorExp.class);
    }

    static PropertyCallExp<Classifier, Property> asPropertyCall(Object obj) {
        return (PropertyCallExp)LocationInformationTest.cast(obj, PropertyCallExp.class);
    }

    static FeatureCallExp<Classifier> asFeatureCall(Object obj) {
        return (FeatureCallExp)LocationInformationTest.cast(obj, FeatureCallExp.class);
    }

    static AssociationClassCallExp<Classifier, Property> asAssociationClassCall(Object obj) {
        return (AssociationClassCallExp)LocationInformationTest.cast(obj, AssociationClassCallExp.class);
    }

    static OperationCallExp<Classifier, Operation> asOperationCall(Object obj) {
        return (OperationCallExp)LocationInformationTest.cast(obj, OperationCallExp.class);
    }

    static BooleanLiteralExp<Classifier> asBooleanLiteral(Object obj) {
        return (BooleanLiteralExp)LocationInformationTest.cast(obj, BooleanLiteralExp.class);
    }

    static StringLiteralExp<Classifier> asStringLiteral(Object obj) {
        return (StringLiteralExp)LocationInformationTest.cast(obj, StringLiteralExp.class);
    }

    static CollectionLiteralExp<Classifier> asCollectionLiteral(Object obj) {
        return (CollectionLiteralExp)LocationInformationTest.cast(obj, CollectionLiteralExp.class);
    }

    static CollectionItem<Classifier> asCollectionItem(Object obj) {
        return (CollectionItem)LocationInformationTest.cast(obj, CollectionItem.class);
    }

    static Variable<Classifier, Parameter> asVariableDeclaration(Object obj) {
        return (Variable)LocationInformationTest.cast(obj, Variable.class);
    }

    static StateExp<Classifier, ?> asState(Object obj) {
        return (StateExp)LocationInformationTest.cast(obj, StateExp.class);
    }

    static TypeExp<Classifier> asType(Object obj) {
        return (TypeExp)LocationInformationTest.cast(obj, TypeExp.class);
    }

    static MessageExp<Classifier, ?, ?> asMessage(Object obj) {
        return (MessageExp)LocationInformationTest.cast(obj, MessageExp.class);
    }

    static UnspecifiedValueExp<Classifier> asUnspecifiedValue(Object obj) {
        return (UnspecifiedValueExp)LocationInformationTest.cast(obj, UnspecifiedValueExp.class);
    }

    static <T> T cast(Object obj, java.lang.Class<?> expectedClass) {
        LocationInformationTest.assertTrue((String)("Expected type: " + expectedClass + ", got: " + obj.getClass()), (boolean)expectedClass.isInstance(obj));
        return (T)obj;
    }

    static void assertAllPositionsSet(OCLExpression<Classifier> expr) {
        LocationInformationTest.assertNotNull(expr);
        expr.accept((Visitor)LocationVerifier.INSTANCE);
    }

    static void assertLocation(ASTNode node, int start, int end) {
        LocationInformationTest.assertEquals((String)"Wrong start position", (int)start, (int)node.getStartPosition());
        LocationInformationTest.assertEquals((String)"Wrong end position", (int)end, (int)node.getEndPosition());
    }

    static void assertTypeLocation(TypedASTNode node, int start, int end) {
        LocationInformationTest.assertEquals((String)"Wrong type start position", (int)start, (int)node.getTypeStartPosition());
        LocationInformationTest.assertEquals((String)"Wrong type end position", (int)end, (int)node.getTypeEndPosition());
    }

    static void assertPropertyLocation(CallingASTNode node, int start, int end) {
        LocationInformationTest.assertEquals((String)"Wrong property start position", (int)start, (int)node.getPropertyStartPosition());
        LocationInformationTest.assertEquals((String)"Wrong property end position", (int)end, (int)node.getPropertyEndPosition());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocationVerifier
    extends AbstractVisitor<Object, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint> {
        static LocationVerifier INSTANCE = new LocationVerifier();

        private LocationVerifier() {
        }

        private boolean isExempt(OCLExpression<Classifier> expr) {
            if (expr instanceof VariableExp) {
                return this.isImplicit((Variable<Classifier, Parameter>)((VariableExp)expr).getReferredVariable());
            }
            return expr instanceof CollectionLiteralExp || expr instanceof CollectionLiteralPart;
        }

        private boolean isImplicit(Variable<Classifier, Parameter> vdecl) {
            String name = vdecl.getName();
            return name == null || name.equals("self") || name.startsWith("temp");
        }

        private void assertPositions(OCLExpression<Classifier> expr) {
            if (!this.isExempt(expr)) {
                LocationInformationTest.assertFalse((String)("Start not set: " + expr), (expr.getStartPosition() < 0 ? 1 : 0) != 0);
                LocationInformationTest.assertFalse((String)("End not set: " + expr), (expr.getEndPosition() < 0 ? 1 : 0) != 0);
                LocationInformationTest.assertTrue((String)("End not after start: " + expr), (expr.getEndPosition() > expr.getStartPosition() ? 1 : 0) != 0);
            }
        }

        private void assertPositions(Variable<Classifier, Parameter> vdecl) {
            if (!this.isImplicit(vdecl)) {
                LocationInformationTest.assertFalse((String)("Start not set: " + vdecl), (vdecl.getStartPosition() < 0 ? 1 : 0) != 0);
                LocationInformationTest.assertFalse((String)("End not set: " + vdecl), (vdecl.getEndPosition() < 0 ? 1 : 0) != 0);
                LocationInformationTest.assertTrue((String)("End not after start: " + vdecl), (vdecl.getEndPosition() > vdecl.getStartPosition() ? 1 : 0) != 0);
            }
        }

        private void assertPositions(TupleLiteralPart<Classifier, Property> tp) {
            LocationInformationTest.assertFalse((String)("Start not set: " + tp), (tp.getStartPosition() < 0 ? 1 : 0) != 0);
            LocationInformationTest.assertFalse((String)("End not set: " + tp), (tp.getEndPosition() < 0 ? 1 : 0) != 0);
            LocationInformationTest.assertTrue((String)("End not after start: " + tp), (tp.getEndPosition() > tp.getStartPosition() ? 1 : 0) != 0);
        }

        public Object visitOperationCallExp(OperationCallExp<Classifier, Operation> oc) {
            this.assertPositions((OCLExpression<Classifier>)oc);
            return super.visitOperationCallExp(oc);
        }

        public Object visitVariableExp(VariableExp<Classifier, Parameter> v) {
            this.assertPositions((OCLExpression<Classifier>)v);
            return super.visitVariableExp(v);
        }

        public Object visitPropertyCallExp(PropertyCallExp<Classifier, Property> pc) {
            this.assertPositions((OCLExpression<Classifier>)pc);
            return super.visitPropertyCallExp(pc);
        }

        public Object visitAssociationClassCallExp(AssociationClassCallExp<Classifier, Property> ac) {
            this.assertPositions((OCLExpression<Classifier>)ac);
            return super.visitAssociationClassCallExp(ac);
        }

        public Object visitVariable(Variable<Classifier, Parameter> vd) {
            if (!"self".equals(vd.getName())) {
                this.assertPositions(vd);
            }
            return super.visitVariable(vd);
        }

        public Object visitIfExp(IfExp<Classifier> i) {
            this.assertPositions((OCLExpression<Classifier>)i);
            return super.visitIfExp(i);
        }

        public Object visitTypeExp(TypeExp<Classifier> t) {
            this.assertPositions((OCLExpression<Classifier>)t);
            return null;
        }

        public Object visitUnspecifiedValueExp(UnspecifiedValueExp<Classifier> uv) {
            this.assertPositions((OCLExpression<Classifier>)uv);
            return null;
        }

        public Object visitStateExp(StateExp<Classifier, State> s) {
            this.assertPositions((OCLExpression<Classifier>)s);
            return null;
        }

        public Object visitMessageExp(MessageExp<Classifier, CallOperationAction, SendSignalAction> m) {
            this.assertPositions((OCLExpression<Classifier>)m);
            return super.visitMessageExp(m);
        }

        public Object visitIntegerLiteralExp(IntegerLiteralExp<Classifier> il) {
            this.assertPositions((OCLExpression<Classifier>)il);
            return null;
        }

        public Object visitRealLiteralExp(RealLiteralExp<Classifier> rl) {
            this.assertPositions((OCLExpression<Classifier>)rl);
            return null;
        }

        public Object visitStringLiteralExp(StringLiteralExp<Classifier> sl) {
            this.assertPositions((OCLExpression<Classifier>)sl);
            return null;
        }

        public Object visitBooleanLiteralExp(BooleanLiteralExp<Classifier> bl) {
            this.assertPositions((OCLExpression<Classifier>)bl);
            return null;
        }

        public Object visitTupleLiteralExp(TupleLiteralExp<Classifier, Property> tl) {
            this.assertPositions((OCLExpression<Classifier>)tl);
            return super.visitTupleLiteralExp(tl);
        }

        public Object visitTupleLiteralPart(TupleLiteralPart<Classifier, Property> tp) {
            this.assertPositions(tp);
            return super.visitTupleLiteralPart(tp);
        }

        public Object visitLetExp(LetExp<Classifier, Parameter> l) {
            this.assertPositions((OCLExpression<Classifier>)l);
            return super.visitLetExp(l);
        }

        public Object visitEnumLiteralExp(EnumLiteralExp<Classifier, EnumerationLiteral> el) {
            this.assertPositions((OCLExpression<Classifier>)el);
            return null;
        }

        public Object visitCollectionLiteralExp(CollectionLiteralExp<Classifier> cl) {
            this.assertPositions((OCLExpression<Classifier>)cl);
            return super.visitCollectionLiteralExp(cl);
        }

        public Object visitIteratorExp(IteratorExp<Classifier, Parameter> ie) {
            this.assertPositions((OCLExpression<Classifier>)ie);
            return super.visitIteratorExp(ie);
        }

        public Object visitIterateExp(IterateExp<Classifier, Parameter> ie) {
            this.assertPositions((OCLExpression<Classifier>)ie);
            return super.visitIterateExp(ie);
        }

        public Object visitInvalidLiteralExp(InvalidLiteralExp<Classifier> il) {
            this.assertPositions((OCLExpression<Classifier>)il);
            return null;
        }

        public Object visitNullLiteralExp(NullLiteralExp<Classifier> il) {
            this.assertPositions((OCLExpression<Classifier>)il);
            return null;
        }
    }
}

