/*
 * Decompiled with CFR 0.152.
 */
package data.constraints.util;

import data.constraints.Constraint;
import data.constraints.ConstraintsPackage;
import data.constraints.ObjectState;
import data.constraints.Severity;
import data.constraints.SeverityInState;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintsValidator
extends EObjectValidator {
    public static final ConstraintsValidator INSTANCE = new ConstraintsValidator();
    public static final String DIAGNOSTIC_SOURCE = "data.constraints";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String CONSTRAINT__EXPRESSION_TYPE_MUST_BE_BOOLEAN__EEXPRESSION = "self.constraintExpression.getType().upperMultiplicity = 1 and\r\n  self.constraintExpression.getType().oclIsKindOf(data::classes::ClassTypeDefinition) and\r\n  self.constraintExpression.getType().oclAsType(data::classes::ClassTypeDefinition).clazz.name = 'Boolean'";
    protected static final String CONSTRAINT__MUST_BE_OWNED__EEXPRESSION = "self.constrainedType->notEmpty() or\r\n  self.theContext->notEmpty() or\r\n  self.preconditionForSignature->notEmpty() or\r\n  self.postconditionForSignature->notEmpty()";

    protected EPackage getEPackage() {
        return ConstraintsPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateConstraint((Constraint)value, diagnostics, context);
            }
            case 1: {
                return this.validateSeverityInState((SeverityInState)value, diagnostics, context);
            }
            case 2: {
                return this.validateObjectState((ObjectState)((Object)value), diagnostics, context);
            }
            case 3: {
                return this.validateSeverity((Severity)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateConstraint(Constraint constraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(constraint, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(constraint, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateConstraint_ExpressionTypeMustBeBoolean(constraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateConstraint_MustBeOwned(constraint, diagnostics, context);
        }
        return result;
    }

    public boolean validateConstraint_ExpressionTypeMustBeBoolean(Constraint constraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ConstraintsPackage.Literals.CONSTRAINT, constraint, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ExpressionTypeMustBeBoolean", CONSTRAINT__EXPRESSION_TYPE_MUST_BE_BOOLEAN__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateConstraint_MustBeOwned(Constraint constraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ConstraintsPackage.Literals.CONSTRAINT, constraint, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "MustBeOwned", CONSTRAINT__MUST_BE_OWNED__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateSeverityInState(SeverityInState severityInState, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(severityInState, diagnostics, context);
    }

    public boolean validateObjectState(ObjectState objectState, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateSeverity(Severity severity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

