/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.helper.tests;

import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.uml.helper.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Package;

public class EvaluationTest
extends AbstractTestSuite {
    public void test_allInstances() {
        this.helper.setContext((Object)this.fruit);
        try {
            String expr = "Fruit.allInstances()->select(f : Fruit | f.color = Color::black)->isEmpty()";
            ResourceImpl res = new ResourceImpl();
            Package pkg = umlf.createPackage();
            pkg.setName("instances");
            res.getContents().add((Object)pkg);
            InstanceSpecification aFruit = this.instantiate(pkg, (Classifier)this.apple);
            this.setValue(aFruit, this.fruit_color, this.color_red);
            aFruit = this.instantiate(pkg, (Classifier)this.apple);
            this.setValue(aFruit, this.fruit_color, this.color_yellow);
            res.getContents().add((Object)aFruit);
            aFruit = this.instantiate(pkg, (Classifier)this.apple);
            this.setValue(aFruit, this.fruit_color, this.color_orange);
            res.getContents().add((Object)aFruit);
            aFruit = this.instantiate(pkg, (Classifier)this.apple);
            this.setValue(aFruit, this.fruit_color, this.color_pink);
            res.getContents().add((Object)aFruit);
            aFruit = this.instantiate(pkg, (Classifier)this.apple);
            this.setValue(aFruit, this.fruit_color, this.color_green);
            res.getContents().add((Object)aFruit);
            this.assertTrue(this.evaluate(this.helper, aFruit, expr));
            this.setValue(aFruit, this.fruit_color, this.color_black);
            this.assertFalse(this.evaluate(this.helper, aFruit, expr));
        }
        catch (Exception e) {
            EvaluationTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_evaluatePrecompiledInvariant_114921() {
        this.helper.setContext((Object)this.fruit);
        try {
            Package pkg = umlf.createPackage();
            pkg.setName("instances");
            OCLExpression constraint = this.getBodyExpression((Constraint)this.helper.createInvariant("color <> Color::black"));
            EvaluationTest.assertNotNull((Object)constraint);
            InstanceSpecification instance = this.instantiate(pkg, (Classifier)this.apple);
            this.setValue(instance, this.fruit_color, this.color_black);
            EvaluationTest.assertFalse((boolean)this.ocl.check((Object)instance, constraint));
            this.setValue(instance, this.fruit_color, this.color_red);
            EvaluationTest.assertTrue((boolean)this.ocl.check((Object)instance, constraint));
        }
        catch (Exception e) {
            EvaluationTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    void assertTrue(Object object) {
        EvaluationTest.assertNotNull((Object)object);
        EvaluationTest.assertSame(Boolean.class, object.getClass());
        EvaluationTest.assertTrue((boolean)((Boolean)object));
    }

    void assertFalse(Object object) {
        EvaluationTest.assertNotNull((Object)object);
        EvaluationTest.assertSame(Boolean.class, object.getClass());
        EvaluationTest.assertFalse((boolean)((Boolean)object));
    }
}

