/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.core;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugCore;
import org.eclipse.ocl.examples.debug.vm.data.VMBreakpointData;
import org.eclipse.ocl.examples.debug.vm.data.VMNewBreakpointData;

public abstract class VMLineBreakpoint
extends LineBreakpoint {
    public static final @NonNull Object OCL_BREAKPOINT_JOBFAMILY = new Object();
    protected static final String HIT_COUNT = "org.eclipse.ocl.examples.debug.vm.hitCount";
    protected static final int HIT_COUNT_UNDEFINED = -1;
    protected static final String CONDITION = "org.eclipse.ocl.examples.debug.vm.condition";
    protected static final String CONDITION_ENABLED = "org.eclipse.ocl.examples.debug.vm.conditionEnabled";
    protected static final String CONDITION_SUSPEND_ON_TRUE = "org.eclipse.ocl.examples.debug.vm.conditionSuspendOnTrue";
    protected static final String TARGET_URI_ATTR = "org.eclipse.ocl.examples.debug.vm.unitUri";
    protected static final String RUN_TO_LINE = "org.eclipse.ocl.examples.debug.vm.runToLine";

    protected VMLineBreakpoint() {
    }

    protected VMLineBreakpoint(@NonNull URI sourceURI, int lineNumber, boolean isRunToLine) throws CoreException {
        IFile sourceFile = this.getDebugCore().toFile(sourceURI);
        IWorkspaceRoot markerResource = sourceFile != null && !isRunToLine ? sourceFile : ResourcesPlugin.getWorkspace().getRoot();
        Integer lineNum = lineNumber;
        IWorkspaceRunnable wr = new IWorkspaceRunnable((IResource)markerResource, isRunToLine, lineNum, sourceFile, sourceURI){
            private final /* synthetic */ IResource val$markerResource;
            private final /* synthetic */ boolean val$isRunToLine;
            private final /* synthetic */ Integer val$lineNum;
            private final /* synthetic */ IFile val$sourceFile;
            private final /* synthetic */ URI val$sourceURI;
            {
                this.val$markerResource = iResource;
                this.val$isRunToLine = bl;
                this.val$lineNum = n;
                this.val$sourceFile = iFile;
                this.val$sourceURI = uRI;
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = this.val$markerResource.createMarker(VMLineBreakpoint.this.getDebugCore().getBreakpointMarkerId());
                VMLineBreakpoint.this.setMarker(marker);
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                if (this.val$isRunToLine) {
                    attributes.put("org.eclipse.debug.core.persisted", Boolean.FALSE);
                    attributes.put(VMLineBreakpoint.RUN_TO_LINE, Boolean.TRUE);
                }
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("lineNumber", this.val$lineNum);
                attributes.put("org.eclipse.debug.core.id", VMLineBreakpoint.this.getModelIdentifier());
                if (this.val$sourceFile == null || this.val$isRunToLine) {
                    attributes.put(VMLineBreakpoint.TARGET_URI_ATTR, this.val$sourceURI.toString());
                }
                VMLineBreakpoint.this.ensureMarker().setAttributes(attributes);
            }
        };
        this.run(this.getMarkerRule((IResource)markerResource), wr);
    }

    public long getID() {
        return this.getMarker().getId();
    }

    public URI getUnitURI() throws CoreException {
        IMarker marker = this.getMarker();
        IResource res = marker.getResource();
        if (res.getType() == 1) {
            return VMDebugCore.getResourceURI(marker.getResource());
        }
        String uriStr = marker.getAttribute(TARGET_URI_ATTR, null);
        assert (uriStr != null);
        return URI.createURI((String)uriStr);
    }

    public @NonNull VMNewBreakpointData createNewBreakpointData() throws CoreException {
        @NonNull String string = this.getUnitURI().toString();
        VMNewBreakpointData newBpData = this.createNewBreakpointData(string);
        return newBpData;
    }

    public @NonNull VMNewBreakpointData createNewBreakpointData(@NonNull String targetURI) throws CoreException {
        VMNewBreakpointData newBpData = new VMNewBreakpointData(this.isConditionEnabled(), this.getCondition(), this.isConditionSuspendOnTrue(), this.getHitCount(), this.getID(), this.getLineNumber(), targetURI);
        return newBpData;
    }

    public @NonNull VMBreakpointData createBreakpointData() throws CoreException {
        VMBreakpointData bpData = new VMBreakpointData(this.isConditionEnabled(), this.getCondition(), this.isConditionSuspendOnTrue(), this.getHitCount());
        return bpData;
    }

    public @NonNull String getModelIdentifier() {
        return this.getDebugCore().getModelId();
    }

    protected abstract @NonNull VMDebugCore getDebugCore();

    public void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    public int getHitCount() throws CoreException {
        return this.ensureMarker().getAttribute(HIT_COUNT, -1);
    }

    public void setHitCount(int count) throws CoreException {
        if (this.getHitCount() != count) {
            if (!this.isEnabled() && count > -1) {
                this.setAttributes(new String[]{"org.eclipse.debug.core.enabled", HIT_COUNT}, new Object[]{Boolean.TRUE, count});
            } else {
                this.setAttributes(new String[]{HIT_COUNT}, new Object[]{count});
            }
        }
    }

    public boolean isLineToRunBreakpoint() {
        return this.getMarker().getAttribute(RUN_TO_LINE, false);
    }

    public boolean supportsCondition() {
        return true;
    }

    public String getCondition() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION, null);
    }

    public void setCondition(String condition) throws CoreException {
        if (condition != null && condition.trim().length() == 0) {
            condition = null;
        }
        this.setAttribute(CONDITION, condition);
    }

    public boolean isConditionEnabled() {
        return this.getMarker().getAttribute(CONDITION_ENABLED, false);
    }

    public void setConditionEnabled(boolean conditionEnabled) throws CoreException {
        this.setAttribute(CONDITION_ENABLED, conditionEnabled);
    }

    public boolean isConditionSuspendOnTrue() throws DebugException {
        return this.ensureMarker().getAttribute(CONDITION_SUSPEND_ON_TRUE, true);
    }

    public void setConditionSuspendOnTrue(boolean suspendOnTrue) throws CoreException {
        if (this.isConditionSuspendOnTrue() != suspendOnTrue) {
            this.setAttribute(CONDITION_SUSPEND_ON_TRUE, suspendOnTrue);
        }
    }
}

