/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.Indexed;

public class GrammarRuleVector
implements Iterable<Integer>,
Comparable<GrammarRuleVector> {
    public static final int @NonNull [] NO_INDEXES = new int[0];
    public static final @NonNull GrammarRuleVector NO_INDEXES_VECTOR = new GrammarRuleVector(){

        @Override
        public @NonNull GrammarRuleVector set(int bitIndex) {
            throw new IllegalStateException();
        }

        @Override
        public @NonNull GrammarRuleVector setAll(@NonNull GrammarRuleVector bits) {
            throw new IllegalStateException();
        }

        @Override
        public @NonNull GrammarRuleVector setCapacity(int capacity) {
            throw new IllegalStateException();
        }
    };
    private long[] longs = null;
    private @Nullable Integer hashCode;

    public GrammarRuleVector() {
    }

    public GrammarRuleVector(int @NonNull [] indexes) {
        this.longs = null;
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            this.set(index);
            ++n2;
        }
    }

    public GrammarRuleVector(long ... longs) {
        this.longs = longs;
    }

    public GrammarRuleVector(@NonNull Indexed @NonNull [] indexes) {
        this.longs = null;
        Indexed[] indexedArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull Indexed index = indexedArray[n2];
            this.set(index.getIndex());
            ++n2;
        }
    }

    public GrammarRuleVector(@NonNull Integer @NonNull [] indexes) {
        this.longs = null;
        Integer[] integerArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull Integer index = integerArray[n2];
            this.set(index);
            ++n2;
        }
    }

    public GrammarRuleVector(@NonNull Iterable<@NonNull ? extends Indexed> indexes) {
        this.longs = null;
        for (Indexed indexed : indexes) {
            this.set(indexed.getIndex());
        }
    }

    @Override
    public int compareTo(@NonNull GrammarRuleVector that) {
        int iThis = this.getLength();
        int iThat = that.getLength();
        int iCommon = Math.min(iThis, iThat);
        int i = Math.max(iThis, iThat);
        while (i > iCommon && i > iThat) {
            if (this.longs[--i] == 0L) continue;
            return 1;
        }
        while (i > iCommon && i > iThis) {
            if (that.longs[--i] == 0L) continue;
            return -1;
        }
        while (--i >= 0) {
            int diff = Long.compareUnsigned(this.longs[i], that.longs[i]);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GrammarRuleVector)) {
            return false;
        }
        GrammarRuleVector that = (GrammarRuleVector)obj;
        int iThis = this.getLength();
        int iThat = that.getLength();
        int iCommon = Math.min(iThis, iThat);
        int i = 0;
        while (i < iCommon) {
            if (this.longs[i] != that.longs[i]) {
                return false;
            }
            ++i;
        }
        while (i < iThis) {
            if (this.longs[i] != 0L) {
                return false;
            }
            ++i;
        }
        while (i < iThat) {
            if (that.longs[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getCapacity() {
        return 64 * this.getLength();
    }

    private int getLength() {
        return this.longs != null ? this.longs.length : 0;
    }

    public final int hashCode() {
        assert (this.longs != null);
        Integer hashCode2 = this.hashCode;
        if (hashCode2 == null) {
            int hash = this.getClass().hashCode();
            boolean isMS = true;
            int i = this.longs.length;
            while (--i >= 0) {
                long word = this.longs[i];
                if (isMS && word == 0L) continue;
                hash = (int)((long)(3 * hash) + word + (word >> 16));
                isMS = false;
            }
            this.hashCode = hashCode2 = Integer.valueOf(hash);
        }
        return hashCode2;
    }

    public @NonNull GrammarRuleVector intersection(@NonNull GrammarRuleVector that) {
        int iThis = this.getLength();
        int iThat = that.getLength();
        int iCommon = Math.min(iThis, iThat);
        long[] results = new long[iCommon];
        int i = 0;
        while (i < iCommon) {
            results[i] = this.longs[i] & that.longs[i];
            ++i;
        }
        return new GrammarRuleVector(results);
    }

    @Override
    public @NonNull Iterator<@NonNull Integer> iterator() {
        return new IndexIterator();
    }

    public @NonNull GrammarRuleVector set(int bitIndex) {
        assert (this.hashCode == null);
        this.setCapacity(bitIndex + 1);
        long mask = 1L << bitIndex % 64;
        int n = bitIndex / 64;
        this.longs[n] = this.longs[n] | mask;
        return this;
    }

    public @NonNull GrammarRuleVector setAll(@NonNull GrammarRuleVector bits) {
        assert (this.hashCode == null);
        if (bits.longs != null) {
            this.setCapacity(64 * bits.longs.length);
            int i = 0;
            while (i < bits.longs.length) {
                int n = i;
                this.longs[n] = this.longs[n] | bits.longs[i];
                ++i;
            }
        }
        return this;
    }

    public @NonNull GrammarRuleVector setCapacity(int capacity) {
        assert (this.hashCode == null);
        int newLength = (capacity + 64 - 1) / 64;
        if (this.longs == null) {
            this.longs = new long[newLength];
        } else if (newLength > this.longs.length) {
            long[] oldLongs = this.longs;
            this.longs = new long[newLength];
            int i = 0;
            while (i < oldLongs.length) {
                this.longs[i] = oldLongs[i];
                ++i;
            }
        }
        return this;
    }

    public boolean test(int bitIndex) {
        int newLength = (bitIndex + 64) / 64;
        if (newLength > this.getLength()) {
            return false;
        }
        long mask = 1L << bitIndex % 64;
        return (this.longs[bitIndex / 64] & mask) != 0L;
    }

    public boolean testAny(@NonNull GrammarRuleVector that) {
        int iThis = this.getLength();
        int iThat = that.getLength();
        int iCommon = Math.min(iThis, iThat);
        int i = 0;
        while (i < iCommon) {
            if ((this.longs[i] & that.longs[i]) != 0L) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        boolean isFirst = true;
        int i = 0;
        while (i < this.getLength()) {
            long word = this.longs[i];
            long mask = 1L;
            int j = 0;
            while (j < 64) {
                if ((word & mask) != 0L) {
                    if (!isFirst) {
                        s.append(",");
                    }
                    s.append(64 * i + j);
                    isFirst = false;
                }
                ++j;
                mask <<= 1;
            }
            ++i;
        }
        s.append("]");
        @NonNull String castString = s.toString();
        return castString;
    }

    public void toString(@NonNull DiagnosticStringBuilder s) {
        boolean isFirst = true;
        int i = 0;
        while (i < this.getLength()) {
            long word = this.longs[i];
            long mask = 1L;
            int j = 0;
            while (j < 64) {
                if ((word & mask) != 0L) {
                    if (!isFirst) {
                        s.append(",");
                    }
                    s.appendRuleName(64 * i + j);
                    isFirst = false;
                }
                ++j;
                mask <<= 1;
            }
            ++i;
        }
    }

    public @NonNull String toWordsString() {
        StringBuilder s = new StringBuilder();
        boolean isFirst = true;
        int i = 0;
        while (i < this.getLength()) {
            if (!isFirst) {
                s.append(",");
            }
            s.append("0x");
            s.append(Long.toHexString(this.longs[i]));
            s.append("L");
            isFirst = false;
            ++i;
        }
        @NonNull String castString = s.toString();
        return castString;
    }

    protected class IndexIterator
    implements Iterator<Integer> {
        private int cursor = this.doNext(-1);

        public int doNext(int cursor) {
            while (++cursor < GrammarRuleVector.this.getCapacity()) {
                if (!GrammarRuleVector.this.test(cursor)) continue;
                return cursor;
            }
            return -1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor >= 0;
        }

        @Override
        public @NonNull Integer next() {
            try {
                Integer n = this.cursor;
                return n;
            }
            finally {
                this.cursor = this.doNext(this.cursor);
            }
        }
    }
}

