/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.utilities.StringUtil;

public class StringUtilTests
extends XtextTestCase {
    public void testStringUtil_OCLconvert() throws Exception {
        this.doEncodeDecode(null, null);
        this.doEncodeDecode("", "");
        this.doEncodeDecode("a", "a");
        this.doEncodeDecode("'", "\\'");
        this.doEncodeDecode("'\r\n\t\b\f\"", "\\'\\r\\n\\t\\b\\f\"");
        this.doEncodeDecode("\u1234", "\\u1234");
        this.doEncodeDecode("no change needed\noops", "no change needed\\noops");
        this.doBadDecode("\\u123", "Malformed Unicode escape: \\u123.");
        this.doBadDecode("ab\\u12fghi", "Malformed Unicode escape: \\u12.");
        this.doBadDecode("ab\\u'", "Malformed Unicode escape: \\u.");
    }

    private void doBadDecode(@NonNull String encodedString, String expectedMessage) {
        try {
            StringUtil.convertFromOCLString((String)encodedString);
        }
        catch (IllegalArgumentException e) {
            StringUtilTests.assertEquals((String)expectedMessage, (String)e.getMessage());
        }
    }

    private void doEncodeDecode(String unencodedString, String expectedEncodedString) {
        String encodedString = StringUtil.convertToOCLString((String)unencodedString);
        StringUtilTests.assertEquals((String)expectedEncodedString, (String)encodedString);
        if (expectedEncodedString != null) {
            if (expectedEncodedString.equals(unencodedString)) {
                StringUtilTests.assertSame((Object)unencodedString, (Object)encodedString);
            }
            String decodedString = StringUtil.convertFromOCLString((String)expectedEncodedString);
            StringUtilTests.assertEquals((String)unencodedString, (String)decodedString);
            if (expectedEncodedString.equals(unencodedString)) {
                StringUtilTests.assertSame((Object)expectedEncodedString, (Object)decodedString);
            }
        }
    }
}

