/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.composition.javaapplication.queries;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.modisco.infra.query.core.java.ParameterValueList;
import org.eclipse.modisco.java.ASTNode;
import org.eclipse.modisco.java.AbstractTypeDeclaration;
import org.eclipse.modisco.java.CompilationUnit;
import org.eclipse.modisco.java.Package;
import org.eclipse.modisco.java.composition.javaapplication.Java2Directory;
import org.eclipse.modisco.java.composition.javaapplication.Java2File;
import org.eclipse.modisco.java.composition.javaapplication.JavaNodeSourceRegion;
import org.eclipse.modisco.kdm.source.extension.ASTNodeSourceRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetASTNodeSourceRegion
implements IJavaModelQuery<ASTNode, JavaNodeSourceRegion> {
    public JavaNodeSourceRegion evaluate(ASTNode astNode, ParameterValueList parameterValues) throws ModelQueryExecutionException {
        JavaNodeSourceRegion result = null;
        CompilationUnit cu = astNode.getOriginalCompilationUnit();
        if (cu != null) {
            ResourceSet rSet;
            AbstractTypeDeclaration typeDeclaration;
            Package targetPackage = cu.getPackage();
            if (targetPackage == null && (typeDeclaration = GetASTNodeSourceRegion.findTypeDeclaration(astNode)) != null) {
                targetPackage = typeDeclaration.getPackage();
            }
            if ((rSet = cu.eResource().getResourceSet()) != null) {
                Java2Directory java2Directory = null;
                EList resources = rSet.getResources();
                block0: for (Resource resource : resources) {
                    for (EObject rootObject : resource.getContents()) {
                        Java2Directory currentJava2Directory;
                        if (!(rootObject instanceof Java2Directory) || (currentJava2Directory = (Java2Directory)rootObject).getJavaPackage() != targetPackage) continue;
                        java2Directory = currentJava2Directory;
                        continue block0;
                    }
                }
                Java2File java2File = null;
                if (java2Directory != null) {
                    for (Java2File java2File2 : java2Directory.getJava2FileChildren()) {
                        if (java2File2.getJavaUnit() != cu) continue;
                        java2File = java2File2;
                        break;
                    }
                }
                if (java2File != null) {
                    for (ASTNodeSourceRegion astNodeSR : java2File.getChildren()) {
                        if (astNodeSR.getNode() != astNode) continue;
                        result = (JavaNodeSourceRegion)astNodeSR;
                        break;
                    }
                }
            }
        }
        return result;
    }

    private static AbstractTypeDeclaration findTypeDeclaration(ASTNode astNode) {
        AbstractTypeDeclaration result = null;
        if (astNode != null) {
            if (astNode instanceof AbstractTypeDeclaration) {
                result = (AbstractTypeDeclaration)astNode;
            } else {
                CompilationUnit cu = astNode.getOriginalCompilationUnit();
                if (cu.getTypes().size() > 0) {
                    result = (AbstractTypeDeclaration)cu.getTypes().get(0);
                }
            }
        }
        return result;
    }
}

