/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.xml.internal.resource;

import com.ibm.icu.lang.UCharacter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.xml.Attribute;
import org.eclipse.gmt.modisco.xml.Comment;
import org.eclipse.gmt.modisco.xml.DocumentTypeDeclaration;
import org.eclipse.gmt.modisco.xml.Element;
import org.eclipse.gmt.modisco.xml.Namespace;
import org.eclipse.gmt.modisco.xml.ProcessingInstruction;
import org.eclipse.gmt.modisco.xml.Root;
import org.eclipse.gmt.modisco.xml.Text;
import org.eclipse.gmt.modisco.xml.emf.MoDiscoXMLFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericXMLHandler
extends DefaultHandler
implements LexicalHandler {
    public static final String XMLNS = "xmlns";
    public static final String OPTION_IGNORE_WHITESPACE = "OPTION_IGNORE_WHITESPACE";
    public static final String OPTION_LIGHTWEIGHT_MODEL = "OPTION_LIGHTWEIGHT_MODEL";
    private final Map<String, Object> parameters;
    private final Resource container;
    private Root root;
    private Element current;
    private DocumentTypeDeclaration dtd;
    private boolean nextIsCDATA = false;
    private List<ProcessingInstruction> leadingPIs = null;
    private Boolean ignoreWhiteSpace = null;
    private Boolean lightweightModel = null;

    public GenericXMLHandler(Resource resource, Map<String, Object> options) {
        this.container = resource;
        this.parameters = options;
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (this.root == null) {
            this.root = MoDiscoXMLFactory.eINSTANCE.createRoot();
            this.root.setName(qName);
            this.container.getContents().add((Object)this.root);
            this.current = this.root;
            if (this.dtd != null) {
                this.root.setDtd(this.dtd);
            }
            if (this.leadingPIs != null) {
                this.root.getLeadingPIs().addAll(this.leadingPIs);
            }
        } else {
            Element newElement = MoDiscoXMLFactory.eINSTANCE.createElement();
            newElement.setName(qName);
            this.current.getChildren().add((Object)newElement);
            this.current = newElement;
        }
        int i = 0;
        while (i < attrs.getLength()) {
            String name = attrs.getQName(i);
            if (this.current == this.root && name.startsWith(XMLNS)) {
                Namespace newNamespace = MoDiscoXMLFactory.eINSTANCE.createNamespace();
                if (name.length() == XMLNS.length()) {
                    newNamespace.setName("");
                } else {
                    newNamespace.setName(name.substring(XMLNS.length() + 1));
                }
                newNamespace.setValue(attrs.getValue(i));
                this.root.getNamespaces().add((Object)newNamespace);
            } else {
                Attribute newAttribute = MoDiscoXMLFactory.eINSTANCE.createAttribute();
                newAttribute.setName(name);
                newAttribute.setValue(attrs.getValue(i));
                this.current.getChildren().add((Object)newAttribute);
            }
            ++i;
        }
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        this.current = this.current.getParent();
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (this.current != null) {
            boolean hasContent = true;
            if (this.isLightweightModel()) {
                hasContent = false;
                int index = start;
                while (!hasContent && index < start + length) {
                    hasContent = !UCharacter.isWhitespace((int)ch[index]);
                    ++index;
                }
            }
            if (hasContent) {
                String text = new String(ch, start, length);
                if (this.isIgnoreWhitespace()) {
                    text = text.trim();
                }
                if (text.length() > 0) {
                    Text newElement = this.nextIsCDATA ? MoDiscoXMLFactory.eINSTANCE.createCDATA() : MoDiscoXMLFactory.eINSTANCE.createText();
                    newElement.setName(text);
                    this.current.getChildren().add((Object)newElement);
                }
            }
        }
    }

    @Override
    public final void comment(char[] ch, int start, int length) throws SAXException {
        String text;
        if (this.current != null && !this.isLightweightModel() && (text = new String(ch, start, length)).length() > 0) {
            Comment newElement = MoDiscoXMLFactory.eINSTANCE.createComment();
            newElement.setName(text);
            this.current.getChildren().add((Object)newElement);
        }
    }

    @Override
    public final void startDTD(String name, String publicId, String systemId) throws SAXException {
        DocumentTypeDeclaration newDtd = MoDiscoXMLFactory.eINSTANCE.createDocumentTypeDeclaration();
        newDtd.setName(name);
        newDtd.setPublicID(publicId);
        newDtd.setSystemID(systemId);
        this.dtd = newDtd;
        if (this.root != null) {
            this.root.setDtd(this.dtd);
        }
    }

    private boolean isIgnoreWhitespace() {
        if (this.ignoreWhiteSpace == null) {
            this.ignoreWhiteSpace = this.parameters != null && this.parameters.get(OPTION_IGNORE_WHITESPACE) != null ? (Boolean)this.parameters.get(OPTION_IGNORE_WHITESPACE) : Boolean.valueOf(false);
        }
        return this.ignoreWhiteSpace;
    }

    private boolean isLightweightModel() {
        if (this.lightweightModel == null) {
            this.lightweightModel = this.parameters != null && this.parameters.get(OPTION_LIGHTWEIGHT_MODEL) != null ? (Boolean)this.parameters.get(OPTION_LIGHTWEIGHT_MODEL) : Boolean.valueOf(false);
        }
        return this.lightweightModel;
    }

    @Override
    public final void endCDATA() throws SAXException {
        this.nextIsCDATA = false;
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
        ProcessingInstruction newElement = MoDiscoXMLFactory.eINSTANCE.createProcessingInstruction();
        newElement.setName(target);
        newElement.setData(data);
        if (this.current != null) {
            this.current.getChildren().add((Object)newElement);
        } else {
            if (this.leadingPIs == null) {
                this.leadingPIs = new ArrayList<ProcessingInstruction>();
            }
            this.leadingPIs.add(newElement);
        }
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
    }

    @Override
    public final void startCDATA() throws SAXException {
        this.nextIsCDATA = true;
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
    }
}

