/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.launch;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.util.emf.core.IBrowserRegistry;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.IDiscoverer;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.launch.LaunchConfiguration;
import org.eclipse.modisco.infra.discovery.launch.ParameterValue;
import org.eclipse.modisco.infra.discovery.ui.Messages;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.utils.LaunchConfigUtils;
import org.eclipse.modisco.infra.discovery.ui.internal.util.LaunchModelUtils;
import org.eclipse.osgi.util.NLS;

public class DiscovererLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            LaunchConfiguration configurationModel = LaunchConfigUtils.getConfigurationModel(configuration);
            String validationResult = LaunchModelUtils.validate(configurationModel);
            if (validationResult != null) {
                Status status = new Status(4, "org.eclipse.modisco.infra.discovery.ui", validationResult);
                throw new CoreException((IStatus)status);
            }
            String name = configurationModel.getDiscoverer().getId();
            Object source = configurationModel.getSource();
            IDiscoverer discoverer = IDiscoveryManager.INSTANCE.createDiscovererImpl(name);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            EList parameterValues = configurationModel.getParameterValues();
            for (ParameterValue parameterValue : parameterValues) {
                if (parameterValue.getValue() == null) continue;
                parameters.put(parameterValue.getParameter().getId(), parameterValue.getValue());
            }
            Object progressMonitor = monitor != null ? monitor : new NullProgressMonitor();
            progressMonitor.beginTask(NLS.bind((String)Messages.DiscovererLaunchConfigurationDelegate_discoveringModel, (Object)name), -1);
            IDiscoveryManager.INSTANCE.discoverElement(discoverer, source, parameters, progressMonitor);
            if (discoverer instanceof AbstractModelDiscoverer && configurationModel.isOpenModelAfterDiscovery()) {
                AbstractModelDiscoverer modelDiscoverer = (AbstractModelDiscoverer)discoverer;
                Resource targetModel = modelDiscoverer.getTargetModel();
                if (targetModel.getURI() == null) {
                    DiscovererDescription discovererDescription = IDiscoveryManager.INSTANCE.getDiscovererDescription(discoverer);
                    targetModel.setURI(URI.createURI((String)("temp:/" + discovererDescription.getId() + "/" + System.currentTimeMillis())));
                }
                IBrowserRegistry.INSTANCE.browseResource(targetModel);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.modisco.infra.discovery.ui", "Please, check your discoverer configuration.", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }
}

