/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors.table;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;

public abstract class TableSorter
extends ViewerComparator {
    public static final int ASCENDING = -1;
    public static final int NONE = 0;
    public static final int DESCENDING = 1;
    private int fSortingDirection = 0;
    private final TableViewerColumn column;
    private final TableViewer fTableViewer;

    public TableSorter(TableViewer viewer, TableViewerColumn column) {
        this.column = column;
        this.fTableViewer = viewer;
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableSorter.this.columnClicked();
            }
        });
    }

    private void columnClicked() {
        if (this.fTableViewer.getComparator() == null || this.fTableViewer.getComparator() != this) {
            this.setSorting(1);
            return;
        }
        switch (this.fSortingDirection) {
            case 1: {
                this.setSorting(-1);
                break;
            }
            case -1: {
                this.setSorting(0);
                break;
            }
            case 0: {
                this.setSorting(1);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled sorting direction");
            }
        }
    }

    public void setSorting(int direction) {
        this.fSortingDirection = direction;
        Table table = this.fTableViewer.getTable();
        switch (direction) {
            case 1: {
                table.setSortColumn(this.column.getColumn());
                table.setSortDirection(128);
                this.fTableViewer.setComparator((ViewerComparator)this);
                break;
            }
            case -1: {
                table.setSortColumn(this.column.getColumn());
                table.setSortDirection(1024);
                this.fTableViewer.setComparator((ViewerComparator)this);
                this.fTableViewer.refresh();
                break;
            }
            case 0: {
                table.setSortColumn(null);
                table.setSortDirection(0);
                this.fTableViewer.setComparator(null);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled sorting direction");
            }
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.fSortingDirection * this.doCompare(viewer, e1, e2);
    }

    protected abstract int doCompare(Viewer var1, Object var2, Object var3);
}

