/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.AbstractMethodDeclaration;
import org.eclipse.modisco.java.Model;
import org.eclipse.modisco.java.discoverer.DiscoverJavaModelFromJavaProject;
import org.eclipse.modisco.java.discoverer.JavaModelUtils;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.DiscoverMethodCallsModelFromJavaModel;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.DiscoverMethodCallsModelFromJavaProject;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.internal.converter.MethodCallsGraphConverter;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.ui.internal.Activator;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.ui.internal.Messages;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.ui.internal.MethodCallsJavaBridge;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.ui.internal.editor.PrefuseGraphInput;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.methodcalls.CallNode;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.methodcalls.CallsModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;

public class DisplayMethodCallsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection) {
                DisplayMethodCallsHandler.open(object);
            }
        }
        return null;
    }

    private static void open(Object object) {
        if (object instanceof IJavaProject) {
            IJavaProject javaProject = (IJavaProject)object;
            DisplayMethodCallsHandler.openOn(javaProject);
        } else if (object instanceof AbstractMethodDeclaration) {
            AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)object;
            DisplayMethodCallsHandler.openOn(abstractMethodDeclaration);
        } else if (object instanceof IMethod) {
            IMethod method = (IMethod)object;
            DisplayMethodCallsHandler.openOn(method);
        } else if (object instanceof IFile) {
            IFile file = (IFile)object;
            if (JavaModelUtils.isJavaModelFile((IFile)file)) {
                DisplayMethodCallsHandler.openOn(file);
            } else {
                MoDiscoLogger.logWarning((String)("Not a Java model: " + file.getFullPath().toString()), (Plugin)Activator.getDefault());
            }
        } else {
            MoDiscoLogger.logWarning((String)("Input not handled: " + object.getClass().getName()), (Plugin)Activator.getDefault());
        }
    }

    private static void openOn(final IMethod method) {
        Job job = new Job(Messages.DisplayMethodCallsHandler_displayMethodCalls){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IJavaProject javaProject = method.getJavaProject();
                    DiscoverJavaModelFromJavaProject discoverer = new DiscoverJavaModelFromJavaProject();
                    discoverer.discoverElement((Object)javaProject, monitor);
                    Resource javaModel = discoverer.getTargetModel();
                    MethodCallsGraphConverter callsConverter = new MethodCallsGraphConverter();
                    CallsModel model = callsConverter.convertJavaResourceToMethodCallsModel(javaModel, javaProject.getElementName());
                    CallNode callNode = MethodCallsJavaBridge.getCallNode(model, method);
                    PrefuseGraphInput input = callNode != null ? new PrefuseGraphInput(callNode, method.getJavaProject()) : new PrefuseGraphInput(model.eResource(), method.getJavaProject());
                    DisplayMethodCallsHandler.openPrefuseEditor(input);
                }
                catch (DiscoveryException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static void openOn(final AbstractMethodDeclaration abstractMethodDeclaration) {
        Job job = new Job(Messages.DisplayMethodCallsHandler_displayMethodCalls){

            protected IStatus run(IProgressMonitor monitor) {
                IJavaProject javaProject = this.retrieveJavaProject(abstractMethodDeclaration);
                if (javaProject != null) {
                    MethodCallsGraphConverter callsConverter = new MethodCallsGraphConverter();
                    CallsModel model = callsConverter.convertJavaResourceToMethodCallsModel(abstractMethodDeclaration.eResource(), javaProject.getElementName());
                    CallNode callNode = MethodCallsJavaBridge.getCallNode(model, abstractMethodDeclaration);
                    PrefuseGraphInput input = callNode != null ? new PrefuseGraphInput(callNode, javaProject) : new PrefuseGraphInput(model.eResource(), javaProject);
                    DisplayMethodCallsHandler.openPrefuseEditor(input);
                } else {
                    MessageDialog.openError(null, (String)Messages.DisplayMethodCallsHandler_noJavaProject, (String)Messages.DisplayMethodCallsHandler_noJavaProjectLong);
                }
                return Status.OK_STATUS;
            }

            private Model retrieveModel(EObject eObject) {
                Model model = null;
                EObject parent = eObject.eContainer();
                if (parent != null) {
                    model = parent instanceof Model ? (Model)parent : this.retrieveModel(parent);
                }
                return model;
            }

            private IJavaProject retrieveJavaProject(AbstractMethodDeclaration method) {
                String projectName;
                IWorkspaceRoot root;
                IProject project;
                IJavaProject tempProject = null;
                Model model = this.retrieveModel((EObject)method);
                if (model != null && (project = (root = ResourcesPlugin.getWorkspace().getRoot()).getProject(projectName = model.getName())) != null) {
                    if (project instanceof IJavaProject) {
                        tempProject = (IJavaProject)project;
                    } else {
                        try {
                            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                                tempProject = JavaCore.create((IProject)project);
                            }
                        }
                        catch (CoreException e) {
                            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                        }
                    }
                }
                return tempProject;
            }
        };
        job.schedule();
    }

    private static void openOn(final IFile file) {
        Job job = new Job(Messages.DisplayMethodCallsHandler_displayMethodCalls){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DiscoverMethodCallsModelFromJavaModel discoverer = new DiscoverMethodCallsModelFromJavaModel();
                    discoverer.discoverElement((Object)file, monitor);
                    Resource model = discoverer.getTargetModel();
                    PrefuseGraphInput input = new PrefuseGraphInput(model, JavaCore.create((IProject)file.getProject()));
                    DisplayMethodCallsHandler.openPrefuseEditor(input);
                }
                catch (DiscoveryException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static void openOn(final IJavaProject javaProject) {
        Job job = new Job(Messages.DisplayMethodCallsHandler_displayMethodCalls){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DiscoverMethodCallsModelFromJavaProject discoverer = new DiscoverMethodCallsModelFromJavaProject();
                    discoverer.discoverElement((Object)javaProject, monitor);
                    Resource model = discoverer.getTargetModel();
                    PrefuseGraphInput input = new PrefuseGraphInput(model, javaProject);
                    DisplayMethodCallsHandler.openPrefuseEditor(input);
                }
                catch (DiscoveryException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected static void openPrefuseEditor(final IEditorInput editorInput) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)"org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.ui.prefuse.EditorID", (boolean)true);
                }
                catch (PartInitException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
        });
    }
}

