/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor.search.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;
import org.eclipse.xtend.shared.ui.editor.AbstractXtendXpandEditor;
import org.eclipse.xtend.shared.ui.editor.search.actions.DeclarationsSearchGroup;
import org.eclipse.xtend.shared.ui.editor.search.actions.ReferencesSearchGroup;

public class SearchActionGroup
extends ActionGroup {
    private AbstractXtendXpandEditor editor;
    private final ReferencesSearchGroup referencesGroup;
    private final DeclarationsSearchGroup declarationsGroup;

    public SearchActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getViewSite());
    }

    public SearchActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public SearchActionGroup(AbstractXtendXpandEditor editor) {
        Assert.isNotNull((Object)((Object)editor));
        this.editor = editor;
        this.referencesGroup = new ReferencesSearchGroup(editor);
        this.declarationsGroup = new DeclarationsSearchGroup(editor);
    }

    private SearchActionGroup(IWorkbenchSite site) {
        this.referencesGroup = new ReferencesSearchGroup(site);
        this.declarationsGroup = new DeclarationsSearchGroup(site);
    }

    public void setContext(ActionContext context) {
        this.referencesGroup.setContext(context);
        this.declarationsGroup.setContext(context);
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.referencesGroup.fillActionBars(actionBar);
        this.declarationsGroup.fillActionBars(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (PreferenceConstants.getPreferenceStore().getBoolean("Search.usereducemenu")) {
            this.referencesGroup.fillContextMenu(menu);
            this.declarationsGroup.fillContextMenu(menu);
        } else {
            IMenuManager target = menu;
            MenuManager searchSubMenu = null;
            if (this.editor != null) {
                String groupName = "Search";
                searchSubMenu = new MenuManager(groupName, "group.find");
                searchSubMenu.add((IContributionItem)new GroupMarker("group.find"));
                target = searchSubMenu;
            }
            this.referencesGroup.fillContextMenu(target);
            this.declarationsGroup.fillContextMenu(target);
            if (searchSubMenu != null) {
                searchSubMenu.add((IContributionItem)new Separator());
            }
            if (searchSubMenu != null && searchSubMenu.getItems().length > 2) {
                menu.appendToGroup("group.find", (IContributionItem)searchSubMenu);
            }
        }
    }

    public void dispose() {
        this.referencesGroup.dispose();
        this.declarationsGroup.dispose();
        super.dispose();
    }
}

