/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2.output;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xtend.util.EncodingDetector;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.PostProcessor;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlBeautifier
implements PostProcessor {
    private final Log log = LogFactory.getLog(this.getClass());
    private String[] fileExtensions = new String[]{".xml", ".xsl", ".xsd", ".wsdd", ".wsdl"};

    public void setFileExtensions(String[] fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public void beforeWriteAndClose(FileHandle info) {
        if (this.isXmlFile(info.getTargetFile().getAbsolutePath())) {
            try {
                String bufferedString = info.getBuffer().toString().trim();
                int indEncoding = bufferedString.indexOf("encoding");
                int indEndHeader = bufferedString.indexOf("?>");
                String readEncoding = null;
                Document doc = null;
                if (bufferedString.startsWith("<?xml") && indEncoding > 0 && indEncoding < indEndHeader) {
                    readEncoding = info.getFileEncoding();
                    doc = this.parseDocument(bufferedString, readEncoding);
                } else {
                    doc = this.parseDocument(bufferedString, null);
                }
                TransformerFactory tfactory = TransformerFactory.newInstance();
                try {
                    tfactory.setAttribute("indent-number", new Integer(2));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                tfactory.setURIResolver(new URIResolver(){

                    public Source resolve(String href, String base) throws TransformerException {
                        return new Source(){

                            public String getSystemId() {
                                return "";
                            }

                            public void setSystemId(String systemId) {
                            }
                        };
                    }
                });
                try {
                    Transformer serializer = tfactory.newTransformer();
                    if (doc.getDoctype() != null) {
                        String systemValue = doc.getDoctype().getSystemId();
                        String publicID = doc.getDoctype().getPublicId();
                        serializer.setOutputProperty("doctype-system", systemValue);
                        serializer.setOutputProperty("doctype-public", publicID);
                    }
                    serializer.setOutputProperty("indent", "yes");
                    serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                    serializer.setOutputProperty("encoding", info.getFileEncoding());
                    serializer.setErrorListener(new ErrorListener(){

                        public void error(TransformerException arg0) throws TransformerException {
                        }

                        public void fatalError(TransformerException arg0) throws TransformerException {
                        }

                        public void warning(TransformerException arg0) throws TransformerException {
                        }
                    });
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    serializer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter((OutputStream)byteArrayOutputStream, info.getFileEncoding())));
                    String string = byteArrayOutputStream.toString(info.getFileEncoding());
                    info.setBuffer(new StringBuffer(string));
                }
                catch (TransformerException e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private Document parseDocument(String bufferedString, String encoding) throws Exception {
        ArrayList<String> encodingsToTry = new ArrayList<String>();
        if (encoding != null) {
            encodingsToTry.add(encoding);
        } else {
            byte[] sampleBytes = bufferedString.substring(0, Math.min(64, bufferedString.length())).getBytes();
            encodingsToTry.add(EncodingDetector.detectEncoding((byte[])sampleBytes).displayName());
            encodingsToTry.add("ISO-8859-1");
            encodingsToTry.add("UTF-8");
            encodingsToTry.add("MacRoman");
            encodingsToTry.add("UTF-16");
            encodingsToTry.add("UTF-16BE");
            encodingsToTry.add("UTF-16LE");
        }
        encodingsToTry.add(System.getProperty("file.encoding"));
        Document doc = null;
        Exception lastException = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        builder.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                XmlBeautifier.this.log.warn((Object)exception.getMessage());
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                if (exception.getMessage() == null || !exception.getMessage().startsWith("Invalid byte")) {
                    XmlBeautifier.this.log.warn((Object)exception.getMessage());
                }
            }

            public void warning(SAXParseException exception) throws SAXException {
                XmlBeautifier.this.log.debug((Object)exception.getMessage());
            }
        });
        for (String enc : encodingsToTry) {
            try {
                doc = builder.parse(new ByteArrayInputStream(bufferedString.getBytes(enc)));
                break;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (doc == null && lastException != null) {
            throw lastException;
        }
        return doc;
    }

    public boolean isXmlFile(String absolutePath) {
        int i = 0;
        while (i < this.fileExtensions.length) {
            if (absolutePath.endsWith(this.fileExtensions[i].trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void afterClose(FileHandle impl) {
    }
}

