/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.Outlet;

public class FileHandleImpl
implements FileHandle {
    private final Log log = LogFactory.getLog(this.getClass());
    private StringBuffer buffer = new StringBuffer();
    private File targetFile = null;
    private Outlet outlet = null;

    public FileHandleImpl(Outlet outlet, File f) {
        this.outlet = outlet;
        this.targetFile = f.getAbsoluteFile();
    }

    public Outlet getOutlet() {
        return this.outlet;
    }

    public CharSequence getBuffer() {
        return this.buffer;
    }

    public void setBuffer(CharSequence buffer) {
        this.buffer = new StringBuffer(buffer);
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public boolean isAppend() {
        return this.outlet.isAppend();
    }

    public boolean isOverwrite() {
        return this.outlet.isOverwrite();
    }

    public String getFileEncoding() {
        return this.outlet.getFileEncoding();
    }

    public void writeAndClose() {
        block13: {
            try {
                if (!this.isOverwrite() && this.targetFile.exists()) {
                    this.log.debug((Object)("Skipping file : " + this.targetFile.getAbsolutePath() + " cause it exists allready"));
                    return;
                }
                this.log.debug((Object)("Opening file : " + this.targetFile.getAbsolutePath()));
                File parentDir = this.targetFile.getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                    if (!parentDir.isDirectory()) {
                        throw new RuntimeException("Failed to create parent directories of file " + this.targetFile.getAbsolutePath());
                    }
                }
                this.outlet.beforeWriteAndClose(this);
                if (!this.outlet.shouldWrite(this)) break block13;
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(this.targetFile, this.isAppend());
                    out.write(this.getBytes());
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                            this.outlet.afterClose(this);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] getBytes() {
        if (this.getFileEncoding() != null) {
            try {
                return this.buffer.toString().getBytes(this.getFileEncoding());
            }
            catch (UnsupportedEncodingException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.buffer.toString().getBytes();
    }
}

