/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.taglib.workspace;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.JET2TagException;

public final class ActionsUtil {
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final byte[] BOM_UTF_8 = new byte[]{-17, -69, -65};

    private ActionsUtil() {
    }

    public static boolean writeTextFileFromWriter(IFile file, boolean replace, String encoding, boolean derived, JET2Writer writer, IProgressMonitor monitor) throws JET2TagException {
        writer.finalizeContent(file);
        boolean written = ActionsUtil.writeTextFile(file, replace, encoding, derived, writer.toString(), monitor);
        if (written) {
            writer.contentCommitted(file);
        }
        return written;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeTextFile(IFile file, boolean replace, String encoding, boolean derived, String contents, IProgressMonitor monitor) throws JET2TagException {
        block15: {
            block14: {
                try {
                    try {
                        String fileMessage = MessageFormat.format(JET2Messages.WsFileFromWriterAction_WritingFile, file.getFullPath().toString());
                        monitor.beginTask(fileMessage, 5);
                        if (file.exists() && !replace) {
                            Object var10_9 = null;
                            break block14;
                        }
                        if (!file.exists()) {
                            if (file.getParent() instanceof IFolder) {
                                ActionsUtil.ensureFolderExists((IFolder)file.getParent(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            } else {
                                monitor.worked(1);
                            }
                            file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            monitor.worked(2);
                        }
                        if (encoding != null) {
                            file.setCharset(encoding.length() > 0 ? encoding : null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            monitor.worked(1);
                        }
                        InputStream source = new ByteArrayInputStream(contents.getBytes(file.getCharset()));
                        boolean hasBOM = false;
                        IContentDescription description = file.getContentDescription();
                        boolean bl = hasBOM = description != null && description.getProperty(IContentDescription.BYTE_ORDER_MARK) != null;
                        if (hasBOM && CHARSET_UTF_8.equals(file.getCharset())) {
                            source = new SequenceInputStream(new ByteArrayInputStream(IContentDescription.BOM_UTF_8), source);
                        }
                        monitor.worked(1);
                        file.setContents(source, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        file.setDerived(derived);
                        break block15;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new JET2TagException(e);
                    }
                    catch (CoreException e) {
                        throw new JET2TagException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return false;
        }
        Object var10_10 = null;
        monitor.done();
        return true;
    }

    public static void ensureFolderExists(IFolder folder, IProgressMonitor monitor) throws JET2TagException {
        IProject project = folder.getProject();
        IPath relPath = folder.getProjectRelativePath();
        monitor.beginTask(MessageFormat.format(JET2Messages.WsFolderAction_CreatingFolder, folder.getFullPath().toString()), relPath.segmentCount());
        int i = 1;
        while (i <= relPath.segmentCount()) {
            IPath subPath = relPath.uptoSegment(i);
            IFolder iFolder = project.getFolder(subPath);
            if (!iFolder.exists()) {
                try {
                    iFolder.create(false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    throw new JET2TagException(e.getMessage(), e);
                }
            } else {
                monitor.worked(1);
            }
            ++i;
        }
    }

    public static boolean writeBinaryFile(IFile file, boolean replace, byte[] contents, IProgressMonitor monitor) throws JET2TagException {
        block10: {
            String fileMessage = MessageFormat.format(JET2Messages.WsCopyBinaryFileAction_WritingFile, file.getFullPath().toString());
            monitor.beginTask(fileMessage, 2);
            if (!file.exists() || replace) break block10;
            Object var6_6 = null;
            monitor.done();
            return false;
        }
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(contents);
            if (file.getParent() instanceof IFolder) {
                ActionsUtil.ensureFolderExists((IFolder)file.getParent(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            if (file.exists() && replace) {
                file.setContents((InputStream)input, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else if (!file.exists()) {
                file.create((InputStream)input, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            Object var6_7 = null;
        }
        catch (CoreException e) {
            try {
                throw new JET2TagException(e);
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                monitor.done();
                throw throwable;
            }
        }
        monitor.done();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readTextFile(URL url, String encoding) throws JET2TagException {
        String string;
        InputStream input;
        block17: {
            input = null;
            Reader reader = null;
            try {
                try {
                    input = url.openStream();
                    if (encoding != null) {
                        if (encoding.equals(CHARSET_UTF_8)) {
                            input = ActionsUtil.stripByteOrderMark(input);
                        }
                        reader = new InputStreamReader(input, encoding);
                    } else {
                        reader = new InputStreamReader(input);
                    }
                    StringBuffer inputContents = new StringBuffer();
                    char[] readChars = new char[1024];
                    int read = reader.read(readChars);
                    while (true) {
                        if (read == -1) {
                            reader.close();
                            input.close();
                            string = inputContents.toString();
                            Object var7_9 = null;
                            if (reader == null) break block17;
                            break;
                        }
                        inputContents.append(readChars, 0, read);
                        read = reader.read(readChars);
                    }
                }
                catch (IOException e) {
                    throw new JET2TagException(e);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (input == null) throw throwable;
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            reader.close();
        }
        if (input == null) return string;
        try {}
        catch (IOException iOException) {}
        input.close();
        return string;
    }

    private static InputStream stripByteOrderMark(InputStream input) throws IOException {
        int bytes;
        if (!input.markSupported()) {
            input = new BufferedInputStream(input);
        }
        input.mark(BOM_UTF_8.length + 1);
        int bomLength = BOM_UTF_8.length;
        byte[] bomStore = new byte[bomLength];
        int bytesRead = 0;
        do {
            if ((bytes = input.read(bomStore, bytesRead, bomLength - bytesRead)) != -1) continue;
            throw new IOException();
        } while ((bytesRead += bytes) < bomLength);
        if (!Arrays.equals(BOM_UTF_8, bomStore)) {
            input.reset();
        }
        return input;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBinaryFile(URL url) throws JET2TagException {
        byte[] byArray;
        ByteArrayOutputStream output;
        block14: {
            BufferedInputStream input = null;
            output = null;
            try {
                try {
                    input = new BufferedInputStream(url.openStream());
                    output = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    int read = ((InputStream)input).read(buffer);
                    while (true) {
                        if (read == -1) {
                            byArray = output.toByteArray();
                            Object var5_7 = null;
                            if (input == null) break block14;
                            break;
                        }
                        output.write(buffer, 0, read);
                        read = ((InputStream)input).read(buffer);
                    }
                }
                catch (IOException e) {
                    throw new JET2TagException(e);
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException iOException) {}
                }
                if (output == null) throw throwable;
                try {
                    output.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            ((InputStream)input).close();
        }
        if (output == null) return byArray;
        try {}
        catch (IOException iOException) {}
        output.close();
        return byArray;
    }

    public static void createProject(IProject project, IProgressMonitor monitor) throws JET2TagException {
        ActionsUtil.createProject(project, null, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void createProject(IProject project, IProjectDescription description, IProgressMonitor monitor) throws JET2TagException {
        String createMessage = MessageFormat.format(JET2Messages.WsProjectAction_CreatingProject, project.getName());
        monitor.beginTask(createMessage, 2);
        try {
            try {
                if (!project.exists()) {
                    project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                if (!project.isOpen()) {
                    project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
            }
            catch (IllegalArgumentException e) {
                throw new JET2TagException(e);
            }
            catch (CoreException e) {
                throw new JET2TagException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        monitor.done();
    }

    public static void checkpointWorkspace(boolean build) {
        ActionsUtil.checkpointWorkspace(build, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void checkpointWorkspace(boolean build, IProgressMonitor monitor) {
        ResourcesPlugin.getWorkspace().checkpoint(build);
        if (build) {
            ActionsUtil.waitForBuildToComplete(monitor);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void waitForBuildToComplete(IProgressMonitor monitor) {
        monitor.beginTask(JET2Messages.ProjectTemplateBundleDescriptor_WaitingForBuild, 1);
        try {
            try {
                ResourcesPlugin.getWorkspace().build(10, monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        monitor.done();
    }
}

