/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.taglib;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jet.IWriterListener;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;

public class MarkerHelper
implements IWriterListener {
    private static final String TASKMARKER_ID = "org.eclipse.jet.taskmarker";
    private static final String MARKER_CATEGORY;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jet.taglib.MarkerHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MARKER_CATEGORY = clazz.getName();
    }

    private MarkerHelper() {
    }

    public void finalizeContent(JET2Writer writer, Object file) throws JET2TagException {
    }

    public void postCommitContent(JET2Writer writer, Object file) throws JET2TagException {
        if (file instanceof IFile) {
            IFile iFile = (IFile)file;
            try {
                iFile.deleteMarkers(TASKMARKER_ID, false, 0);
                Position[] positions = writer.getPositions(MARKER_CATEGORY);
                int i = 0;
                while (i < positions.length) {
                    String msg;
                    MarkerPosition markerPos = (MarkerPosition)positions[i];
                    IMarker marker = iFile.createMarker(TASKMARKER_ID);
                    int line = writer.getDocument().getLineOfOffset(markerPos.offset);
                    int start = markerPos.offset;
                    int end = markerPos.offset + markerPos.length;
                    if (start == end) {
                        IRegion lineInformation = writer.getDocument().getLineInformation(line);
                        start = lineInformation.getOffset();
                        end = start + lineInformation.getLength();
                    }
                    if ((msg = markerPos.description) == null || msg.length() == 0) {
                        msg = writer.getDocument().get(start, end - start);
                    }
                    marker.setAttribute("lineNumber", line);
                    marker.setAttribute("charStart", start);
                    marker.setAttribute("charEnd", end);
                    marker.setAttribute("message", (Object)msg);
                    ++i;
                }
            }
            catch (CoreException e) {
                String msg = JET2Messages.MarkerHelper_CouldNotCreateMarker;
                throw new JET2TagException(MessageFormat.format(msg, iFile.getFullPath().toString()), e);
            }
            catch (BadLocationException e) {
                throw new JET2TagException(e);
            }
        }
    }

    public static void createMarkerOnWriter(JET2Writer writer, int start, int end, String description, TagInfo tagInfo, String templatePath) {
        writer.addPositionCategory(MARKER_CATEGORY);
        MarkerPosition markerPosition = new MarkerPosition(start, end - start, description, tagInfo, templatePath);
        writer.addPosition(MARKER_CATEGORY, markerPosition);
        writer.addEventListener(MARKER_CATEGORY, new MarkerHelper());
    }

    private static final class MarkerPosition
    extends Position {
        public final String description;
        public final TagInfo tagInfo;
        public final String templatePath;

        public MarkerPosition(int start, int length, String description, TagInfo tagInfo, String templatePath) {
            super(start, length);
            this.description = description;
            this.tagInfo = tagInfo;
            this.templatePath = templatePath;
        }
    }
}

