/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import java.util.Iterator;
import org.eclipse.jet.internal.xpath.NodeSetImpl;
import org.eclipse.jet.internal.xpath.ast.ExprNode;
import org.eclipse.jet.internal.xpath.ast.NodeSetExpr;
import org.eclipse.jet.internal.xpath.functions.BooleanFunction;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.NodeSet;

public class Predicate
extends NodeSetExpr {
    private final ExprNode predicateExpr;
    private final NodeSetExpr leftNodeSet;

    public Predicate(NodeSetExpr leftNodeSet, ExprNode predicateExpr) {
        this.leftNodeSet = leftNodeSet;
        this.predicateExpr = predicateExpr;
    }

    private NodeSet filter(NodeSet nodeSet, Context context) {
        int contextPosition = 1;
        int contextSize = nodeSet.size();
        NodeSetImpl result = new NodeSetImpl(contextSize);
        Iterator i = nodeSet.iterator();
        while (i.hasNext()) {
            Object node = i.next();
            Context subContext = context.newSubContext(node, contextPosition, contextSize);
            Object exprVal = this.predicateExpr.evalAsObject(subContext);
            if (exprVal instanceof Number) {
                if (((Number)exprVal).doubleValue() == (double)contextPosition) {
                    result.add(node);
                }
            } else if (BooleanFunction.evaluate(exprVal)) {
                result.add(node);
            }
            ++contextPosition;
        }
        return result;
    }

    public NodeSet evalAsNodeSet(Context context) {
        NodeSet nodeSet = this.leftNodeSet.evalAsNodeSet(context);
        return this.filter(nodeSet, context);
    }

    public String toString() {
        return String.valueOf(this.leftNodeSet.toString()) + "[" + this.predicateExpr + "]";
    }
}

