/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler;

import java.util.Stack;
import org.eclipse.jet.BodyContentWriter;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2TemplateLoader;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.compiler.DefaultJET2ASTVisitor;
import org.eclipse.jet.compiler.JET2CompilationUnit;
import org.eclipse.jet.compiler.JET2Expression;
import org.eclipse.jet.compiler.JET2Scriptlet;
import org.eclipse.jet.compiler.TextElement;
import org.eclipse.jet.compiler.XMLBodyElement;
import org.eclipse.jet.compiler.XMLElement;
import org.eclipse.jet.compiler.XMLEmptyElement;
import org.eclipse.jet.internal.compiler.GenXMLElement;
import org.eclipse.jet.transform.TransformContextExtender;

public class MethodBodyCreator
extends DefaultJET2ASTVisitor {
    private static final String NULL_KEYWORD = "null";
    private static final String UNDERSCORE = "_";
    private static final String TAG_INFO_PREFIX = "_jettd_";
    private static final String TAG_PREFIX = "_jettag_";
    private Stack varStack = new Stack();
    private final JET2TemplateLoader templateLoader;
    private final JET2Context context;
    private final JET2Writer out = new BodyContentWriter();
    private String indent = "        ";

    public MethodBodyCreator(JET2TemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
        this.context = new JET2Context(null);
        TransformContextExtender.getInstance(this.context);
    }

    public static String tagVariableName(XMLElement element) {
        return TAG_PREFIX + MethodBodyCreator.tagVariableSuffix(element);
    }

    public static String tagInfoVariableName(XMLElement element) {
        return TAG_INFO_PREFIX + MethodBodyCreator.tagVariableSuffix(element);
    }

    private static String tagVariableSuffix(XMLElement element) {
        return String.valueOf(element.getNSPrefix()) + UNDERSCORE + element.getTagNCName() + UNDERSCORE + element.getLine() + UNDERSCORE + element.getColumn();
    }

    public void visit(XMLBodyElement element) {
        GenXMLElement genElement = this.buildGenElement(element);
        this.varStack.push(genElement.getTagVariable());
        this.generate("templates/xmlStart.jet", this.indent, genElement);
        this.indent = String.valueOf(this.indent) + "    ";
    }

    public void endVisit(XMLBodyElement element) {
        this.indent = this.indent.substring(0, this.indent.length() - 4);
        GenXMLElement genElement = this.buildGenElement(element);
        this.generate("templates/xmlEnd.jet", this.indent, genElement);
        this.varStack.pop();
    }

    public void visit(XMLEmptyElement element) {
        GenXMLElement genElement = this.buildGenElement(element);
        this.generate("templates/xmlStart.jet", this.indent, genElement);
        this.generate("templates/xmlEnd.jet", this.indent, genElement);
    }

    private GenXMLElement buildGenElement(XMLElement element) {
        String tagVarName = MethodBodyCreator.tagVariableName(element);
        String parentTagVar = this.varStack.empty() ? NULL_KEYWORD : (String)this.varStack.peek();
        return new GenXMLElement(element, tagVarName, MethodBodyCreator.tagInfoVariableName(element), parentTagVar);
    }

    public void visit(JET2Expression expression) {
        this.generate("templates/writeJavaExpression.jet", this.indent, expression);
    }

    public void visit(JET2Scriptlet scriptlet) {
        this.out.write(scriptlet.getJavaContent());
    }

    public void visit(TextElement text) {
        this.generate("templates/writeTextElement.jet", this.indent, text);
    }

    public void visit(JET2CompilationUnit compilationUnit) {
    }

    public void endVisit(JET2CompilationUnit compilationUnit) {
        super.endVisit(compilationUnit);
    }

    public String getBuffer() {
        return this.out.getDocument().get();
    }

    private void generate(String templatePath, String indent, Object element) {
        this.context.setVariable("indent", indent);
        this.context.setVariable("element", element);
        JET2Template template = this.templateLoader.getTemplate(templatePath);
        template.generate(this.context, this.out);
    }
}

