/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jet.compiler.Comment;
import org.eclipse.jet.compiler.JET2ASTElement;
import org.eclipse.jet.compiler.JET2Directive;
import org.eclipse.jet.compiler.JavaElement;
import org.eclipse.jet.compiler.TextElement;
import org.eclipse.jet.compiler.XMLBodyElementEnd;
import org.eclipse.jet.compiler.XMLElement;

class BodyElements {
    private List bodyElements = new ArrayList();
    private final JET2ASTElement owner;

    public BodyElements(JET2ASTElement owner) {
        this.owner = owner;
    }

    public List getBodyElements() {
        return Collections.unmodifiableList(this.bodyElements);
    }

    public void addBodyElement(TextElement text) {
        this.bodyElements.add(text);
        text.setParent(this.owner);
    }

    public void addBodyElement(XMLElement xmlElement) {
        this.bodyElements.add(xmlElement);
        xmlElement.setParent(this.owner);
    }

    public void addBodyElement(JavaElement javaElement) {
        this.bodyElements.add(javaElement);
        javaElement.setParent(this.owner);
    }

    public void addBodyElement(JET2Directive directive) {
        this.bodyElements.add(directive);
        directive.setParent(this.owner);
    }

    public void addBodyElement(Comment comment) {
        this.bodyElements.add(comment);
        comment.setParent(this.owner);
    }

    public final JET2ASTElement getOwner() {
        return this.owner;
    }

    public JET2ASTElement elementAfter(JET2ASTElement element) {
        JET2ASTElement nextElement = null;
        if (this.bodyElements == null) {
            throw new IllegalArgumentException();
        }
        int index = this.bodyElements.indexOf(element);
        if (index == -1) {
            throw new IllegalArgumentException();
        }
        if (index + 1 < this.bodyElements.size()) {
            nextElement = (JET2ASTElement)this.bodyElements.get(index + 1);
        }
        return nextElement;
    }

    public void addBodyElement(XMLBodyElementEnd endTag) {
        this.bodyElements.add(endTag);
        endTag.setParent(this.owner);
    }

    public JET2ASTElement elementBefore(JET2ASTElement element) {
        JET2ASTElement prevElement = null;
        if (this.bodyElements == null) {
            throw new IllegalArgumentException();
        }
        int index = this.bodyElements.indexOf(element);
        if (index == -1) {
            throw new IllegalArgumentException();
        }
        if (index > 0) {
            prevElement = (JET2ASTElement)this.bodyElements.get(index - 1);
        }
        return prevElement;
    }
}

