/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.type.impl.java;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xtend.type.impl.java.JavaMetaModel;
import org.eclipse.internal.xtend.type.impl.java.JavaTypeStrategy;
import org.eclipse.xtend.typesystem.AbstractTypeImpl;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeImpl
extends AbstractTypeImpl
implements Type {
    private static final Log log = LogFactory.getLog(JavaTypeImpl.class);
    private Class<?> clazz;
    private Set<Type> superTypes = null;
    private Feature[] features = null;
    private JavaTypeStrategy strategy = null;
    private JavaMetaModel metamodel = null;

    public JavaTypeImpl(JavaMetaModel meta, Class<?> clazz, String name, JavaTypeStrategy strategy) {
        super(meta.getTypeSystem(), name);
        this.clazz = clazz;
        this.metamodel = meta;
        this.strategy = strategy;
    }

    @Override
    public Feature[] getContributedFeatures() {
        if (this.features == null) {
            this.features = this.strategy.getFeatures(this.metamodel, this.clazz, this);
        }
        return this.features;
    }

    public Set<Type> getSuperTypes() {
        if (this.superTypes == null) {
            Type beanType;
            HashSet<Type> result = new HashSet<Type>();
            if (this.clazz.getSuperclass() != null && !this.clazz.getSuperclass().equals(Object.class) && (beanType = this.metamodel.builtinAwareGetTypeForClass(this.clazz.getSuperclass())) != null) {
                result.add(beanType);
            }
            Class<?>[] interfaces = this.clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                Type beanType2 = this.metamodel.builtinAwareGetTypeForClass(interfaces[i]);
                if (beanType2 != null) {
                    result.add(beanType2);
                }
                ++i;
            }
            if (result.isEmpty()) {
                result.add(this.metamodel.getTypeSystem().getObjectType());
            }
            this.superTypes = result;
        }
        return this.superTypes;
    }

    @Override
    public boolean isInstance(Object o) {
        return this.clazz.isInstance(o);
    }

    @Override
    protected boolean internalIsAssignableFrom(Type t) {
        if (t instanceof JavaTypeImpl) {
            return this.clazz.isAssignableFrom(((JavaTypeImpl)t).clazz);
        }
        return false;
    }

    @Override
    public Object newInstance() {
        try {
            return this.clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isAbstract() {
        try {
            return this.clazz.getConstructor(new Class[0]) == null || Modifier.isAbstract(this.clazz.getModifiers());
        }
        catch (SecurityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

