/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.ui.newproject;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jet.ui.Activator;
import org.eclipse.jet.ui.newproject.NewJETProjectPage1Controls;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class NewJETProjectPage1
extends NewJETProjectPage1Controls {
    private String lastBaseID = null;

    public NewJETProjectPage1(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.txtTemplateFolder.setText("templates");
        this.txtJETOutput.setText(preferenceStore.getDefaultString("org.eclipse.jet.compiledTemplateSrcDir"));
        this.txtJavaOutput.setText(preferenceStore.getDefaultString("org.eclipse.jet.javaOutputFolder"));
        this.txtDefJavaPackage.setText(preferenceStore.getDefaultString("org.eclipse.jet.compiledTemplatePackage"));
    }

    protected void txtTemplateFolder_modify(ModifyEvent e) {
        this.validatePage();
    }

    protected void txtJETOutput_modify(ModifyEvent e) {
        this.validatePage();
    }

    protected void txtJavaOutput_modify(ModifyEvent e) {
        this.validatePage();
    }

    protected void txtDefJavaPackage_modify(ModifyEvent e) {
        this.validatePage();
    }

    protected boolean validatePage() {
        boolean parentValid = super.validatePage();
        if (!parentValid) {
            return false;
        }
        String id = this.getBaseID();
        if (!id.equals(this.lastBaseID)) {
            this.lastBaseID = id;
            String newDefPackage = String.valueOf(id) + ".compiled";
            this.txtDefJavaPackage.setText(newDefPackage);
        }
        if (!this.validateFolder(this.txtTemplateFolder)) {
            return false;
        }
        if (!this.validateFolder(this.txtJavaOutput)) {
            return false;
        }
        if (!this.validateFolder(this.txtJETOutput)) {
            return false;
        }
        String defaultJavaPackage = this.getDefaultJavaPackage();
        IStatus status = this.validateJavaPackage(defaultJavaPackage);
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        return true;
    }

    private IStatus validateJavaPackage(String defaultJavaPackage) {
        IStatus status = JavaConventions.validatePackageName((String)defaultJavaPackage);
        return status;
    }

    private boolean validateFolder(Text folderField) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validatePath("/" + this.getProjectName() + "/" + folderField.getText().trim(), 2);
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        return true;
    }

    String getBaseID() {
        String projectName = this.getProjectName();
        String id = projectName.replaceAll("[^a-zA-Z0-9\\._]", "_");
        return id;
    }

    public String getDefJavaPackage() {
        return this.txtDefJavaPackage.getText();
    }

    public String getTemplateFolder() {
        return this.txtTemplateFolder.getText().trim();
    }

    public String getJETOutputFolder() {
        return this.txtJETOutput.getText().trim();
    }

    public String getJavaOutputFolder() {
        return this.txtJavaOutput.getText().trim();
    }

    public String getDefaultJavaPackage() {
        return this.txtDefJavaPackage.getText().trim();
    }
}

