/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.core.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.jet.core.parser.ITemplateInput;
import org.eclipse.jet.core.parser.ITemplateResolverHelper;
import org.eclipse.jet.internal.core.parser.DefaultTemplateInput;
import org.eclipse.jet.internal.core.url.URLUtility;

public class DefaultTemplateResolverHelper
implements ITemplateResolverHelper {
    private final URI baseLocation;

    public DefaultTemplateResolverHelper(URI baseLocation) {
        this.baseLocation = baseLocation;
    }

    public ITemplateInput createTemplateInput(String templatePath) {
        String encoding = "UTF-8";
        return new DefaultTemplateInput(this.baseLocation, templatePath, encoding);
    }

    private void closeStream(InputStream input) {
        try {
            input.close();
        }
        catch (IOException iOException) {}
    }

    private InputStream openStream(URI baseLocation, String templatePath) {
        try {
            URI resolvedURI = baseLocation.resolve(new URI(null, templatePath, null));
            URL templateURL = URLUtility.toURL(resolvedURI);
            InputStream input = templateURL.openStream();
            return input;
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException e) {
            IllegalArgumentException wrapper = new IllegalArgumentException();
            wrapper.initCause(e);
            throw wrapper;
        }
        return null;
    }

    public boolean inputExists(String templatePath) {
        boolean exists = false;
        InputStream input = this.openStream(this.baseLocation, templatePath);
        if (input != null) {
            exists = true;
            this.closeStream(input);
        }
        return exists;
    }
}

