/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.editor.provider;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.editor.EEPlugin;
import org.eclipse.emf.editor.ValidationInfoAdapter;
import org.eclipse.emf.editor.extxpt.ExtXptFacade;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;

public class ExtendedReflectiveItemProviderAdapterFactory
extends ReflectiveItemProviderAdapterFactory {
    private final ExtXptFacade facade;
    private IFile file;

    public ExtendedReflectiveItemProviderAdapterFactory(DecoratingLabelProvider decoratingLabelProvider, ExtXptFacade facade, IFile iFile) {
        this.facade = facade;
        this.reflectiveItemProviderAdapter = new ExtendedReflectiveItemProvider((AdapterFactory)this, decoratingLabelProvider);
        this.file = iFile;
    }

    public final class ExtendedReflectiveItemProvider
    extends ReflectiveItemProvider {
        private final DecoratingLabelProvider labelProvider;

        private ExtendedReflectiveItemProvider(AdapterFactory adapterFactory, DecoratingLabelProvider decoratingLabelProvider) {
            super(adapterFactory);
            this.labelProvider = decoratingLabelProvider;
        }

        public String getTextForFeature(EStructuralFeature feature) {
            return this.getFeatureText(feature);
        }

        public String getText(Object object) {
            String text = this.labelProvider.getText(object);
            if (text == null) {
                if (object instanceof EStructuralFeature) {
                    EStructuralFeature f = (EStructuralFeature)object;
                    text = super.getFeatureText((Object)f);
                }
                text = super.getText(object);
            }
            return text;
        }

        protected Image annotateImage(Image image, int severity) {
            ImageDescriptor[] descriptors = new ImageDescriptor[5];
            if (severity == 3) {
                descriptors[2] = EEPlugin.getDefault().getImageDescriptor("/icons/error.gif");
            }
            if (severity == 2) {
                descriptors[3] = EEPlugin.getDefault().getImageDescriptor("/icons/warning_co.gif");
            }
            image = this.getImageManager().createImage((ImageDescriptor)new DecorationOverlayIcon(image, descriptors));
            return image;
        }

        private ResourceManager getImageManager() {
            return new LocalResourceManager(JFaceResources.getResources());
        }

        public Object getImage(Object object) {
            Image im;
            Object imURI = this.labelProvider.getImage(object);
            if (imURI == null) {
                imURI = super.getImage(object);
            }
            if ((im = ExtendedImageRegistry.getInstance().getImage(imURI)) != null) {
                ValidationInfoAdapter find;
                if (object instanceof EObject && (find = ValidationInfoAdapter.find((EObject)object)) != null) {
                    im = this.annotateImage(im, find.getSeverity());
                }
                return im;
            }
            return imURI;
        }
    }
}

