/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.editor.extxpt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.editor.EEPlugin;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.xtend.XtendFacade;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtXptFacade {
    private IProject project;
    private final ExecutionContext context;
    public static final String CHECK_EXT = "Checks";
    public static final String STYLE_EXT = "ItemLabelProvider";
    public static final String PROPOSAL_EXT = "Proposals";

    public ExtXptFacade(IProject project, ExecutionContext context) {
        this.project = project;
        this.context = context;
    }

    public Object style(String extension, EObject object) {
        String extendFile = String.valueOf(this.path(object)) + STYLE_EXT;
        Object retVal = this.evaluate(extendFile, extension, object);
        return retVal;
    }

    private Object evaluate(String extensionFile, String extensionName, Object ... params) {
        Object retVal = null;
        try {
            XtendFacade facade = XtendFacade.create((ExecutionContext)this.context, (String[])new String[]{extensionFile});
            retVal = facade.call(extensionName, params);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (EvaluationException e) {
            EEPlugin.logError("Exception during extension evaluation", e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            EEPlugin.logError("Exception during extension evaluation", new RuntimeException(e));
        }
        return retVal;
    }

    public List<?> proposals(EStructuralFeature feature, EObject ctx, List<?> fromList) {
        Object eval;
        String extFile = String.valueOf(this.path(ctx)) + PROPOSAL_EXT;
        List<Object> retVal = new ArrayList();
        if (fromList != null) {
            retVal = fromList;
            eval = this.evaluate(extFile, feature.getName(), ctx, fromList);
        } else {
            eval = this.evaluate(extFile, feature.getName(), ctx);
        }
        if (eval != null) {
            if (eval instanceof List) {
                retVal = (List)eval;
            } else {
                EEPlugin.logError("Returned type must be a List! File:" + extFile + ", Extension:" + feature.getName());
            }
        }
        return retVal;
    }

    public Issues check(EObject rootObject) {
        String checkFile = String.valueOf(this.path(rootObject)) + CHECK_EXT;
        ArrayList<EObject> all = new ArrayList<EObject>();
        all.add(rootObject);
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)rootObject);
        TreeIterator iter = rootContainer.eAllContents();
        while (iter.hasNext()) {
            all.add((EObject)iter.next());
        }
        IssuesImpl issuesImpl = new IssuesImpl();
        IXtendXpandProject extxptProject = Activator.getExtXptModelManager().findProject((IResource)this.project);
        if (extxptProject != null) {
            IXtendXpandResource extxptResource = extxptProject.findExtXptResource(checkFile, "chk");
            if (extxptResource != null) {
                ExtensionFile file = (ExtensionFile)extxptResource.getExtXptResource();
                try {
                    file.check(this.context, all, (Issues)issuesImpl, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (Exception e) {
                    EEPlugin.logError("Exception during check evaluation", e);
                }
            }
        } else {
            EEPlugin.logWarning("Enable Xtend/Xpand-Nature for '" + this.project.getName() + "' to check models.");
        }
        return issuesImpl;
    }

    private String path(EObject object) {
        return String.valueOf(object.eClass().getEPackage().getName()) + "::";
    }

    public IProject getProject() {
        return this.project;
    }
}

