/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newfile;

import java.util.EventObject;
import java.util.StringTokenizer;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.AbstractAcceleoNewTemplatesMasterComposite;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.AcceleoNewTemplatesDetailsComposite;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.AcceleoNewTemplatesGlobalController;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.CreateTemplateData;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class AcceleoNewTemplatesWizardController {
    protected boolean templateNameManualChange;
    private AbstractAcceleoNewTemplatesMasterComposite viewMasterComposite;
    private CreateTemplateData model;
    private AcceleoNewTemplatesDetailsComposite viewDetailsComposite;
    private AcceleoNewTemplatesGlobalController globalController;

    public AcceleoNewTemplatesWizardController(CreateTemplateData model) {
        this.model = model;
    }

    public CreateTemplateData getModel() {
        return this.model;
    }

    public void setViewMasterComposite(AbstractAcceleoNewTemplatesMasterComposite viewMasterComposite) {
        this.viewMasterComposite = viewMasterComposite;
    }

    public void setViewDetailsComposite(AcceleoNewTemplatesDetailsComposite viewDetailsComposite) {
        this.viewDetailsComposite = viewDetailsComposite;
    }

    public void setGlobalController(AcceleoNewTemplatesGlobalController globalController) {
        this.globalController = globalController;
    }

    public void createView(Composite parent) {
        this.viewDetailsComposite = new AcceleoNewTemplatesDetailsComposite(parent, 0);
        this.viewMasterComposite = (AbstractAcceleoNewTemplatesMasterComposite)parent;
    }

    public Composite getView() {
        return this.viewDetailsComposite;
    }

    public void firePropertiesChanged(EventObject e, int eventType) {
        String text;
        if (e instanceof ModifyEvent) {
            text = "";
            if (e.getSource() instanceof Text) {
                text = ((Text)e.getSource()).getText();
            } else if (e.getSource() instanceof Combo) {
                text = ((Combo)e.getSource()).getText();
            }
            if (eventType == 0) {
                this.setTemplateName(text);
            } else if (eventType == 1) {
                this.model.setTemplateContainer(text);
            } else if (eventType == 2) {
                this.model.setTemplateMetamodel(text);
            } else if (eventType == 7) {
                this.model.setTemplateExamplePath(text);
            } else if (eventType == 3) {
                this.model.setTemplateFileType(text);
            } else if (eventType == 6) {
                this.model.setTemplateExampleStrategy(text);
            }
        }
        if (e instanceof SelectionEvent) {
            text = "";
            if (e.getSource() instanceof Combo) {
                text = ((Combo)e.getSource()).getText();
            }
            if (eventType == 3) {
                this.model.setTemplateFileType(text);
            } else if (eventType == 4) {
                this.model.setTemplateHasFileBlock(((Button)e.getSource()).getSelection());
            } else if (eventType == 5) {
                this.model.setTemplateIsMain(((Button)e.getSource()).getSelection());
            } else if (eventType == 8) {
                String examplePath;
                String description;
                this.model.setTemplateIsInitialized(((Button)e.getSource()).getSelection());
                if (((Button)e.getSource()).getSelection() && this.viewDetailsComposite.getTemplateExampleStrategy() != null) {
                    description = this.viewDetailsComposite.getTemplateExampleStrategy().getDescription();
                    examplePath = this.viewDetailsComposite.getTemplateExample();
                } else {
                    description = "";
                    examplePath = "";
                }
                this.model.setTemplateExampleStrategy(description);
                this.model.setTemplateExamplePath(examplePath);
            } else if (eventType == 6) {
                this.model.setTemplateExampleStrategy(text);
            }
        }
    }

    private void setTemplateName(String name) {
        this.model.setTemplateShortName(name);
        this.viewMasterComposite.getTreeViewer().refresh();
    }

    public void initView() {
        this.initView(true);
    }

    public void initView(boolean initializeTemplate) {
        this.viewDetailsComposite.setTemplateContainer(this.model.getTemplateContainer());
        this.viewDetailsComposite.setTemplateName(this.model.getTemplateShortName());
        String metamodelType = this.model.getTemplateFileType();
        this.viewDetailsComposite.setMetamodelURI(this.model.getTemplateMetamodel());
        this.viewDetailsComposite.setMetamodelType(metamodelType);
        this.viewDetailsComposite.setTemplateHasFileButtonState(this.model.getTemplateHasFileBlock());
        this.viewDetailsComposite.setTemplateHasMainButtonState(this.model.getTemplateIsMain());
        this.viewDetailsComposite.setTemplateIsInitializeButtonState(this.model.getTemplateIsInitialized());
        this.viewDetailsComposite.setTemplateExamplePath(this.model.getTemplateExamplePath());
        this.viewDetailsComposite.setTemplateExampleStrategy(this.model.getTemplateExampleStrategy());
        if (!initializeTemplate) {
            this.viewDetailsComposite.advancedButton.setVisible(false);
        }
        this.dialogChanged();
    }

    public void dialogChanged() {
        Path containerPath = new Path(this.viewDetailsComposite.getTemplateContainer());
        String fileName = this.viewDetailsComposite.getTemplateName();
        if (containerPath.segmentCount() == 0) {
            this.updateStatus(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Error.MissingContainer"));
        } else if (ResourcesPlugin.getWorkspace().getRoot().getProject(containerPath.segment(0)).exists() && !ResourcesPlugin.getWorkspace().getRoot().getProject(containerPath.segment(0)).isAccessible()) {
            this.updateStatus(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Error.ReadOnly"));
        } else if (fileName.length() == 0) {
            this.updateStatus(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Error.MissingFileName"));
        } else if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Error.InvalidFileName"));
        } else if (ResourcesPlugin.getWorkspace().getRoot().exists(containerPath.append(fileName).addFileExtension("mtl"))) {
            this.updateStatus(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Error.ExistingFile", fileName));
        } else {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(containerPath.append(fileName));
            if (file.getProject().isAccessible() && new AcceleoProject(file.getProject()).getOutputFilePath(file) == null) {
                this.updateStatus(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Error.JavaFolder"));
            } else if (this.viewDetailsComposite.getMetamodelURI().length() == 0) {
                this.updateStatus(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Error.MissingURI"));
            } else if (!this.isValidMetamodelURI(this.viewDetailsComposite.getMetamodelURI())) {
                this.updateStatus(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Error.InvalidURI"));
            } else {
                this.updateStatus(null);
            }
        }
    }

    private boolean isValidMetamodelURI(String uris) {
        StringTokenizer st = new StringTokenizer(uris, ",");
        while (st.hasMoreTokens()) {
            String uri = st.nextToken().trim();
            if (ModelUtils.getEPackage((String)uri) != null || uri.endsWith(".ecore")) continue;
            return false;
        }
        return uris.trim().length() > 0;
    }

    private void updateStatus(String message) {
        this.globalController.updateStatus(message);
    }
}

