/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoCompletionChoice;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.internal.parser.cst.utils.SequenceBlock;
import org.eclipse.acceleo.model.mtl.Macro;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.parser.cst.Block;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.CstPackage;
import org.eclipse.acceleo.parser.cst.ForBlock;
import org.eclipse.acceleo.parser.cst.IfBlock;
import org.eclipse.acceleo.parser.cst.InitSection;
import org.eclipse.acceleo.parser.cst.LetBlock;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.Module;
import org.eclipse.acceleo.parser.cst.ModuleElement;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.TemplateExpression;
import org.eclipse.acceleo.parser.cst.TemplateOverridesValue;
import org.eclipse.acceleo.parser.cst.TextExpression;
import org.eclipse.acceleo.parser.cst.TypedModel;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoCompletionProcessor
implements IContentAssistProcessor {
    private static final char[] AUTO_ACTIVATION_CHARACTERS = new char[]{' ', '.', '[', '-', '>', ':'};
    protected AcceleoSourceContent content;
    private String text;
    private int offset;
    private CSTNode cstNode;
    private String defaultVariableType;

    public AcceleoCompletionProcessor(AcceleoSourceContent content) {
        this.content = content;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int pos) {
        if (viewer != null) {
            this.text = viewer.getDocument().get();
            ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
            this.offset = selection != null && selection.getOffset() == pos ? selection.getOffset() + selection.getLength() : pos;
        } else {
            this.text = this.content.getText();
            this.offset = pos;
        }
        this.cstNode = this.content.getCSTNode(this.offset, this.offset);
        if (this.cstNode instanceof InitSection && this.offset == this.cstNode.getStartPosition() && this.cstNode.eContainer() != null) {
            this.cstNode = (CSTNode)this.cstNode.eContainer();
        }
        this.defaultVariableType = "EObject";
        if (this.text.indexOf("http://www.eclipse.org/uml2/") > -1) {
            this.defaultVariableType = "Element";
        }
        try {
            ICompletionProposal[] iCompletionProposalArray = this.computeCompletionProposals();
            return iCompletionProposalArray;
        }
        finally {
            this.text = null;
            this.offset = 0;
            this.cstNode = null;
        }
    }

    private ICompletionProposal[] computeCompletionProposals() {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (this.cstNode == null || this.cstNode instanceof Module && this.cstNode.getEndPosition() == 0 && this.cstNode.getStartPosition() == 0) {
            this.computeModulePatternProposals(proposals);
        } else if (this.cstNode instanceof TypedModel) {
            this.computeEPackageProposals(proposals);
        } else if (this.cstNode instanceof ModuleImportsValue || this.cstNode instanceof ModuleExtendsValue) {
            this.computeImportProposals(proposals);
        } else if (this.offset > 0 && this.text.charAt(this.offset - 1) != '/') {
            this.computeEClassifierProposals(proposals);
            if (proposals.size() == 0) {
                this.computeKeywordsProposals(proposals);
                if (!this.isNextSignificantChar(']')) {
                    this.computePatternsProposals(proposals);
                }
            }
            if (this.text.charAt(this.offset - 1) != ']') {
                if (this.cstNode instanceof ModelExpression || this.cstNode instanceof InitSection) {
                    this.computeOCLProposals(proposals);
                } else if (this.cstNode instanceof Block && !(this.cstNode instanceof Template)) {
                    this.computeOCLProposals(proposals);
                } else if (this.cstNode instanceof org.eclipse.acceleo.parser.cst.Query && this.cstNode.getStartPosition() > -1 && this.offset > this.cstNode.getStartPosition() && this.isHeaderAfterParenthesis(this.text.substring(this.cstNode.getStartPosition(), this.offset))) {
                    this.computeOCLProposals(proposals);
                } else if (this.cstNode instanceof TemplateOverridesValue) {
                    this.computeTemplatesProposals(proposals);
                }
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private boolean isNextSignificantChar(char ref) {
        if (this.offset < this.text.length()) {
            char c;
            int i = this.offset;
            while (Character.isWhitespace(c = this.text.charAt(i)) && ++i < this.text.length()) {
            }
            return c == ref;
        }
        return false;
    }

    private void computeTemplatesProposals(List<ICompletionProposal> proposals) {
        int i = this.offset;
        while (i > 0 && Character.isLetterOrDigit(this.text.charAt(i - 1))) {
            --i;
        }
        String start = this.text.substring(i, this.offset);
        int startPosition = this.cstNode.getStartPosition();
        if (startPosition < 0) {
            startPosition = 0;
        }
        if (startPosition > this.offset) {
            startPosition = this.offset;
        }
        String textOCL = this.text.substring(startPosition, this.offset);
        Collection<Choice> choices = this.content.getSyntaxHelp(textOCL, this.offset);
        HashSet<String> duplicated = new HashSet<String>();
        for (Choice next : choices) {
            String replacementString = next.getName();
            if (!replacementString.toLowerCase().startsWith(start.toLowerCase())) continue;
            switch (next.getKind()) {
                case OPERATION: {
                    if (!(next.getElement() instanceof EOperation)) break;
                    Image image = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Template.gif");
                    EOperation eOperation = (EOperation)next.getElement();
                    String description = eOperation.getEContainingClass() != null ? String.valueOf(eOperation.getEContainingClass().getName()) + "." + next.getDescription() : next.getDescription();
                    if (duplicated.contains(next.getDescription())) break;
                    duplicated.add(next.getDescription());
                    proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), image, next.getDescription(), null, description));
                    break;
                }
            }
        }
    }

    private void computeOCLProposals(List<ICompletionProposal> proposals) {
        int i = this.offset;
        while (i > 0 && Character.isLetterOrDigit(this.text.charAt(i - 1))) {
            --i;
        }
        String start = this.text.substring(i, this.offset);
        int startPosition = this.cstNode.getStartPosition();
        if (startPosition < 0) {
            startPosition = 0;
        }
        if (startPosition > this.offset) {
            startPosition = this.offset;
        }
        String textOCL = this.text.substring(startPosition, this.offset);
        Collection<Choice> choices = this.content.getSyntaxHelp(textOCL, this.offset);
        HashSet<String> duplicated = new HashSet<String>();
        for (Choice next : choices) {
            String replacementString = next.getName();
            if (!replacementString.toLowerCase().startsWith(start.toLowerCase())) continue;
            switch (next.getKind()) {
                case OPERATION: {
                    this.addOCLOperationChoice(proposals, next, start, duplicated);
                    break;
                }
                case PROPERTY: 
                case SIGNAL: {
                    String displayProperty = next.getDescription();
                    if (next.getElement() instanceof EStructuralFeature) {
                        displayProperty = this.getPropertyDisplay((EStructuralFeature)next.getElement());
                    }
                    if (duplicated.contains(displayProperty)) break;
                    duplicated.add(displayProperty);
                    proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Property.gif"), displayProperty, null, displayProperty));
                    break;
                }
                case ENUMERATION_LITERAL: {
                    if (duplicated.contains(replacementString)) break;
                    duplicated.add(replacementString);
                    proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/EnumLiteral.gif"), replacementString, null, next.getDescription()));
                    break;
                }
                case VARIABLE: {
                    String description;
                    String displayVariable;
                    if ("self".equals(replacementString) || next.getDescription() == null) {
                        displayVariable = replacementString;
                        description = "";
                    } else {
                        displayVariable = String.valueOf(replacementString) + ":" + next.getDescription();
                        description = next.getDescription();
                    }
                    if (duplicated.contains(displayVariable)) break;
                    duplicated.add(displayVariable);
                    proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Variable.gif"), displayVariable, null, description));
                    break;
                }
            }
        }
    }

    private void addOCLOperationChoice(List<ICompletionProposal> proposals, Choice nextOperationChoice, String start, Set<String> duplicated) {
        Image image = nextOperationChoice instanceof AcceleoCompletionChoice ? (((AcceleoCompletionChoice)nextOperationChoice).getAcceleoElement() instanceof org.eclipse.acceleo.model.mtl.Template ? AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Template.gif") : (((AcceleoCompletionChoice)nextOperationChoice).getAcceleoElement() instanceof Query ? AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Query.gif") : (((AcceleoCompletionChoice)nextOperationChoice).getAcceleoElement() instanceof Macro ? AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Macro.gif") : AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Operation.gif")))) : AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Operation.gif");
        if (nextOperationChoice.getElement() instanceof EOperation) {
            EOperation eOperation = (EOperation)nextOperationChoice.getElement();
            String replacementStringWithArgsBefore = String.valueOf(eOperation.getName()) + "(";
            String replacementStringWithArgsAfter = "";
            Iterator eParametersIt = eOperation.getEParameters().iterator();
            while (eParametersIt.hasNext()) {
                EParameter eParameter = (EParameter)eParametersIt.next();
                replacementStringWithArgsAfter = String.valueOf(replacementStringWithArgsAfter) + eParameter.getName();
                if (!eParametersIt.hasNext()) continue;
                replacementStringWithArgsAfter = String.valueOf(replacementStringWithArgsAfter) + ", ";
            }
            replacementStringWithArgsAfter = String.valueOf(replacementStringWithArgsAfter) + ')';
            String description = eOperation.getEContainingClass() != null ? String.valueOf(eOperation.getEContainingClass().getName()) + "." + nextOperationChoice.getDescription() : nextOperationChoice.getDescription();
            if (!duplicated.contains(nextOperationChoice.getDescription())) {
                duplicated.add(nextOperationChoice.getDescription());
                proposals.add((ICompletionProposal)new CompletionProposal(String.valueOf(replacementStringWithArgsBefore) + replacementStringWithArgsAfter, this.offset - start.length(), start.length(), replacementStringWithArgsBefore.length(), image, nextOperationChoice.getDescription(), null, description));
            }
        } else if (!duplicated.contains(nextOperationChoice.getDescription())) {
            duplicated.add(nextOperationChoice.getDescription());
            proposals.add((ICompletionProposal)new CompletionProposal(nextOperationChoice.getName(), this.offset - start.length(), start.length(), nextOperationChoice.getName().length(), image, nextOperationChoice.getDescription(), null, nextOperationChoice.getDescription()));
        }
    }

    private String getPropertyDisplay(EStructuralFeature eStructuralFeature) {
        StringBuffer displayProperty = new StringBuffer();
        displayProperty.append(eStructuralFeature.getName());
        if (eStructuralFeature.getEType() != null) {
            displayProperty.append(':');
            displayProperty.append(eStructuralFeature.getEType().getName());
        }
        if (eStructuralFeature.getLowerBound() == eStructuralFeature.getUpperBound()) {
            displayProperty.append(' ');
            displayProperty.append('[');
            displayProperty.append(eStructuralFeature.getLowerBound());
            displayProperty.append(']');
        } else {
            displayProperty.append(' ');
            displayProperty.append('[');
            displayProperty.append(eStructuralFeature.getLowerBound());
            displayProperty.append("..");
            if (eStructuralFeature.getUpperBound() == -1) {
                displayProperty.append("*");
            } else {
                displayProperty.append(eStructuralFeature.getUpperBound());
            }
            displayProperty.append(']');
        }
        return displayProperty.toString();
    }

    private void computeImportProposals(List<ICompletionProposal> proposals) {
        int i = this.offset;
        while (i > 0 && !Character.isWhitespace(this.text.charAt(i - 1))) {
            --i;
        }
        String start = this.text.substring(i, this.offset);
        for (URI uri : this.content.getAccessibleOutputFiles()) {
            String replacementString = new Path(uri.lastSegment()).removeFileExtension().lastSegment();
            if (!replacementString.toLowerCase().startsWith(start.toLowerCase())) continue;
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Module.gif"), replacementString, null, uri.path()));
        }
    }

    private void computeEPackageProposals(List<ICompletionProposal> proposals) {
        int i = this.offset;
        while (i > 0 && this.text.charAt(i - 1) != '(' && this.text.charAt(i - 1) != ',' && this.text.charAt(i - 1) != '\'') {
            --i;
        }
        String start = this.text.substring(i, this.offset);
        for (String pURI : new TreeSet(EPackage.Registry.INSTANCE.keySet())) {
            if (!pURI.toLowerCase().startsWith(start.toLowerCase())) continue;
            proposals.add((ICompletionProposal)new CompletionProposal(pURI, this.offset - start.length(), start.length(), pURI.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/URI.gif"), pURI, null, pURI));
        }
        if (start.length() > 0) {
            for (String pURI : new TreeSet(EPackage.Registry.INSTANCE.keySet())) {
                String shortName;
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(pURI);
                if (ePackage == null || !(shortName = ePackage.getName()).startsWith(start.toLowerCase())) continue;
                proposals.add((ICompletionProposal)new CompletionProposal(pURI, this.offset - start.length(), start.length(), pURI.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/URI.gif"), pURI, null, pURI));
            }
        }
    }

    private void computeEClassifierProposals(List<ICompletionProposal> proposals) {
        if (this.content.getCST() != null) {
            int i = this.offset;
            while (i > 0 && Character.isLetterOrDigit(this.text.charAt(i - 1))) {
                --i;
            }
            int j = i;
            while (j > 0 && Character.isWhitespace(this.text.charAt(j - 1))) {
                --j;
            }
            if (j > 0 && this.text.charAt(j - 1) == ':') {
                String start = this.text.substring(i, this.offset);
                for (EClassifier eClassifier : this.content.getTypes()) {
                    if (!eClassifier.getName().toLowerCase().startsWith(start.toLowerCase())) continue;
                    proposals.add((ICompletionProposal)new CompletionProposal(eClassifier.getName(), this.offset - start.length(), start.length(), eClassifier.getName().length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Type.gif"), eClassifier.getName(), null, eClassifier.getName()));
                }
            }
        }
    }

    private void computeModulePatternProposals(List<ICompletionProposal> proposals) {
        int i = this.offset;
        while (i > 0 && Character.isLetterOrDigit(this.text.charAt(i - 1))) {
            --i;
        }
        if (i > 0 && this.text.charAt(i - 1) == '[') {
            --i;
        }
        String start = this.text.substring(i, this.offset);
        StringBuffer tabBuffer = new StringBuffer();
        while (i > 0 && Character.isWhitespace(this.text.charAt(i - 1)) && this.text.charAt(i - 1) != '\n') {
            tabBuffer.insert(0, this.text.charAt(i - 1));
            --i;
        }
        if (i == 0 || this.text.charAt(i - 1) == '\n') {
            String fileName = this.content.getFile() != null ? this.content.getFile().getName() : "";
            if ("module".startsWith(start.toLowerCase()) || "[module".startsWith(start.toLowerCase())) {
                String replacementStringBefore = "[module " + new Path(fileName).removeFileExtension().lastSegment() + "('";
                String replacementStringAfter = "') /]\n" + tabBuffer.toString();
                String replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
                proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Pattern.gif"), "[module]", null, replacementString));
            }
        }
    }

    private void computePatternsProposals(List<ICompletionProposal> proposals) {
        int i = this.offset;
        while (i > 0 && (Character.isLetterOrDigit(this.text.charAt(i - 1)) || this.text.charAt(i - 1) == '@')) {
            --i;
        }
        if (i > 0 && (this.text.charAt(i - 1) == '[' || this.text.charAt(i - 1) == ']')) {
            --i;
        }
        String start = this.text.substring(i, this.offset);
        StringBuffer tabBuffer = new StringBuffer();
        while (i > 0 && Character.isWhitespace(this.text.charAt(i - 1)) && this.text.charAt(i - 1) != '\n') {
            tabBuffer.insert(0, this.text.charAt(i - 1));
            --i;
        }
        String tab = tabBuffer.toString();
        Image patternImage = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Pattern.gif");
        if (i > 0 && this.text.charAt(i - 1) == '\n') {
            String replacementString;
            String replacementString2;
            String replacementStringAfter;
            String replacementStringBefore;
            if (this.content.getCSTParent(this.cstNode, ModuleElement.class) == null && this.text.substring(0, i).indexOf("[template") == -1 && this.text.substring(0, i).indexOf("[query") == -1 && this.text.substring(0, i).indexOf("[macro") == -1 && ("import".startsWith(start.toLowerCase()) || "[import".startsWith(start.toLowerCase()))) {
                replacementStringBefore = "[import ";
                replacementStringAfter = " /]\n" + tab;
                replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
                proposals.add((ICompletionProposal)new CompletionProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[import]", null, replacementString2));
            }
            if (!(this.cstNode instanceof ModuleElement) && this.content.getCSTParent(this.cstNode, ModuleElement.class) == null) {
                this.computeModuleElementsPatternsProposals(proposals, start, tab, patternImage);
            }
            if (this.cstNode instanceof IfBlock || this.cstNode instanceof TextExpression && this.cstNode.eContainer() instanceof IfBlock) {
                if ("elseif".startsWith(start.toLowerCase()) || "[elseif".startsWith(start.toLowerCase())) {
                    replacementStringBefore = "[elseif (";
                    replacementStringAfter = ")]\n" + tab + '\t';
                    replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
                    proposals.add((ICompletionProposal)new CompletionProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[elseif]", null, replacementString2));
                }
                if ("else".startsWith(start.toLowerCase()) || "[else".startsWith(start.toLowerCase())) {
                    replacementString = "[else]\n" + tab + '\t';
                    proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), patternImage, "[else]", null, replacementString));
                }
            }
            if (this.cstNode instanceof LetBlock || this.cstNode instanceof TextExpression && this.cstNode.eContainer() instanceof LetBlock) {
                if ("elselet".startsWith(start.toLowerCase()) || "[elselet".startsWith(start.toLowerCase())) {
                    replacementStringBefore = "[elselet ";
                    replacementStringAfter = " : " + this.defaultVariableType + "]" + '\n' + tab + '\t';
                    replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
                    proposals.add((ICompletionProposal)new CompletionProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[elselet]", null, replacementString2));
                }
                if ("else".startsWith(start.toLowerCase()) || "[else".startsWith(start.toLowerCase())) {
                    replacementString = "[else]\n" + tab + '\t';
                    proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), patternImage, "[else]", null, replacementString));
                }
            }
            if (!(this.cstNode instanceof ModelExpression) && ("comment".startsWith(start.toLowerCase()) || "[comment".startsWith(start.toLowerCase()))) {
                replacementStringBefore = "[comment ";
                replacementStringAfter = " /]\n" + tab;
                replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
                proposals.add((ICompletionProposal)new CompletionProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[comment]", null, replacementString2));
            }
        }
        if (!start.startsWith("@")) {
            this.computeBlocksPatternsProposals(proposals, start, tab, patternImage);
        }
        this.computeMainTagPatternsProposals(proposals, start, tab, patternImage);
    }

    private void computeMainTagPatternsProposals(List<ICompletionProposal> proposals, String start, String tab, Image patternImage) {
        if ((this.cstNode instanceof Template || this.content.getCSTParent(this.cstNode, Template.class) != null) && !(this.cstNode instanceof ModelExpression) && ("@main".startsWith(start.toLowerCase()) || "[@main".startsWith(start.toLowerCase()))) {
            String replacementStringBefore;
            String replacementString = replacementStringBefore = "[comment @main /]\n" + tab;
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "@main", null, replacementString));
        }
    }

    private void computeModuleElementsPatternsProposals(List<ICompletionProposal> proposals, String start, String tab, Image patternImage) {
        String replacementString;
        String replacementStringAfter;
        String replacementStringBefore;
        if ("template".startsWith(start.toLowerCase()) || "[template".startsWith(start.toLowerCase())) {
            replacementStringBefore = "[template ";
            replacementStringAfter = "(e : " + this.defaultVariableType + ")]\n" + tab + '\t' + '\n' + tab + '[' + '/' + "template" + ']';
            replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[template]", null, String.valueOf(tab) + replacementString));
        }
        if ("query".startsWith(start.toLowerCase()) || "[query".startsWith(start.toLowerCase())) {
            replacementStringBefore = "[query ";
            replacementStringAfter = "(e : " + this.defaultVariableType + ") : " + this.defaultVariableType + " = /]\n";
            replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[query]", null, String.valueOf(tab) + replacementString));
        }
        if ("macro".startsWith(start.toLowerCase()) || "[macro".startsWith(start.toLowerCase())) {
            replacementStringBefore = "[macro ";
            replacementStringAfter = "(e : " + this.defaultVariableType + ") : " + this.defaultVariableType + "]\n" + tab + '\t' + '\n' + tab + '[' + '/' + "macro" + ']';
            replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[macro]", null, String.valueOf(tab) + replacementString));
        }
    }

    private void computeBlocksPatternsProposals(List<ICompletionProposal> proposals, String start, String tab, Image patternImage) {
        if (this.cstNode instanceof Template) {
            if (((Template)this.cstNode).getBody().size() == 0 || this.offset >= ((TemplateExpression)((Template)this.cstNode).getBody().get(0)).getStartPosition()) {
                this.computeBlocksPatternsProposalsSub(proposals, start, tab, patternImage);
            }
        } else if (this.cstNode instanceof Block) {
            this.computeBlocksPatternsProposalsSub(proposals, start, tab, patternImage);
        }
        if (this.content.getCSTParent(this.cstNode, ModuleElement.class) != null) {
            if (this.cstNode instanceof TextExpression) {
                int size = proposals.size();
                this.computeBlocksPatternsProposalsSub(proposals, start, tab, patternImage);
                if (proposals.size() == size) {
                    this.computeBlocksPatternsProposalsSub(proposals, "", tab, patternImage);
                }
            } else if (this.cstNode instanceof ModelExpression && start.startsWith("[") && (this.offset == this.text.length() || this.text.charAt(this.offset) != '/')) {
                this.computeBlocksPatternsProposalsSub(proposals, start, tab, patternImage);
            }
        }
    }

    private void computeBlocksPatternsProposalsSub(List<ICompletionProposal> proposals, String start, String tab, Image patternImage) {
        String replacementString;
        String replacementString2;
        String replacementStringAfter;
        String replacementStringBefore;
        if ("[".startsWith(start.toLowerCase())) {
            replacementStringBefore = "[";
            replacementStringAfter = "/]";
            replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[ ]", null, replacementString2));
        }
        if ("for".startsWith(start.toLowerCase()) || "[for".startsWith(start.toLowerCase())) {
            replacementStringBefore = "[for (";
            replacementStringAfter = " : " + this.defaultVariableType + " | )]\n" + tab + '\t' + '\n' + tab + '[' + '/' + "for" + ']';
            replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[for]", null, String.valueOf(tab) + replacementString2));
        }
        if ("if".startsWith(start.toLowerCase()) || "[if".startsWith(start.toLowerCase())) {
            replacementStringBefore = "[if (";
            replacementStringAfter = ")]\n" + tab + '\t' + '\n' + tab + '[' + '/' + "if" + ']';
            replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[if]", null, String.valueOf(tab.toString()) + replacementString2));
        }
        if ("file".startsWith(start.toLowerCase()) || "[file".startsWith(start.toLowerCase())) {
            this.computeFileBlockPatternsProposals(proposals, start, tab, patternImage, true);
            this.computeFileBlockPatternsProposals(proposals, start, tab, patternImage, false);
        }
        if ("let".startsWith(start.toLowerCase()) || "[let".startsWith(start.toLowerCase())) {
            replacementStringBefore = "[let ";
            replacementStringAfter = " : " + this.defaultVariableType + "]\n" + tab + '\t' + '\n' + tab + '[' + '/' + "let" + ']';
            replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[let]", null, String.valueOf(tab.toString()) + replacementString2));
        }
        if ("trace".startsWith(start.toLowerCase()) || "[trace".startsWith(start.toLowerCase())) {
            replacementStringBefore = "[trace ('";
            replacementStringAfter = "')]\n" + tab + '\t' + '\n' + tab + '[' + '/' + "trace" + ']';
            replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[trace]", null, String.valueOf(tab) + replacementString2));
        }
        if ("protected".startsWith(start.toLowerCase()) || "[protected".startsWith(start.toLowerCase())) {
            replacementStringBefore = "[protected ('";
            replacementStringAfter = "')]\n" + tab + '\t' + '\n' + tab + '[' + '/' + "protected" + ']';
            replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[protected]", null, String.valueOf(tab) + replacementString2));
        }
        if ("super".startsWith(start.toLowerCase()) || "[super".startsWith(start.toLowerCase())) {
            replacementStringBefore = "[super";
            replacementStringAfter = "/]";
            replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[super]", null, replacementString2));
        }
        if ("[".startsWith(start.toLowerCase())) {
            replacementString = "[ '[' /] ";
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), patternImage, "'['", null, replacementString));
        }
        if ("".equals(start.toLowerCase())) {
            replacementString = "[ ']' /] ";
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), patternImage, "']'", null, replacementString));
        }
    }

    private void computeFileBlockPatternsProposals(List<ICompletionProposal> proposals, String start, String tab, Image patternImage, boolean withMainTag) {
        String mainTagText = withMainTag ? "[comment @main /]\n" + tab : "";
        String replacementStringBefore = String.valueOf(mainTagText) + '[' + "file" + ' ' + "('file://";
        ModuleElement cstModuleElement = (ModuleElement)this.content.getCSTParent(this.cstNode, ModuleElement.class);
        String currentModuleElementName = cstModuleElement != null ? cstModuleElement.getName() : "";
        String replacementStringAfter = "', false, '" + currentModuleElementName.toUpperCase() + "-ID')]\n" + tab + '\t' + '\n' + tab + '[' + '/' + "file" + ']';
        String replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
        String displayString = "[file]";
        if (withMainTag) {
            displayString = String.valueOf(displayString) + " - @main";
        }
        proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, displayString, null, String.valueOf(tab.toString()) + replacementString));
    }

    private void computeKeywordsProposals(List<ICompletionProposal> proposals) {
        if (this.cstNode != null) {
            int i = this.offset;
            while (i > 0 && Character.isLetterOrDigit(this.text.charAt(i - 1))) {
                --i;
            }
            String start = this.text.substring(i, this.offset);
            int bHeader = this.cstNode.getStartPosition();
            String bHeaderText = bHeader > -1 && bHeader < i ? this.text.substring(bHeader, i).trim() : "";
            Image keywordImage = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Keyword.gif");
            if (this.cstNode instanceof Module && this.isHeaderAfterParenthesis(bHeaderText) && ((Module)this.cstNode).getExtends().size() == 0) {
                this.computeKeywordProposal(proposals, start, "extends ", "", keywordImage);
            }
            if (this.cstNode instanceof ModelExpression && this.cstNode.eContainingFeature() == CstPackage.eINSTANCE.getBlock_Body()) {
                this.computeKeywordsProposalsInTemplateInvocationHeader(proposals, start, bHeaderText, keywordImage);
            }
            if (this.cstNode instanceof Template) {
                this.computeKeywordsProposalsInTemplateHeader(proposals, start, bHeaderText, keywordImage);
            }
            if (this.cstNode instanceof org.eclipse.acceleo.parser.cst.Macro) {
                this.computeKeywordsProposalsInMacroHeader(proposals, start, bHeaderText, keywordImage);
            }
            if (this.cstNode instanceof ForBlock) {
                this.computeKeywordsProposalsInForBlockHeader(proposals, start, bHeaderText, keywordImage);
            }
        }
    }

    private void computeKeywordsProposalsInTemplateHeader(List<ICompletionProposal> proposals, String start, String bHeaderText, Image keywordImage) {
        if (bHeaderText.equals("template")) {
            this.computeKeywordProposal(proposals, start, "public ", "", keywordImage);
            this.computeKeywordProposal(proposals, start, "protected ", "", keywordImage);
            this.computeKeywordProposal(proposals, start, "private ", "", keywordImage);
        }
        if (this.isHeaderAfterParenthesis(bHeaderText)) {
            StringBuffer bHeaderBuffer = new StringBuffer(bHeaderText);
            Sequence pGuard = new Sequence("?", "(");
            Sequence pInit = new Sequence("{");
            if (((Template)this.cstNode).getOverrides().size() == 0 && pGuard.search(bHeaderBuffer).b() == -1 && pInit.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "overrides ", "", keywordImage);
            }
            if (((Template)this.cstNode).getGuard() == null && pInit.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "? (", ")", keywordImage);
            }
            if (((Template)this.cstNode).getInit() == null && "{".startsWith(start.toLowerCase())) {
                String replacementStringBefore = "{ ";
                String replacementStringAfter = ": " + this.defaultVariableType + "; }";
                String replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
                proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), keywordImage, "{ }", null, replacementString));
            }
        }
    }

    private void computeKeywordsProposalsInMacroHeader(List<ICompletionProposal> proposals, String start, String bHeaderText, Image keywordImage) {
        if (bHeaderText.equals("macro")) {
            this.computeKeywordProposal(proposals, start, "public ", "", keywordImage);
            this.computeKeywordProposal(proposals, start, "protected ", "", keywordImage);
            this.computeKeywordProposal(proposals, start, "private ", "", keywordImage);
        }
    }

    private void computeKeywordsProposalsInTemplateInvocationHeader(List<ICompletionProposal> proposals, String start, String bHeaderText, Image keywordImage) {
        if (this.isHeaderAfterParenthesis(bHeaderText) || bHeaderText.indexOf("super") > -1) {
            StringBuffer bHeaderBuffer = new StringBuffer(bHeaderText);
            Sequence pSeparator = new Sequence("separator", "(");
            Sequence pAfter = new Sequence("after", "(");
            Sequence pGuard = new Sequence("?", "(");
            if (((ModelExpression)this.cstNode).getBefore() == null && pSeparator.search(bHeaderBuffer).b() == -1 && pAfter.search(bHeaderBuffer).b() == -1 && pGuard.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "before (", ")", keywordImage);
            }
            if (((ModelExpression)this.cstNode).getEach() == null && pAfter.search(bHeaderBuffer).b() == -1 && pGuard.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "separator (", ")", keywordImage);
            }
            if (((ModelExpression)this.cstNode).getAfter() == null && pGuard.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "after (", ")", keywordImage);
            }
        }
    }

    private void computeKeywordsProposalsInForBlockHeader(List<ICompletionProposal> proposals, String start, String bHeaderText, Image keywordImage) {
        if (this.isHeaderAfterParenthesis(bHeaderText)) {
            StringBuffer bHeaderBuffer = new StringBuffer(bHeaderText);
            Sequence pSeparator = new Sequence("separator", "(");
            Sequence pAfter = new Sequence("after", "(");
            Sequence pGuard = new Sequence("?", "(");
            Sequence pInit = new Sequence("{");
            if (((ForBlock)this.cstNode).getBefore() == null && pSeparator.search(bHeaderBuffer).b() == -1 && pAfter.search(bHeaderBuffer).b() == -1 && pGuard.search(bHeaderBuffer).b() == -1 && pInit.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "before (", ")", keywordImage);
            }
            if (((ForBlock)this.cstNode).getEach() == null && pAfter.search(bHeaderBuffer).b() == -1 && pGuard.search(bHeaderBuffer).b() == -1 && pInit.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "separator (", ")", keywordImage);
            }
            if (((ForBlock)this.cstNode).getAfter() == null && pGuard.search(bHeaderBuffer).b() == -1 && pInit.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "after (", ")", keywordImage);
            }
            if (((ForBlock)this.cstNode).getGuard() == null && pInit.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "? (", ")", keywordImage);
            }
            if (((ForBlock)this.cstNode).getInit() == null && "{".startsWith(start)) {
                String replacementStringBefore = "{ ";
                String replacementStringAfter = ": " + this.defaultVariableType + "; }";
                String replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
                proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), keywordImage, "{ }", null, replacementString));
            }
        }
    }

    private boolean isHeaderAfterParenthesis(String aText) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(aText);
        buffer.append("___TAG___");
        Sequence literalEscape = new Sequence("\\'");
        SequenceBlock pLiteral = new SequenceBlock(new Sequence("'"), new Sequence("'"), literalEscape, false, null);
        SequenceBlock pParenthesis = new SequenceBlock(new Sequence("("), new Sequence(")"), null, true, new SequenceBlock[]{pLiteral});
        Sequence pHeaderEnd = new Sequence("]");
        Sequence pTag = new Sequence("___TAG___");
        return pHeaderEnd.search(buffer, 0, buffer.length(), null, new SequenceBlock[]{pLiteral}).b() == -1 && pParenthesis.search(buffer, 0, buffer.length()).b() > -1 && pTag.search(buffer, 0, buffer.length(), null, new SequenceBlock[]{pLiteral, pParenthesis}).b() > -1;
    }

    private void computeKeywordProposal(List<ICompletionProposal> proposals, String start, String replacementStringBefore, String replacementStringAfter, Image keywordImage) {
        String replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
        if (replacementString.toLowerCase().startsWith(start.toLowerCase())) {
            proposals.add((ICompletionProposal)new CompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), keywordImage, replacementString, null, replacementString));
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return AUTO_ACTIVATION_CHARACTERS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

