/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.launching;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.launching.AcceleoJavaArgumentsTab;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaMainTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoMainTab
extends JavaMainTab {
    AcceleoJavaArgumentsTab javaArgumentsTab;
    private Text modelText;
    private Button modelButton;
    private Text targetText;
    private Button targetButton;
    private Text argumentsText;
    private Combo launchingStrategyCombo;
    private List<String> launchingStrategies;
    private Shell mainTypeShell;

    public AcceleoMainTab(AcceleoJavaArgumentsTab javaArgumentsTab) {
        this.javaArgumentsTab = javaArgumentsTab;
    }

    public void dispose() {
        super.dispose();
        if (this.mainTypeShell != null && !this.mainTypeShell.isDisposed()) {
            this.mainTypeShell.dispose();
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite mainComposite = (Composite)this.getControl();
        new Label(mainComposite, 0);
        Composite compAcceleo = this.createComposite(mainComposite, parent.getFont(), 2, 2, 1808, 0, 0);
        Composite compModelTarget = this.createComposite(compAcceleo, parent.getFont(), 1, 1, 1808, 0, 0);
        this.createAcceleoModelEditor(compModelTarget);
        this.createAcceleoTargetEditor(compModelTarget);
        this.createAcceleoArgumentsEditor(compAcceleo);
        new Label(mainComposite, 0);
        this.createAcceleoLaunchingStrategyEditor(mainComposite);
    }

    protected void createMainTypeExtensions(Composite parent) {
        if (this.mainTypeShell == null) {
            this.mainTypeShell = new Shell();
        }
        Composite notVisibleComposite = new Composite((Composite)this.mainTypeShell, 0);
        super.createMainTypeExtensions(notVisibleComposite);
        notVisibleComposite.setVisible(false);
    }

    protected void createAcceleoModelEditor(Composite parent) {
        Font font = parent.getFont();
        Group mainGroup = this.createGroup(parent, AcceleoUIMessages.getString("AcceleoMainTab.ModelPath"), 2, 1, 768);
        Composite comp = this.createComposite((Composite)mainGroup, font, 2, 2, 1808, 0, 0);
        this.modelText = this.createSingleText(comp, 1);
        this.modelText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.modelButton = this.createPushButton(comp, AcceleoUIMessages.getString("AcceleoMainTab.Browse"), null);
        this.modelButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AcceleoMainTab.this.handleBrowseModelButton();
            }
        });
    }

    private void handleBrowseModelButton() {
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dialog.setTitle(AcceleoUIMessages.getString("AcceleoMainTab.SelectModel"));
        String path = this.modelText.getText();
        if (path != null && path.length() > 0 && new Path(path).lastSegment().length() > 0) {
            dialog.setInitialPattern(new Path(path).lastSegment());
        } else {
            String projectName;
            try {
                projectName = this.getCurrentLaunchConfiguration().getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            }
            catch (CoreException e) {
                projectName = "";
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
            String initial = projectName.toLowerCase().contains(".uml") ? "*.uml" : (projectName.toLowerCase().contains(".ecore") ? "*.ecore" : "*.xmi");
            dialog.setInitialPattern(initial);
        }
        dialog.open();
        if (dialog.getResult() != null && dialog.getResult().length > 0 && dialog.getResult()[0] instanceof IFile) {
            this.modelText.setText(((IFile)dialog.getResult()[0]).getFullPath().toString());
        }
    }

    protected void createAcceleoTargetEditor(Composite parent) {
        Font font = parent.getFont();
        Group mainGroup = this.createGroup(parent, AcceleoUIMessages.getString("AcceleoMainTab.TargetPath"), 2, 1, 768);
        Composite comp = this.createComposite((Composite)mainGroup, font, 2, 2, 1808, 0, 0);
        this.targetText = this.createSingleText(comp, 1);
        this.targetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.targetButton = this.createPushButton(comp, AcceleoUIMessages.getString("AcceleoMainTab.Browse"), null);
        this.targetButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AcceleoMainTab.this.handleBrowseTargetButton();
            }
        });
    }

    private void handleBrowseTargetButton() {
        Object[] result;
        IResource initial;
        if (this.targetText.getText() != null && this.targetText.getText().length() > 0) {
            initial = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.targetText.getText()));
            if (initial instanceof IFile) {
                initial = initial.getParent();
            }
        } else {
            initial = null;
        }
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.ContainerSelection"));
        if (initial != null) {
            dialog.setInitialSelections(new Object[]{initial});
        }
        dialog.showClosedProjects(false);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.targetText.setText(((Path)result[0]).toString());
        }
    }

    protected void createAcceleoArgumentsEditor(Composite parent) {
        Font font = parent.getFont();
        Group mainGroup = this.createGroup(parent, AcceleoUIMessages.getString("AcceleoMainTab.Arguments"), 2, 1, 2);
        Composite comp = this.createComposite((Composite)mainGroup, font, 2, 2, 1808, 0, 0);
        this.argumentsText = new Text(comp, 2626);
        GridData gd = new GridData(1808);
        gd.heightHint = 70;
        gd.widthHint = 100;
        gd.horizontalSpan = 2;
        this.argumentsText.setLayoutData((Object)gd);
        this.argumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createAcceleoLaunchingStrategyEditor(Composite parent) {
        Font font = parent.getFont();
        Composite comp = this.createComposite(parent, font, 2, 2, 8, 0, 0);
        Label label = new Label(comp, 0);
        label.setText(AcceleoUIMessages.getString("AcceleoMainTab.LaunchingStrategy"));
        this.launchingStrategyCombo = new Combo(comp, 8);
        GridData gridData = new GridData(128);
        gridData.horizontalSpan = 1;
        this.launchingStrategyCombo.setLayoutData((Object)gridData);
        this.launchingStrategyCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AcceleoMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.updateStrategies();
        if (this.launchingStrategyCombo.getItemCount() > 0) {
            this.launchingStrategyCombo.select(0);
        }
    }

    private void updateStrategies() {
        if (this.launchingStrategyCombo != null) {
            ArrayList<String> descriptions = new ArrayList<String>();
            Iterator<String> strategies = this.getLaunchingStrategies().iterator();
            while (strategies.hasNext()) {
                descriptions.add(strategies.next());
            }
            this.launchingStrategyCombo.setItems(descriptions.toArray(new String[descriptions.size()]));
            if (descriptions.size() < 15) {
                this.launchingStrategyCombo.setVisibleItemCount(descriptions.size());
            } else {
                this.launchingStrategyCombo.setVisibleItemCount(15);
            }
        }
    }

    private Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        g.setLayout((Layout)layout);
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private Text createSingleText(Composite parent, int hspan) {
        Text t = new Text(parent, 2052);
        t.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        t.setLayoutData((Object)gd);
        return t;
    }

    public String getName() {
        return "Acceleo";
    }

    public String getId() {
        return "org.eclipse.acceleo.ide.ui.launching.acceleoMainTab";
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateAcceleoModelFromConfig(config);
        this.updateAcceleoTargetFromConfig(config);
        this.updateAcceleoArgumentsFromConfig(config);
        this.updateAcceleoLaunchingStrategyFromConfig(config);
    }

    protected void updateAcceleoModelFromConfig(ILaunchConfiguration config) {
        String model = "";
        try {
            model = config.getAttribute("org.eclipse.acceleo.ide.ui.MODEL_PATH", "");
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        this.modelText.setText(model);
    }

    protected void updateAcceleoTargetFromConfig(ILaunchConfiguration config) {
        String target = "";
        try {
            target = config.getAttribute("org.eclipse.acceleo.ide.ui.TARGET_PATH", "");
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        this.targetText.setText(target);
    }

    protected void updateAcceleoArgumentsFromConfig(ILaunchConfiguration config) {
        String args = "";
        try {
            args = config.getAttribute("org.eclipse.acceleo.ide.ui.ARGUMENTS", "");
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        this.argumentsText.setText(args);
    }

    protected void updateAcceleoLaunchingStrategyFromConfig(ILaunchConfiguration config) {
        String id = "";
        try {
            id = config.getAttribute("org.eclipse.acceleo.ide.ui.LAUNCHING_STRATEGY_DESCRIPTION", "");
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        int item = this.getLaunchingStrategies().indexOf(id);
        if (item == -1) {
            item = 0;
        }
        if (this.launchingStrategyCombo.getItemCount() > item) {
            this.launchingStrategyCombo.select(item);
        } else if (this.launchingStrategyCombo.getItemCount() > 0) {
            this.launchingStrategyCombo.select(0);
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        String target;
        IStatus status;
        boolean result = super.isValid(config);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (result) {
            String model = this.modelText.getText().trim();
            status = workspace.validatePath(model, 1);
            if (status.isOK()) {
                IFile file = workspace.getRoot().getFile((IPath)new Path(model));
                if (!file.exists()) {
                    this.setErrorMessage(AcceleoUIMessages.getString("AcceleoMainTab.Error.MissingModel", model));
                    result = false;
                }
            } else {
                this.setErrorMessage(AcceleoUIMessages.getString("AcceleoMainTab.Error.InvalidModel", model));
                result = false;
            }
        }
        if (result && !(status = workspace.validatePath(target = this.targetText.getText().trim(), 6)).isOK()) {
            this.setErrorMessage(AcceleoUIMessages.getString("AcceleoMainTab.Error.InvalidTarget", target));
            result = false;
        }
        return result;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.javaArgumentsTab != null) {
            this.javaArgumentsTab.updateArguments(config, this.modelText.getText().trim(), this.targetText.getText().trim(), this.argumentsText.getText());
        }
        super.performApply(config);
        config.setAttribute("org.eclipse.acceleo.ide.ui.MODEL_PATH", this.modelText.getText().trim());
        config.setAttribute("org.eclipse.acceleo.ide.ui.TARGET_PATH", this.targetText.getText().trim());
        config.setAttribute("org.eclipse.acceleo.ide.ui.ARGUMENTS", this.argumentsText.getText());
        config.setAttribute("org.eclipse.acceleo.ide.ui.LAUNCHING_STRATEGY_DESCRIPTION", this.launchingStrategyCombo.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        config.setAttribute("org.eclipse.acceleo.ide.ui.MODEL_PATH", "");
        config.setAttribute("org.eclipse.acceleo.ide.ui.TARGET_PATH", "");
        config.setAttribute("org.eclipse.acceleo.ide.ui.ARGUMENTS", "");
        config.setAttribute("org.eclipse.acceleo.ide.ui.LAUNCHING_STRATEGY_DESCRIPTION", "");
    }

    public Image getImage() {
        return AcceleoUIActivator.getDefault().getImage("icons/template-editor/Template_main.gif");
    }

    private List<String> getLaunchingStrategies() {
        if (this.launchingStrategies == null) {
            this.launchingStrategies = new ArrayList<String>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.acceleo.ide.ui.launching");
            if (extensionPoint != null && extensionPoint.getExtensions().length > 0) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    IConfigurationElement[] members = extension.getConfigurationElements();
                    int j = 0;
                    while (j < members.length) {
                        IConfigurationElement member = members[j];
                        String description = member.getAttribute("description");
                        if (description != null && description.length() > 0) {
                            this.launchingStrategies.add(description);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return this.launchingStrategies;
    }
}

