/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoOutlinePageItemProviderAdapterFactory;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.Comment;
import org.eclipse.acceleo.parser.cst.Macro;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.Module;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.acceleo.parser.cst.Query;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.TemplateOverridesValue;
import org.eclipse.acceleo.parser.cst.TextExpression;
import org.eclipse.acceleo.parser.cst.TypedModel;
import org.eclipse.acceleo.parser.cst.Variable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoOutlinePageItemProvider
extends ReflectiveItemProvider {
    public AcceleoOutlinePageItemProvider(AcceleoOutlinePageItemProviderAdapterFactory adapterFactory) {
        super((AdapterFactory)adapterFactory);
    }

    public Object getImage(Object object) {
        EObject eObject = (EObject)object;
        if (eObject instanceof Template) {
            boolean isMain = false;
            TreeIterator iChildren = eObject.eAllContents();
            while (!isMain && iChildren.hasNext()) {
                EObject iChild = (EObject)iChildren.next();
                if (!(iChild instanceof Comment) || ((Comment)iChild).getBody() == null || ((Comment)iChild).getBody().indexOf("@main") <= -1) continue;
                isMain = true;
            }
            if (isMain) {
                return AcceleoUIActivator.getDefault().getImage("icons/template-editor/Template_main.gif");
            }
        }
        return AcceleoUIActivator.getDefault().getImage("icons/template-editor/" + eObject.eClass().getName() + ".gif");
    }

    public String getText(Object object) {
        StringBuffer text = new StringBuffer();
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EClass eClass = eObject.eClass();
            switch (eClass.getClassifierID()) {
                case 1: {
                    Module eModule = (Module)eObject;
                    text.append(eModule.getName());
                    break;
                }
                case 2: {
                    ModuleExtendsValue eModuleExtendsValue = (ModuleExtendsValue)eObject;
                    text.append("extends ");
                    text.append(eModuleExtendsValue.getName());
                    break;
                }
                case 3: {
                    ModuleImportsValue eModuleImportsValue = (ModuleImportsValue)eObject;
                    text.append("import ");
                    text.append(eModuleImportsValue.getName());
                    break;
                }
                case 4: {
                    TypedModel eTypedModel = (TypedModel)eObject;
                    text.append(this.getTextForTypedModel(eTypedModel));
                    break;
                }
                case 6: {
                    text.append("[comment/]");
                    break;
                }
                case 7: {
                    Template eTemplate = (Template)eObject;
                    text.append(this.getTextForTemplate(eTemplate));
                    break;
                }
                case 8: {
                    TemplateOverridesValue eTemplateOverridesValue = (TemplateOverridesValue)eObject;
                    text.append("overrides ");
                    text.append(eTemplateOverridesValue.getName());
                    break;
                }
                case 9: {
                    Variable eVariable = (Variable)eObject;
                    text.append(this.getTextForVariable(eVariable));
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    ModelExpression eModelExpression = (ModelExpression)eObject;
                    if (eModelExpression.getBody() == null) break;
                    text.append(eModelExpression.getBody());
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    text.append("{}");
                    break;
                }
                case 15: {
                    text.append("[protected/]");
                    break;
                }
                case 16: {
                    text.append("[for/]");
                    break;
                }
                case 17: {
                    text.append("[if/]");
                    break;
                }
                case 18: {
                    text.append("[let/]");
                    break;
                }
                case 19: {
                    text.append("[file/]");
                    break;
                }
                case 20: {
                    text.append("[trace/]");
                    break;
                }
                case 21: {
                    Macro eMacro = (Macro)eObject;
                    text.append("macro " + eMacro.getName());
                    break;
                }
                case 22: {
                    Query eQuery = (Query)eObject;
                    text.append("query " + eQuery.getName());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(AcceleoUIMessages.getString("AcceleoOutlinePageItemProvider.InvalidClassifier", eClass.getName()));
                }
            }
        }
        return text.toString().trim();
    }

    private StringBuffer getTextForTypedModel(TypedModel eTypedModel) {
        StringBuffer text = new StringBuffer();
        text.append("model ");
        Iterator ePackages = eTypedModel.getTakesTypesFrom().iterator();
        while (ePackages.hasNext()) {
            text.append(((EPackage)ePackages.next()).getName());
            if (!ePackages.hasNext()) continue;
            text.append(", ");
        }
        return text;
    }

    private StringBuffer getTextForTemplate(Template eTemplate) {
        StringBuffer text = new StringBuffer();
        text.append("template ");
        text.append(eTemplate.getName());
        text.append("(");
        Iterator eParameters = eTemplate.getParameter().iterator();
        while (eParameters.hasNext()) {
            Variable eVariable = (Variable)eParameters.next();
            if (eVariable.getType() != null) {
                text.append(eVariable.getType());
            }
            if (!eParameters.hasNext()) continue;
            text.append(", ");
        }
        text.append(")");
        return text;
    }

    private StringBuffer getTextForVariable(Variable eVariable) {
        StringBuffer text = new StringBuffer();
        text.append(eVariable.getName());
        text.append(":");
        if (eVariable.getType() != null) {
            text.append(eVariable.getType());
        }
        return text;
    }

    public Collection<?> getChildren(Object object) {
        Collection children = super.getChildren(object);
        TreeSet<CSTNode> orderedCollection = new TreeSet<CSTNode>(new Comparator<CSTNode>(){

            @Override
            public int compare(CSTNode n0, CSTNode n1) {
                if (n0.getStartPosition() < n1.getStartPosition()) {
                    return -1;
                }
                return 1;
            }
        });
        for (Object next : children) {
            if (next instanceof TextExpression) continue;
            orderedCollection.add((CSTNode)next);
        }
        return orderedCollection;
    }
}

