/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.utils;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoStandardLibrary {
    public static final String OPERATION_INTEGER_TOSTRING = "toString";
    public static final String OPERATION_REAL_TOSTRING = "toString";
    public static final String OPERATION_STRING_FIRST = "first";
    public static final String OPERATION_STRING_INDEX = "index";
    public static final String OPERATION_STRING_ISALPHA = "isAlpha";
    public static final String OPERATION_STRING_ISALPHANUM = "isAlphanum";
    public static final String OPERATION_STRING_LAST = "last";
    public static final String OPERATION_STRING_STRCMP = "strcmp";
    public static final String OPERATION_STRING_STRSTR = "strstr";
    public static final String OPERATION_STRING_STRTOK = "strtok";
    public static final String OPERATION_STRING_SUBSTITUTE = "substitute";
    public static final String OPERATION_STRING_TOLOWERFIRST = "toLowerFirst";
    public static final String OPERATION_STRING_TOUPPERFIRST = "toUpperFirst";
    public static final String PRIMITIVE_INTEGER_NAME = "Integer";
    public static final String PRIMITIVE_REAL_NAME = "Real";
    public static final String PRIMITIVE_STRING_NAME = "String";
    private static EClass integerType;
    private static final String NS_URI = "http://www.eclipse.org/acceleo/mtl/0.8.0/mtlstdlib.ecore";
    private static EClass realType;
    private static EPackage stdLibPackage;
    private static EClass stringType;

    public AcceleoStandardLibrary() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            stdLibPackage = (EPackage)ModelUtils.load(URI.createURI((String)NS_URI), (ResourceSet)resourceSet);
            stringType = (EClass)stdLibPackage.getEClassifier(PRIMITIVE_STRING_NAME);
            integerType = (EClass)stdLibPackage.getEClassifier(PRIMITIVE_INTEGER_NAME);
            realType = (EClass)stdLibPackage.getEClassifier(PRIMITIVE_REAL_NAME);
        }
        catch (IOException iOException) {
            AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("AcceleoStandardLibrary.LoadFailure"), false);
        }
    }

    public EList<EOperation> getExistingOperations(EClassifier type) {
        return this.getExistingOperations(type.getName());
    }

    public EList<EOperation> getExistingOperations(String classifierName) {
        BasicEList result = new BasicEList();
        if (PRIMITIVE_STRING_NAME.equals(classifierName)) {
            result.addAll((Collection)stringType.getEOperations());
        } else if (PRIMITIVE_INTEGER_NAME.equals(classifierName)) {
            result.addAll((Collection)integerType.getEOperations());
        } else if (PRIMITIVE_REAL_NAME.equals(classifierName)) {
            result.addAll((Collection)realType.getEOperations());
        }
        return result;
    }
}

