/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.drivers.emf4atl;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModelElement;
import org.eclipse.m2m.atl.drivers.emf4atl.EMFModelLoader;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;

public class ASMEMFModel
extends ASMModel {
    protected static ASMEMFModel mofmm;
    private static int instanceCount;
    protected Resource extent;
    protected Set referencedExtents = new HashSet();
    protected String resolveURI;
    protected Map modelElements = new HashMap();
    private boolean checkSameModel = true;
    private Map classifiers;

    static {
        ASMEMFModel.init();
    }

    protected ASMEMFModel(String name, Resource extent, ASMEMFModel metamodel, boolean isTarget, ModelLoader ml) {
        super(name, (ASMModel)metamodel, isTarget, ml);
        this.extent = extent;
        if (extent != null) {
            this.addAllReferencedExtents(extent);
        }
        ATLLogger.fine((String)((Object)((Object)this) + " created (" + ++instanceCount + ")"));
    }

    public static ASMModel getMOF() {
        if (mofmm == null) {
            mofmm = new ASMEMFModel("MOF", EcorePackage.eINSTANCE.eResource(), null, false, null);
        }
        return mofmm;
    }

    public synchronized ASMModelElement getASMModelElement(EObject object) {
        ASMModelElement ret = (ASMModelElement)this.modelElements.get(object);
        if (ret == null) {
            ret = new ASMEMFModelElement(this.modelElements, this, object);
        }
        return ret;
    }

    private synchronized ASMModelElement getClassifier(String name) {
        if (this.classifiers == null) {
            this.classifiers = this.initClassifiersInAllExtents();
        }
        EObject eo = (EObject)this.classifiers.get(name);
        ASMModelElement ret = null;
        if (eo != null) {
            ret = this.getASMModelElement(eo);
        }
        return ret;
    }

    private Map initClassifiersInAllExtents() {
        HashMap allClassifiers = new HashMap();
        this.initClassifiers(this.getExtent().getContents().iterator(), allClassifiers, null);
        Iterator refExtents = this.referencedExtents.iterator();
        while (refExtents.hasNext()) {
            this.initClassifiers(((Resource)refExtents.next()).getContents().iterator(), allClassifiers, null);
        }
        return allClassifiers;
    }

    private void initClassifiers(Iterator i, Map allClassifiers, String base) {
        while (i.hasNext()) {
            String name;
            EObject eo = (EObject)i.next();
            if (eo instanceof EPackage) {
                name = ((EPackage)eo).getName();
                if (base != null) {
                    name = String.valueOf(base) + "::" + name;
                }
                this.initClassifiers(((EPackage)eo).eContents().iterator(), allClassifiers, name);
                continue;
            }
            if (eo instanceof EClassifier) {
                name = ((EClassifier)eo).getName();
                this.register(allClassifiers, name, eo);
                if (base == null) continue;
                name = String.valueOf(base) + "::" + name;
                this.register(allClassifiers, name, eo);
                continue;
            }
            this.initClassifiers(eo.eContents().iterator(), allClassifiers, base);
        }
    }

    private void register(Map allClassifiers, String name, EObject classifier) {
        if (allClassifiers.containsKey(name)) {
            ATLLogger.warning((String)("metamodel contains several classifiers with same name: " + name));
        }
        allClassifiers.put(name, classifier);
    }

    public ASMModelElement findModelElement(String name) {
        ASMModelElement ret = null;
        ret = this.getClassifier(name);
        return ret;
    }

    public Set getElementsByType(ASMModelElement type) {
        LinkedHashSet ret = new LinkedHashSet();
        EClass t = (EClass)((ASMEMFModelElement)type).getObject();
        this.addElementsOfType(ret, (EClassifier)t, this.getExtent());
        return ret;
    }

    public Set getAllElementsByType(String typeName) {
        return this.getAllElementsByType(this.getMetamodel().findModelElement(typeName));
    }

    public Set getAllElementsByType(ASMModelElement type) {
        LinkedHashSet ret = new LinkedHashSet();
        EClass t = (EClass)((ASMEMFModelElement)type).getObject();
        this.addElementsOfType(ret, (EClassifier)t, this.getExtent());
        for (Resource res : this.getReferencedExtents()) {
            this.addElementsOfType(ret, (EClassifier)t, res);
        }
        return ret;
    }

    private void addElementsOfType(Set elements, EClassifier type, Resource res) {
        TreeIterator i = res.getAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!type.isInstance((Object)eo)) continue;
            elements.add(this.getASMModelElement(eo));
        }
    }

    public ASMModelElement newModelElement(ASMModelElement type) {
        ASMModelElement ret = null;
        EClass t = (EClass)((ASMEMFModelElement)type).getObject();
        EObject eo = t.getEPackage().getEFactoryInstance().create(t);
        ret = this.getASMModelElement(eo);
        this.getExtent().getContents().add((Object)eo);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getExtent() {
        if (this.extent == null && this.resolveURI != null) {
            EMFModelLoader ml = (EMFModelLoader)this.getModelLoader();
            ResourceSet resourceSet = ml.getResourceSet();
            boolean adapt = false;
            ResourceSet resourceSet2 = resourceSet;
            synchronized (resourceSet2) {
                if (this.extent == null) {
                    EPackage pack = resourceSet.getPackageRegistry().getEPackage(this.resolveURI);
                    Resource r = pack.eResource();
                    this.addAllReferencedExtents(r);
                    adapt = true;
                    this.extent = r;
                }
            }
            if (adapt) {
                try {
                    ml.adaptMetamodel(this, (ASMEMFModel)this.getMetamodel());
                }
                catch (IOException e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return this.extent;
    }

    private static void init() {
        Map etfm = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        if (!etfm.containsKey("*")) {
            etfm.put("*", new XMIResourceFactoryImpl());
        }
    }

    public int hashCode() {
        return this.extent.hashCode();
    }

    public boolean isCheckSameModel() {
        return this.checkSameModel;
    }

    public void setCheckSameModel(boolean checkSameModel) {
        this.checkSameModel = checkSameModel;
    }

    private void addAllReferencedExtents(Resource resourceExtent) {
        TreeIterator contents = resourceExtent.getAllContents();
        while (contents.hasNext()) {
            Object o = contents.next();
            if (!(o instanceof EClass)) continue;
            this.addReferencedExtentsFor((EClass)o, new HashSet());
        }
        this.referencedExtents.remove(resourceExtent);
    }

    private void addReferencedExtentsFor(EClass eClass, Set ignore) {
        if (ignore.contains(eClass)) {
            return;
        }
        ignore.add(eClass);
        for (EReference eRef : eClass.getEReferences()) {
            if (!eRef.isContainment()) continue;
            EClassifier eType = eRef.getEType();
            if (eType.eResource() != null) {
                this.referencedExtents.add(eType.eResource());
            } else {
                ATLLogger.warning((String)("Resource for " + eType.toString() + " is null; cannot be referenced"));
            }
            if (!(eType instanceof EClass)) continue;
            this.addReferencedExtentsFor((EClass)eType, ignore);
        }
        for (EAttribute eAtt : eClass.getEAttributes()) {
            EClassifier eType = eAtt.getEType();
            if (eType == null) continue;
            if (eType.eResource() != null) {
                this.referencedExtents.add(eType.eResource());
                continue;
            }
            ATLLogger.warning((String)("Resource for " + eType.toString() + " is null; cannot be referenced"));
        }
        for (EClass eSuper : eClass.getESuperTypes()) {
            if (eSuper.eResource() != null) {
                this.referencedExtents.add(eSuper.eResource());
                this.addReferencedExtentsFor(eSuper, ignore);
                continue;
            }
            ATLLogger.warning((String)("Resource for " + eSuper.toString() + " is null; cannot be referenced"));
        }
    }

    public Set getReferencedExtents() {
        return this.referencedExtents;
    }

    protected void finalize() throws Throwable {
        ATLLogger.fine((String)((Object)((Object)this) + " is being collected (" + --instanceCount + ")"));
        ModelLoader ml = this.getModelLoader();
        if (ml != null) {
            ml.unload((ASMModel)this);
        }
        super.finalize();
    }
}

