/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.codeassist;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.editor.EditorImages;
import org.eclipse.gmf.internal.xpand.expression.TypeNameUtil;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalFactory;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

public class ProposalFactoryImpl
implements ProposalFactory {
    protected final int offset;

    public ProposalFactoryImpl(int offset) {
        this.offset = offset;
    }

    public ICompletionProposal createCollectionSpecificOperationProposal(String insertString, String displayString, String prefix, int cursor, int marked) {
        return new CompletionProposal(insertString, this.offset - prefix.length(), prefix.length(), cursor, this.getOperationImage(), displayString, null, null);
    }

    public ICompletionProposal createPropertyProposal(EStructuralFeature p, String prefix, boolean onCollection) {
        String returnType = this.computeReturnType(p.getEType(), onCollection);
        String displayStr = String.valueOf(p.getName()) + " " + returnType + " - " + p.getEContainingClass().getName();
        String insertStr = p.getName();
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), insertStr.length(), this.getPropertyImage(), displayStr, null, null);
    }

    private String computeReturnType(EClassifier returnType, boolean onCollection) {
        if (returnType == null) {
            return BuiltinMetaModel.VOID.getName();
        }
        if (onCollection) {
            if (BuiltinMetaModel.isParameterizedType((EClassifier)returnType)) {
                returnType = BuiltinMetaModel.getInnerType((EClassifier)returnType);
            }
            return "List[" + TypeNameUtil.getLastSegment((String)returnType.getName()) + "]";
        }
        return TypeNameUtil.getSimpleName((String)returnType.getName());
    }

    public ICompletionProposal createOperationProposal(EOperation p, String prefix, boolean onCollection) {
        StringBuilder displayStr = new StringBuilder();
        displayStr.append(p.getName());
        displayStr.append(ProposalFactoryImpl.toParamString(p));
        displayStr.append(" ");
        displayStr.append(this.computeReturnType(p.getEType(), onCollection));
        if (p.getEContainingClass() != null) {
            displayStr.append(" - ");
            displayStr.append(TypeNameUtil.getSimpleName((String)p.getEContainingClass().getName()));
        }
        String insertStr = String.valueOf(p.getName()) + "()";
        int x = insertStr.length();
        if (p.getEParameters().size() > 0) {
            --x;
        }
        Image img = this.getOperationImage();
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), x, img, displayStr.toString(), null, null);
    }

    public ICompletionProposal createExtensionProposal(Extension p, String prefix) {
        String displayStr = String.valueOf(p.getName()) + ProposalFactoryImpl.toParamString(p, false) + " - " + p.getFileName();
        String insertStr = String.valueOf(p.getName()) + "()";
        int x = insertStr.length();
        if (p.getFormalParameters().size() > 0) {
            --x;
        }
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), x, this.getExtensionImage(), displayStr, null, null);
    }

    public ICompletionProposal createExtensionOnMemberPositionProposal(Extension p, String prefix, boolean onOperation) {
        String displayStr = String.valueOf(p.getName()) + ProposalFactoryImpl.toParamString(p, true) + " - " + ((DeclaredParameter)p.getFormalParameters().get(0)).getType();
        String insertStr = String.valueOf(p.getName()) + "()";
        int x = insertStr.length();
        if (p.getFormalParameters().size() > 1) {
            --x;
        }
        Image img = this.getExtensionImage();
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), x, img, displayStr, null, null);
    }

    private static String toParamString(EOperation op) {
        StringBuilder b = new StringBuilder("(");
        EList params = op.getEParameters();
        int i = 0;
        int x = params.size();
        while (i < x) {
            EParameter p = (EParameter)params.get(i);
            b.append(TypeNameUtil.getSimpleName((String)p.getEType().getName()));
            if (i + 1 < x) {
                b.append(",");
            }
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    private static String toParamString(Extension p, boolean member) {
        StringBuilder b = new StringBuilder("(");
        int i = member ? 1 : 0;
        int x = p.getFormalParameters().size();
        while (i < x) {
            b.append(((DeclaredParameter)p.getFormalParameters().get(i)).toString());
            if (i + 1 < x) {
                b.append(",");
            }
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    public ICompletionProposal createVariableProposal(String name, EClassifier t, String prefix) {
        String displayStr = String.valueOf(name) + " " + this.computeReturnType(t, false);
        String insertStr = name;
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), insertStr.length(), this.getVariableImage(), displayStr, null, null);
    }

    public ICompletionProposal createTypeProposal(String insertString, EClassifier type, String prefix) {
        StringBuilder displayStr = new StringBuilder(type.getName());
        String packName = TypeNameUtil.getFullNamespace((EClassifier)type);
        if (packName.length() > 0) {
            displayStr.append(" - ");
            displayStr.append(packName);
        }
        String insertStr = insertString;
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), insertStr.length(), this.getTypeImage(), displayStr.toString(), null, null);
    }

    public ICompletionProposal createStatementProposal(String insertString, String displayString, String prefix, int cursor, int marked) {
        return new CompletionProposal(insertString, this.offset, prefix.length(), cursor, this.getStatementImage(), displayString, null, null);
    }

    public ICompletionProposal createStatementProposal(String insertString, String displayString, String prefix) {
        return this.createStatementProposal(insertString, displayString, prefix, insertString.length(), 0);
    }

    public ICompletionProposal createKeywordProposal(String insertString, String displayString, String prefix) {
        return new CompletionProposal(insertString, this.offset - prefix.length(), prefix.length(), insertString.length());
    }

    protected Image getTypeImage() {
        return EditorImages.getImage("type.gif");
    }

    protected Image getStatementImage() {
        return EditorImages.getImage("statement.gif");
    }

    protected Image getOperationImage() {
        return EditorImages.getImage("operation.gif");
    }

    protected Image getPropertyImage() {
        return EditorImages.getImage("property.gif");
    }

    protected Image getExtensionImage() {
        return EditorImages.getImage("extension.gif");
    }

    private Image getVariableImage() {
        return EditorImages.getImage("variable.gif");
    }
}

