/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand;

import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.eval.EvaluationListener;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;

class DumpEvaluationListener
extends EvaluationListener {
    private final StringBuilder sb = new StringBuilder(100);
    private int exprCount = 0;
    private int stmtCount = 0;

    DumpEvaluationListener() {
    }

    public void enter(Expression expr, ExecutionContext context) {
        this.print(expr.getClass().getSimpleName(), this.exprCount++, expr.getLine());
        this.sb.append(' ');
    }

    public void enter(Statement stmt, XpandExecutionContext context) {
        this.print(stmt.getClass().getSimpleName(), this.stmtCount++, stmt.getLine());
        this.sb.append(' ');
    }

    public void leave(Expression expr, ExecutionContext context) {
        this.sb.setLength(this.sb.length() - 1);
        this.print(expr.getClass().getSimpleName(), --this.exprCount, expr.getLine());
    }

    public void leave(Statement stmt, XpandExecutionContext context) {
        this.sb.setLength(this.sb.length() - 1);
        this.print(stmt.getClass().getSimpleName(), --this.stmtCount, stmt.getLine());
    }

    private void print(String x, int i, int line) {
        System.err.println(String.valueOf(this.sb.toString()) + x + i + ':' + line);
    }
}

