/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.type.baseimpl.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.expression.ExpressionFacade;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.tests.expression.ast.ATypeModel;

public class CollectionTypeTest
extends TestCase {
    private static final String REFERECE_NAME = "refC";
    private static final String REFERECE_CONTAINER_NAME = "containerA";
    private ExpressionFacade ef;

    protected void setUp() throws Exception {
        this.ef = new ExpressionFacade((ExecutionContext)new ExecutionContextImpl(null, new EPackage[0]));
    }

    public final void testStuff() {
        try {
            this.ef.evaluate("{Object.newInstance()} + 'b'");
            CollectionTypeTest.fail((String)"EvaluationException expected");
        }
        catch (EvaluationException evaluationException) {}
        CollectionTypeTest.assertTrue((boolean)((Set)this.ef.evaluate("{'a'}.union({'b'})")).contains("a"));
    }

    public final void testUnion() {
        Set result = (Set)this.ef.evaluate("{1,2}.union({2,3})");
        CollectionTypeTest.assertEquals((int)3, (int)result.size());
        Number l = (Number)this.ef.evaluate("{1,2}.union({2,3}).size()");
        CollectionTypeTest.assertEquals((int)3, (int)l.intValue());
    }

    public final void testIntersect() {
        Set result = (Set)this.ef.evaluate("{1,2,3}.intersect({2,3,4})");
        CollectionTypeTest.assertEquals((int)2, (int)result.size());
    }

    public final void testWithout() {
        Set result = (Set)this.ef.evaluate("{1,2,3}.without({2})");
        CollectionTypeTest.assertEquals((int)2, (int)result.size());
        CollectionTypeTest.assertFalse((boolean)result.contains(2));
    }

    public final void testWithoutKeepsOrder() {
        Set result = (Set)this.ef.evaluate("{1,2,3}.without({2})");
        CollectionTypeTest.assertEquals((int)2, (int)result.size());
        Iterator it = result.iterator();
        CollectionTypeTest.assertEquals((Object)new Integer(1), it.next());
        CollectionTypeTest.assertEquals((Object)new Integer(3), it.next());
        Set result2 = (Set)this.ef.evaluate("{1,2,3,1}.without({2})");
        CollectionTypeTest.assertEquals((int)2, (int)result2.size());
        it = result2.iterator();
        CollectionTypeTest.assertEquals((Object)new Integer(1), it.next());
        CollectionTypeTest.assertEquals((Object)new Integer(3), it.next());
    }

    public final void testToSet() {
        Set result = (Set)this.ef.evaluate("{1,2,3}.toSet()");
        CollectionTypeTest.assertEquals((int)3, (int)result.size());
        CollectionTypeTest.assertTrue((boolean)result.contains(2));
        Set result2 = (Set)this.ef.evaluate("{1,2,2,3}.toSet()");
        CollectionTypeTest.assertEquals((int)3, (int)result2.size());
        CollectionTypeTest.assertTrue((boolean)result2.contains(2));
    }

    public final void testSize() {
        CollectionTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.ef.evaluate("{1,2,3}.size() == 3"));
    }

    public final void testIsEmpty() {
        CollectionTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.ef.evaluate("{1,2,3}.isEmpty()"));
        CollectionTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.ef.evaluate("{}.isEmpty()"));
    }

    public final void testContains() {
        CollectionTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.ef.evaluate("{1,2,3}.contains(2)"));
        CollectionTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.ef.evaluate("{1,2,3}.contains('2')"));
        CollectionTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.ef.evaluate("{1,2,3}.contains(42)"));
    }

    public final void testContainsAll() {
        CollectionTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.ef.evaluate("{1,2,3}.containsAll({2})"));
        CollectionTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.ef.evaluate("{1,2,3}.containsAll({'2',2})"));
        CollectionTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.ef.evaluate("{1,2,3}.containsAll({42,1})"));
        CollectionTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.ef.evaluate("{1,2,3}.containsAll({3,2,1})"));
    }

    public final void testFirst() {
        CollectionTypeTest.assertEquals((Object)1, (Object)this.ef.evaluate("{1,2,3}.first()"));
        CollectionTypeTest.assertEquals(null, (Object)this.ef.evaluate("{}.first()"));
        CollectionTypeTest.assertEquals(null, (Object)this.ef.evaluate("null.first()"));
    }

    public final void testLast() {
        CollectionTypeTest.assertEquals((Object)3, (Object)this.ef.evaluate("{1,2,3}.last()"));
        CollectionTypeTest.assertNull((Object)this.ef.evaluate("{}.last()"));
        CollectionTypeTest.assertNull((Object)this.ef.evaluate("null.last()"));
    }

    public final void testWithoutFirst() {
        ArrayList<Integer> list2and3 = new ArrayList<Integer>();
        list2and3.add(2);
        list2and3.add(3);
        CollectionTypeTest.assertEquals(list2and3, (Object)this.ef.evaluate("{1,2,3}.withoutFirst()"));
        CollectionTypeTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.ef.evaluate("{1}.withoutFirst()"));
        CollectionTypeTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.ef.evaluate("{}.withoutFirst()"));
        CollectionTypeTest.assertEquals(null, (Object)this.ef.evaluate("null.withoutFirst()"));
    }

    public final void testWithoutLast() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(1);
        l.add(2);
        CollectionTypeTest.assertEquals(l, (Object)this.ef.evaluate("{1,2,3}.withoutLast()"));
        CollectionTypeTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.ef.evaluate("{1}.withoutLast()"));
        CollectionTypeTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.ef.evaluate("{}.withoutLast()"));
        CollectionTypeTest.assertEquals(null, (Object)this.ef.evaluate("null.withoutLast()"));
    }

    public final void testWithoutFirstLastAreImmutable() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(1);
        l.add(2);
        l.add(3);
        ArrayList masterCopy = new ArrayList(l);
        CollectionTypeTest.assertEquals((String)"Immutable withoutFirst", masterCopy, (Object)this.ef.evaluate("x.withoutFirst()->x", Collections.singletonMap("x", l)));
        CollectionTypeTest.assertEquals((String)"Immutable withoutLast", masterCopy, (Object)this.ef.evaluate("x.withoutLast()->x", Collections.singletonMap("x", l)));
    }

    public final void testPurgeDups() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("a");
        l.add("b");
        l.add("a");
        ArrayList masterCopy = new ArrayList(l);
        ArrayList noDupsList = new ArrayList(l);
        noDupsList.remove(2);
        CollectionTypeTest.assertEquals((String)"Immutable purgeDups", masterCopy, (Object)this.ef.evaluate("x.purgeDups()->x", Collections.singletonMap("x", l)));
        CollectionTypeTest.assertEquals((Object)new Integer(2), (Object)this.ef.evaluate("x.purgeDups().size()", Collections.singletonMap("x", l)));
        CollectionTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.ef.evaluate("x.purgeDups().get(1) == \"b\"", Collections.singletonMap("x", l)));
        CollectionTypeTest.assertEquals((String)"purgeDups should remove duplicates", noDupsList, (Object)this.ef.evaluate("x.purgeDups()", Collections.singletonMap("x", l)));
    }

    public final void testSetType() {
        this.analyzeCollectionExpression(false, true, "Set");
    }

    public final void testListType() {
        this.analyzeCollectionExpression(true, false, "List");
    }

    public final void testOrderedSetType() {
        this.analyzeCollectionExpression(true, true, "List");
    }

    private void analyzeCollectionExpression(boolean isOrdered, boolean isUnique, String requiredCollectionName) {
        EClass containerEClass = this.createCollectionReferenceMetainfo(isOrdered, isUnique);
        ExpressionFacade facade = new ExpressionFacade((ExecutionContext)new ExecutionContextImpl(null, null, Collections.singleton(new Variable(REFERECE_CONTAINER_NAME, (Object)containerEClass)), null));
        HashSet issues = new HashSet();
        String expression = "containerA.refC";
        EClassifier analyzationResut = facade.analyze(expression, issues);
        CollectionTypeTest.assertTrue((issues.size() == 0 ? 1 : 0) != 0);
        CollectionTypeTest.assertTrue((boolean)(analyzationResut instanceof EClass));
        EClass eClass = (EClass)analyzationResut;
        CollectionTypeTest.assertEquals((String)requiredCollectionName, (String)eClass.eClass().getName());
    }

    private EClass createCollectionReferenceMetainfo(boolean isOrdered, boolean isUnique) {
        ATypeModel typeModel = new ATypeModel();
        EClass aClass = typeModel.getMetaType();
        EClass cClass = typeModel.getMetaTypeC();
        EReference reference = EcoreFactory.eINSTANCE.createEReference();
        reference.setName(REFERECE_NAME);
        reference.setEType((EClassifier)cClass);
        reference.setOrdered(isOrdered);
        reference.setUnique(isUnique);
        reference.setUpperBound(-1);
        aClass.getEStructuralFeatures().add((Object)reference);
        return aClass;
    }
}

