/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.lite.commands.CreateNotationalElementCommand;
import org.eclipse.gmf.runtime.lite.services.IViewDecorator;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;

public class CreateNotationalEdgeCommand
extends CreateNotationalElementCommand {
    private final View source;
    private final View target;

    public CreateNotationalEdgeCommand(Diagram parent, EObject domainElement, View source, View target, IViewDecorator decorator) {
        super((View)parent);
        this.source = source;
        this.target = target;
        Edge edge = NotationFactory.eINSTANCE.createEdge();
        edge.setElement(domainElement);
        decorator.decorateView((View)edge);
        this.setCreatedView((View)edge);
    }

    protected boolean prepare() {
        if (this.getParent() == null || this.getCreatedView() == null || this.source == null || this.target == null) {
            return false;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.getParent());
        return domain == null || !domain.isReadOnly(this.getParent().eResource());
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        Edge createdEdge = (Edge)this.getCreatedView();
        ((Diagram)this.getParent()).insertEdge(createdEdge);
        createdEdge.setSource(this.source);
        createdEdge.setTarget(this.target);
    }

    public void undo() {
        Edge createdEdge = (Edge)this.getCreatedView();
        ((Diagram)this.getParent()).removeEdge(createdEdge);
        createdEdge.setSource(null);
        createdEdge.setTarget(null);
    }

    public void redo() {
        this.execute();
    }
}

